/*============================================================================
//	cpiud048s.c
//
//	CPI-UD048
//
//	Copyright CPI Technologies,Inc.
//
//	V1.00 Date 2011/03/23
//
//	̃\[Xɂ̓bp[֐̎gpႪLqĂ܂B
//
//==========================================================================*/
#define	STRICT
#include <windows.h>
#include <tchar.h>
#include "cpiud048w.h"

const TCHAR szTitle[] = _T("Sample");

static void ResultMessage(LPCTSTR lpszbuf);
static void ErrorMessage(WORD wLogDevice);
static TCHAR const* str_err( DWORD dwRes );

/*============================================================================
//	۸т̊Jn
//===========================================================================*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	WORD	wLogDevice;		/* foCX̘_ۯĔԍi[ */
	DWORD	dwDll;			/* Dllo[W */
	DWORD	dwDrv;			/* hCo[o[W */
	TD048DI di;				/* foCX̍\̕ϐ */
	DWORD	dwVal;			/* jbgZNgXCb`̒l */
	DWORD	dwDirs;			/* fBNV */
	BYTE	bDat;			/* o̓f[^ϐ */
	BYTE	bInterval;		/* ̓tB^@\ tB^TCN̐ݒ */
	BYTE	bCount;			/* ̓tB^@\ v񐔂̐ݒ */
	TCHAR	szBuf[512];

	/*-------------------------------------------------
	// cpiud048.dll ̎gp錾
	//-----------------------------------------------*/
	if ( ! UD048DllOpen() )
	{
		ResultMessage(_T("UD048DllOpen error"));
		goto errorHandlerDll;		/* cpiud048.dll ̃[hɎs܂ */
	}
	ResultMessage(_T("UD048DllOpen succeeded"));

	/*-------------------------------------------------
	// o[Wԍ擾
	//-----------------------------------------------*/
	if ( ! UD048GetVersion( &dwDll, &dwDrv ) )
	{
		ResultMessage(_T("GetVersion failed"));
		goto errorHandlerDll;
	}
	wsprintf(szBuf, _T("GetVersion\n\n")
					_T("DLL    Version\t: %08lxh\n")
					_T("Driver Version\t: %08lxh"),
					dwDll,
					dwDrv);
	ResultMessage(szBuf);

	/*-------------------------------------------------
	// CPI-UD048̎gp錾
	//-----------------------------------------------*/
	wLogDevice = D048_DEVICE_AUTO;			/* gp̃foCXT܂B*/
	if ( ! UD048Create( &wLogDevice, NULL, 0 ) )
	{
		ErrorMessage(D048_DEVICE_AUTO);
		goto errorHandlerDll;
	}
	wsprintf(szBuf, _T("CPI-UD048 Created\n\n")
			_T("Device # is: %2d"), wLogDevice);
	ResultMessage(szBuf);

	/*-------------------------------------------------
	// foCX擾
	//-----------------------------------------------*/
	if ( ! UD048GetDevInfo( wLogDevice, &di ) )
	{
		ErrorMessage(wLogDevice);
		goto errorHandlerDevice;
	}
	wsprintf(szBuf, _T("GetDevInfo\n\n")
					_T("wCdb  : %u\n" )
					_T("wSdb  : %u\n" )
	 				_T("dwBuff: %lu\n" )
					_T("sVen  : %.8hs\n" )
					_T("sDev  : %.16hs\n" )
					_T("sVer  : %.4hs" ),
					di.wCdb,
					di.wSdb,
					di.dwBuff,
					di.sVen,
					di.sDev,
					di.sVer);
	ResultMessage(szBuf);

	/*-------------------------------------------------
	// jbgZNgXCb`̒l擾
	//-----------------------------------------------*/
	if ( ! UD048GetSwitchValue( wLogDevice, &dwVal ) )
	{
		ErrorMessage(wLogDevice);
		goto errorHandlerDevice;
	}
	wsprintf(szBuf, _T("jbgZNgXCb`̒l\n\n")
					_T("SW Val: %lxh"), dwVal );
	ResultMessage(szBuf);

	/*-------------------------------------------------
	// Port A ̕o͂ɐݒ肷
	//-----------------------------------------------*/
	if ( ! UD048SetDirections( wLogDevice, D048_DIR_A_OUTPUT ) )
	{
		ErrorMessage(wLogDevice);
		goto errorHandlerDevice;
	}
	ResultMessage(_T("Port A ̕o͂ɕύX"));

	/*-------------------------------------------------
	// Port A AAh̃f[^o
	//-----------------------------------------------*/
	ResultMessage(_T("Port A փf[^o"));
	bDat = (BYTE)0xAA;			  /* o̓f[^Zbg AAh */
	if ( ! UD048OutPort( wLogDevice, D048_PORT_A, bDat ) )
	{
		ErrorMessage(wLogDevice);
		goto errorHandlerDevice;
	}
	wsprintf(szBuf, _T("o͊\n")
					_T("Port A Out Data: %02xh"), bDat);
	ResultMessage(szBuf);

	/*-------------------------------------------------
	// Port A FFh̃f[^o
	//-----------------------------------------------*/
	ResultMessage(_T("Port A փf[^o"));
	bDat = (BYTE)0xFF;			/* o̓f[^Zbg FFh */
	if ( ! UD048OutPort( wLogDevice, D048_PORT_A, bDat ) )
	{
		ErrorMessage(wLogDevice);
		goto errorHandlerDevice;
	}
	wsprintf(szBuf, _T("o͊\n\n")
					_T("Port A Out Data: %02xh"), bDat);
	ResultMessage(szBuf);

	/*-------------------------------------------------
	// Port̕Ԃ̊mF
	//-----------------------------------------------*/
	if ( ! UD048GetDirections( wLogDevice, &dwDirs ) )
	{
		ErrorMessage(wLogDevice);
		goto errorHandlerDevice;
	}
	wsprintf(szBuf, _T("Port̕\n\n")
					_T("DirVal: %02lxh"), dwDirs);
	ResultMessage(szBuf);

	/*-------------------------------------------------
	// Port B ͂̕ɐݒ
	//-----------------------------------------------*/
	ResultMessage(_T("Port B ͂̕ɕύX"));
	if ( ! UD048SetDirections( wLogDevice, D048_DIR_B_INPUT ) )
	{
		ErrorMessage(wLogDevice);
		goto errorHandlerDevice;
	}

	/*-------------------------------------------------
	// Port̕Ԃ̊mF
	//-----------------------------------------------*/
	if ( ! UD048GetDirections( wLogDevice, &dwDirs ) )
	{
		ErrorMessage(wLogDevice);
		goto errorHandlerDevice;
	}
	wsprintf(szBuf, _T("Port̕\n\n")
					_T("DirVal: %02lxh"), dwDirs);
	ResultMessage(szBuf);

	/*-------------------------------------------------
	// tB^̐ݒ
	//-----------------------------------------------*/
	ResultMessage(_T("̓|[gɑ΂ẴtB^ݒ"));

	bInterval = D048_FILTER_INTERVAL_1260;	/* tB^TCNZbg */
	bCount = 0x02;							/* v񐔃Zbg */

	if ( ! UD048SetFilter( wLogDevice, bInterval, bCount) )
	{
		ErrorMessage(wLogDevice);
		goto errorHandlerDevice;
	}
	wsprintf(szBuf, _T("tB^ݒ芮\n\n")
					_T("tB^TCNl\t= %u (1260uS)\n")
					_T("v񐔒l\t= %u (2)"),
					bInterval,
					bCount);

	ResultMessage(szBuf);

	/*-------------------------------------------------
	// Port B f[^ǂݍ
	//-----------------------------------------------*/
	ResultMessage(_T("Port B ̓̓f[^̓ǂݍ"));
	if ( ! UD048InPort( wLogDevice, D048_PORT_B, &bDat ) )
	{
		ErrorMessage(wLogDevice);
		goto errorHandlerDevice;
	}
	wsprintf(szBuf, _T("Port B ̓̓f[^\n\n")
					_T("Port B In Data: %02xh"), bDat);
	ResultMessage(szBuf);

errorHandlerDevice:
	/*-------------------------------------------------
	// CPI-UD048̎gpJ
	//-----------------------------------------------*/
	if ( ! UD048Close( wLogDevice ) )
		ErrorMessage( wLogDevice );
	else
		ResultMessage(_T("CPI-UD048 Closed"));

errorHandlerDll:
	/*-------------------------------------------------
	// cpiud048.dll ̎gpJ
	//-----------------------------------------------*/
	if ( ! UD048DllClose() )
		ErrorMessage( wLogDevice );
	else
		ResultMessage( _T( "UD048DllClose succeeded" ) );

	return 0;
}

/*============================================================================
// ʂ\
//===========================================================================*/
static void ResultMessage(LPCTSTR lpszbuf)
{
	MessageBox(NULL, lpszbuf, szTitle, MB_OK | MB_ICONINFORMATION);
}

/*============================================================================
// G[bZ[W\
//===========================================================================*/
static void ErrorMessage(WORD wLogDevice)
{
	DWORD dwRes;
	TCHAR szBuf[128];

	dwRes = UD048GetLastError( wLogDevice );

	wsprintf(szBuf, _T("GetLastError\n\n")
					_T("Error code: %08lxh(%s)"),
					dwRes, str_err( dwRes ));
	MessageBox(NULL, szBuf, szTitle, MB_OK | MB_ICONSTOP);
}

static TCHAR const* str_err( DWORD dwRes )
{
	switch ( dwRes )
	{
		case D048_SUCCESS:
			return _T( "Succeeded" );
		case D048_ERR_SYSTEM:
			return _T( "System error occured" );
		case D048_ERR_NO_DEVICE:
			return _T( "Device not found" );
		case D048_ERR_IN_USE:
			return _T( "Device is in use" );
		case D048_ERR_INVALID_DEVICENO:
			return _T( "Invalid device number" );
		case D048_ERR_INVALID_ARGUMENT:
			return _T( "Invalid argument" );
		case D048_ERR_INVALID_PORT:
			return _T( "Invalid port number" );
		case D048_ERR_BAD_DIRECTION:
			return _T( "Bad direction" );
		case D048_ERR_DLL:
			return _T( "DLL not opened" );
		case D048_ERR_TRG_DATA_INVALID:
			return _T( "Data not accord" );
		default:
			break;
	}
	return _T( "Unknown error" );
}
