/*============================================================================
//  cpiud048w.h
//
//  Copyright (C) 2011 CPI Technologies,Inc.
//==========================================================================*/
#pragma once

namespace Sample {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Data;
	using namespace System::Runtime::InteropServices;
	using namespace System::Diagnostics;

	public ref class CpiUd048
	{
		static int mErrWradll = SUCCESS;

		public:
			/*-----------------------------------------------------------------
			// 荞݃bZ[WID
			//---------------------------------------------------------------*/
			literal short WM_CHECK_TRG			 = 0x2000;	/* bZ[WID */

			/*-----------------------------------------------------------------
			// G[R[h
			//---------------------------------------------------------------*/
			literal int SUCCESS					= 0;		/* I*/
															/* Windows G[ */
			literal int ERR_SYSTEM				= 1;		/* GetLastError R[ */
			literal int ERR_NO_DEVICE			= 2;		/* gp\ȃfoCXȂ */
			literal int ERR_IN_USE				= 3;		/* wfoCX͎gpł */
			literal int ERR_INVALID_DEVICENO	= 4;		/* Ș_foCXԍ */
			literal int ERR_INVALID_ARGUMENT	= 5;		/* Ȉ */
			literal int ERR_INVALID_PORT		= 6;		/* Ș_|[g */
			literal int ERR_BAD_DIRECTION		= 7;		/* sȕ */
			literal int ERR_TRG_DATA_INVALID	= 8;		/*  |[gĎvf[^Ȃ */
			literal int ERR_DLL 				= -1;		/* DLL [hs */

			/*-----------------------------------------------------------------
			// ̑
			//---------------------------------------------------------------*/
			literal int MAX_DEVICES				= 16;
			literal short DEVICE_AUTO			= -1;

			/*-----------------------------------------------------------------
			// tB^TCN̐ݒ
			//---------------------------------------------------------------*/
			literal Byte FILTER_INTERVAL_STOP	= 0;
			literal Byte FILTER_INTERVAL_1260	= 1;
			literal Byte FILTER_INTERVAL_2520	= 2;
			literal Byte FILTER_INTERVAL_5040	= 3;
			literal Byte FILTER_INTERVAL_10080	= 4;
			literal Byte FILTER_INTERVAL_20160	= 5;

			/*-----------------------------------------------------------------
			// |[gĎ̏
			//---------------------------------------------------------------*/
			literal Byte MON_NODE				= 0;		/* Ȃ */
			literal Byte MON_ALT				= 1;		/* Ώۃrbgɕω */
			literal Byte MON_AND				= 2;		/* ΏۃrbgSv */
			literal Byte MON_OR					= 3;		/* Ώۃrbgv */

			/*-----------------------------------------------------------------
			// EIb`hbNJE^̏
			//---------------------------------------------------------------*/
			literal Byte WDT_FLAG_OFF			= 0;		/* EIb`hbN܂́ANO */
			literal Byte WDT_FLAG_ON			= 1;		/* EIb`hbNN */

			/*-----------------------------------------------------------------
			// EIb`hbNJE^̐ݒ
			//---------------------------------------------------------------*/
			literal Byte WDT_INTERVAL_STOP		= 0;
			literal Byte WDT_INTERVAL_126		= 1;
			literal Byte WDT_INTERVAL_252		= 2;
			literal Byte WDT_INTERVAL_504		= 3;
			literal Byte WDT_INTERVAL_1008		= 4;
			literal Byte WDT_INTERVAL_2016		= 5;

			/*-----------------------------------------------------------------
			// jbg^Cv
			//---------------------------------------------------------------*/
			literal int TYPE_TTL				= 0;
			literal int TYPE_CMOS				= 1;

			/*-----------------------------------------------------------------
			// _|[gԍ
			//---------------------------------------------------------------*/
			literal int PORT_A					= 0;
			literal int PORT_B					= 1;
			literal int PORT_C					= 2;
			literal int PORT_D					= 3;
			literal int PORT_E					= 4;
			literal int PORT_F					= 5;
			literal int MAX_PORTS				= 6;		/* |[g */

			/*-----------------------------------------------------------------
			// |[g
			//---------------------------------------------------------------*/
			literal int DIR_A_OUTPUT			= ( 0 << PORT_A );
			literal int DIR_A_INPUT				= ( 1 << PORT_A );
			literal int DIR_B_OUTPUT			= ( 0 << PORT_B );
			literal int DIR_B_INPUT				= ( 1 << PORT_B );
			literal int DIR_C_OUTPUT			= ( 0 << PORT_C );
			literal int DIR_C_INPUT				= ( 1 << PORT_C );
			literal int DIR_D_OUTPUT			= ( 0 << PORT_D );
			literal int DIR_D_INPUT				= ( 1 << PORT_D );
			literal int DIR_E_OUTPUT			= ( 0 << PORT_E );
			literal int DIR_E_INPUT				= ( 1 << PORT_E );
			literal int DIR_F_OUTPUT			= ( 0 << PORT_F );
			literal int DIR_F_INPUT				= ( 1 << PORT_F );
			literal int DIR_ALL_OUTPUT			= ( DIR_A_OUTPUT   \
													| DIR_B_OUTPUT \
													| DIR_C_OUTPUT \
													| DIR_D_OUTPUT \
													| DIR_E_OUTPUT \
													| DIR_F_OUTPUT \
												  );
			literal int DIR_ALL_INPUT			= ( DIR_A_INPUT     \
													| DIR_B_INPUT \
													| DIR_C_INPUT \
													| DIR_D_INPUT \
													| DIR_E_INPUT \
													| DIR_F_INPUT \
												  );

			/*-----------------------------------------------------------------
			// foCX
			//---------------------------------------------------------------*/
			literal int CCH_VEN					= 8;
			literal int CCH_DEV					= 16;
			literal int CCH_VER					= 4;

		public:
			[StructLayout(LayoutKind::Sequential)]
			value class DeviceInfo
			{
				public:
					short wCdb;				/* Bytes of command descriptor */
					short wSdb;				/* Bytes of status descriptor */
					int   dwBuff;			/* Bytes of internal buffer */
					[MarshalAs(UnmanagedType::ByValArray, SizeConst = CCH_VEN)]
					array<Byte> ^ sVen;		/* vendor name */
					[MarshalAs(UnmanagedType::ByValArray, SizeConst = CCH_DEV)]
					array<Byte> ^ sDev;		/* device name */
					[MarshalAs(UnmanagedType::ByValArray, SizeConst = CCH_VER)]
					array<Byte> ^ sVer;		/* firmware version */
			};

		public:
			[StructLayout(LayoutKind::Sequential)]
			value class TriggerCond			/* |[gĎݒ̍\ */
			{
				public:
					Byte bMode;				/* |[gĎ[h */
					Byte bMask;				/* |[gĎ}XN */
					Byte bData;				/* |[gĎf[^ */
			};

		public:
			/*-----------------------------------------------------------------
			// APIGg
			//---------------------------------------------------------------*/
			[DllImport("cpiud048.dll")]
			static int  D048GetLastError(short wLogDevice);
			[DllImport("cpiud048.dll")]
			static bool D048GetVersion(int* pdwDllVersion, int* pdwDriverVersion);
			[DllImport("cpiud048.dll")]
			static bool D048Create(short* pwLogDevice, int hwnd, short uWMCode);
			[DllImport("cpiud048.dll")]
			static bool D048Close(short wLogDevice );
			[DllImport("cpiud048.dll")]
			static bool D048GetDevInfo(short wLogDevice, DeviceInfo% pDevInfo);
			[DllImport("cpiud048.dll")]
			static bool D048GetUnitType(short wLogDevice, int* pdwType);
			[DllImport("cpiud048.dll")]
			static bool D048GetSwitchValue(short wLogDevice, int* pdwSwitchValue);
			[DllImport("cpiud048.dll")]
			static bool D048GetDirections(short wLogDevice, int* pdwDirections);
			[DllImport("cpiud048.dll")]
			static bool D048SetDirections(short wLogDevice, int dwDirections);
			[DllImport("cpiud048.dll")]
			static bool D048InPort(short wLogDevice, int dwLogPort, Byte* pbInValue);
			[DllImport("cpiud048.dll")]
			static bool D048OutPort(short wLogDevice, int dwLogPort, Byte bOutValue);
			[DllImport("cpiud048.dll")]
			static bool D048SetWdt(short wLogDevice, Byte bWdtValue);
			[DllImport("cpiud048.dll")]
			static bool D048ResetWdt(short wLogDevice);
			[DllImport("cpiud048.dll")]
			static bool D048SetDefaultOutput(short wLogDevice, int dwLogPort, Byte bDefaultValue);
			[DllImport("cpiud048.dll")]
			static bool D048GetWdtStatus(short wLogDevice, Byte* pbWdtStatus);
			[DllImport("cpiud048.dll")]
			static bool D048SetTrgCond(short wLogDevice, int dwLogPort, TriggerCond% pTrgCond);
			[DllImport("cpiud048.dll")]
			static bool D048SetFilter(short wLogDevice, Byte bInterval, Byte bCount);

			[DllImport("cpiud048.dll")]
			static bool d048_init();
			[DllImport("cpiud048.dll")]
			static bool d048_done();

		/*======================================================================
		// RXgN^
		//====================================================================*/
		public: CpiUd048()
		{
			try
			{
				if (d048_init() == false)
				{
					Debug::Print("CPI-UD048 ERROR");
					mErrWradll = ERR_DLL;
				}
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
			}
		};

		/*======================================================================
		// I(fXgN^)
		//====================================================================*/
		public: ~CpiUd048()
		{
			try
			{
				(void)d048_done();
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
			}
		};

		/*======================================================================
		// 		ŌɔG[̃R[h擾
		// 		wLogDevice	G[foCX̘_foCXԍ
		// ߂l	G[R[h
		//====================================================================*/
		public: int GetLastErr(short wLogDevice)
		{
			try
			{
				if (mErrWradll == ERR_DLL)			// bp[֐G[Ȃ
				{
					mErrWradll = SUCCESS;			// NA
					return ERR_DLL;
				}
				else
				{
					return D048GetLastError(wLogDevice);
				}
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		o[Wԍ擾
		// 		pdwDllVersion		DLL o[Wԍi[̈ւ̃|C^
		//			pdwDriverVersion	hCoo[Wԍi[̈ւ̃|C^
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool GetVersion(int* pdwDllVersion, int* pdwDriverVersion)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048GetVersion(pdwDllVersion, pdwDriverVersion);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		foCX̎gp錾
		// 		pwLogDevice	gpfoCX̘_foCXԍi[|C^
		//			hwnd		|[gĎ@\gpꍇɃhCoo郁bZ[W󂯎
		//						EBhẼnhw肵܂B
		//						bZ[WgpȂꍇ NULL w肵܂B
		//			uWMCode		|[gĎ@\gpꍇɑo郁bZ[W ID ̒lw肵܂B
		//						ʏ WM_USER (0x400) ȏ̒lw肵܂B
		//						bZ[WgpȂꍇ NULL w肵܂B
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool Create(short* pwLogDevice, int hwnd, short uWMCode)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048Create(pwLogDevice, hwnd, uWMCode);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		gp̃foCX
		// 		wLogDevice	foCX̘_foCXԍ
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool Close(short wLogDevice)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048Close(wLogDevice);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		foCX擾
		// 		wLogDevice	l擾_foCXԍ
		//			pDevInfo	foCXi[\̂̃|C^
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool GetDevInfo(short wLogDevice, DeviceInfo% pDevInfo)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048GetDevInfo(wLogDevice, pDevInfo);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		jbg^Cv擾
		// 		wLogDevice	l擾foCX̘_foCXԍ
		//			pdwType		^Cvli[̈ւ̃|C^
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool GetUnitType(short wLogDevice, int* pdwType)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048GetUnitType(wLogDevice, pdwType);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		jbgZNgXCb`̒l擾
		// 		wLogDevice		l擾foCX̘_foCXԍ
		//			pdwSwitchValue	jbgZNgXCb`̒li[̈ւ̃|C^
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool GetSwitchValue(short wLogDevice, int* pdwSwitchValue)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048GetSwitchValue(wLogDevice, pdwSwitchValue);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		擾
		// 		wLogDevice		̏Ԃ擾foCX̘_foCXԍ
		//			pdwDirections	Ԃi[̈ւ̃|C^
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool GetDirections(short wLogDevice, int*  pdwDirections)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048GetDirections(wLogDevice, pdwDirections);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		ݒ
		// 		wLogDevice		ZbgfoCX̘_foCXԍ
		//			dwDirections	Zbg̓e
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool SetDirections(short wLogDevice, int dwDirections)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048SetDirections(wLogDevice, dwDirections);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		Cӂ̃|[gf[^
		// 		wLogDevice	͂foCX̘_foCXԍ
		//			dwLogPort	͂_|[g
		//			pbInValue	̓f[^i[̈ւ̃|C^
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool InPort(short wLogDevice, int dwLogPort, Byte* pbInValue)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048InPort(wLogDevice, dwLogPort, pbInValue);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		Cӂ̃|[gփf[^o
		// 		wLogDevice	o͂foCX̘_foCXԍ
		//			dwLogPort	o͂_|[g
		//			bOutValue	o͂f[^
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool OutPort(short wLogDevice, int dwLogPort, Byte bOutValue)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048OutPort(wLogDevice, dwLogPort, bOutValue);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		EIb`hbNJE^̐ݒ肨уEIb`hbN@\̊JnA~
		// 		wLogDevice	lݒ肷foCX̘_foCXԍ
		//			bWdtValue	JE^l (0`5)
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool SetWdt(short wLogDevice, Byte bWdtValue)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048SetWdt(wLogDevice, bWdtValue);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		EIb`hbNJE^lɂ
		// 		wLogDevice	lݒ肷foCX̘_foCXԍ
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool ResetWdt(short wLogDevice)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048ResetWdt(wLogDevice);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		EIb`hbNJE^oߌ̏o͂|[gђl̐ݒ
		// 		wLogDevice		lݒ肷foCX̘_foCXԍ
		//			dwLogPort   	o͂_|[g
		//			bDefaultValue	o͂f[^
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool SetDefaultOutput(short wLogDevice, int dwLogPort, Byte bDefaultValue)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048SetDefaultOutput(wLogDevice, dwLogPort, bDefaultValue);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		EIb`hbNJE^̏Ԃ擾
		// 		wLogDevice	l擾foCX̘_foCXԍ
		//			pbWdtStatus	EIb`hbNtOԂi[̈ւ̃|C^
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool GetWdtStatus(short wLogDevice, Byte* pbWdtStatus)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048GetWdtStatus(wLogDevice, pbWdtStatus);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		|[gĎ̐ݒ
		// 		wLogDevice	lݒ肷foCX̘_foCXԍ
		//			dwLogPort	Ď|[g̘_ԍw
		//			pTrgCond	|[gĎli[̈ւ̃|C^
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool SetTrgCond(short wLogDevice, int dwLogPort, TriggerCond% pTrgCond)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048SetTrgCond(wLogDevice, dwLogPort, pTrgCond);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}
		/*======================================================================
		// 		tB^TCNAv񐔂̐ݒ
		// 		wLogDevice	lݒ肷foCX̘_foCXԍ
		//			bInterval	tB^[TCNl (0`5)
		//			bCount		v񐔁iCӁj
		// ߂l	 TRUE
		//			s FALSE
		//====================================================================*/
		public: bool SetFilter(short wLogDevice, Byte bInterval, Byte bCount)
		{
			mErrWradll = SUCCESS;
			try
			{
				return D048SetFilter(wLogDevice, bInterval, bCount);
			}
			catch (Exception^e)
			{
				Debug::Print(e->Message);
				mErrWradll = ERR_DLL;
				return false;
			}
		}

	};
}
