/******************************************************************************
//	cpiud048s.h
//
//	CPI-UD048
//
//	Copyright CPI Technologies,Inc.
//
//	V1.00 Date 2011/03/23
//
//	̿ɂׯ߰֐̎gpႪLqĂ܂B
//
/******************************************************************************/

#pragma once

#include <windows.h>
#include "cpiud048w.h"


namespace Sample {

	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace System::Security::Permissions;

	/// <summary>
	/// Form1 ̊Tv
	///
	/// x: ̃NX̖OύXꍇÃNXˑ邷ׂĂ .resx t@CɊ֘Atꂽ
	///          }l[W \[X RpC c[ɑ΂ 'Resource File Name' vpeB
	///          ύXKv܂B̕ύXsȂƁA
	///          fUCiƁÃtH[Ɋ֘Atꂽ[JCYς݃\[XƂA
	///          ݂ɗpłȂȂ܂B
	/// </summary>
	public ref class Form1 : public System::Windows::Forms::Form
	{
	public:
		Form1(void)
		{
			InitializeComponent();
			//
			//TODO: ɃRXgN^ R[hǉ܂
			//
		}

	protected:
		/// <summary>
		/// gp̃\[XׂăN[Abv܂B
		/// </summary>
		~Form1()
		{
			if (components)
			{
				delete components;
			}
		}

	private:
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		System::ComponentModel::Container ^components;

		static CpiUd048^ Ud048;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		void InitializeComponent(void)
		{
			this->SuspendLayout();
			// 
			// Form1
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 12);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(292, 266);
			this->Name = L"Form1";
			this->StartPosition = System::Windows::Forms::FormStartPosition::CenterScreen;
			this->Text = L"CPI-UD048 Sample";
			this->Load += gcnew System::EventHandler(this, &Form1::Form1_Load);
			this->ResumeLayout(false);

		}
#pragma endregion
	private: System::Void Form1_Load(System::Object^  sender, System::EventArgs^  e) {
				int i;
				short	wLogDevice;		/* foCX̘_ۯĔԍi[ */
				int	dwDll;				/* Dllo[W */
				int	dwDrv;				/* hCo[o[W */
				int	dwVal;				/* jbgZNgXCb`̒l */
				int	dwDirs;				/* fBNV */
				Byte	bDat;			/* o̓f[^ϐ */
				Byte	bInterval;		/* ̓tB^@\ tB^TCN̐ݒ */
				Byte	bCount;			/* ̓tB^@\ v񐔂̐ݒ */
				String^ szBuf;
				CpiUd048::DeviceInfo^  DevInfo;	/* ޲̍\̕ϐ */
				CpiUd048::TriggerCond^ TrgCond;
				String^ szVen;
				String^ szDev;
				String^ szVer;

				// 
				Ud048 = gcnew CpiUd048();
				DevInfo = gcnew CpiUd048::DeviceInfo();
				DevInfo->wCdb = 0;
				DevInfo->wSdb = 0;
				DevInfo->dwBuff = 0;
				DevInfo->sVen = gcnew array<Byte>(CpiUd048::CCH_VEN);
				DevInfo->sDev = gcnew array<Byte>(CpiUd048::CCH_DEV);
				DevInfo->sVer = gcnew array<Byte>(CpiUd048::CCH_VER);
				for (i = 0; i < CpiUd048::CCH_VEN; i++)
					 DevInfo->sVen[i] = 0;
				for (i = 0; i < CpiUd048::CCH_DEV; i++)
					 DevInfo->sDev[i] = 0;
				for (i = 0; i < CpiUd048::CCH_VER; i++)
					 DevInfo->sVer[i] = 0;
				TrgCond = gcnew CpiUd048::TriggerCond();
				TrgCond->bMode = 0;
				TrgCond->bMask = 0;
				TrgCond->bData = 0;

				/*-------------------------------------------------
				// o[Wԍ擾
				//-----------------------------------------------*/
				if (Ud048->GetVersion(&dwDll, &dwDrv) == false)
				{
					ResultMessage("GetVersion failed");
					goto errorHandlerDll;
				}
				szBuf = String::Concat("GetVersion\n\n",
										String::Format("DLL    Version: {0:x8}h\n", dwDll),
										String::Format("Driver Version: {0:x8}h", dwDrv));
				ResultMessage(szBuf);

				/*-------------------------------------------------
				// CPI-UD048̎gp錾
				//-----------------------------------------------*/
				wLogDevice = CpiUd048::DEVICE_AUTO;		/* gp̃foCXT܂B*/
				if (Ud048->Create(&wLogDevice, 0, 0) == false)
				{
					ErrorMessage(CpiUd048::DEVICE_AUTO);
					goto errorHandlerDll;
				}
				szBuf = String::Concat("CPI-UD048 Created\n\n" +
										String::Format("Device # is: {0}", wLogDevice));
				ResultMessage(szBuf);

				/*-------------------------------------------------
				// foCX擾
				//-----------------------------------------------*/
				CpiUd048::DeviceInfo% di = *DevInfo;
				if (Ud048->GetDevInfo(wLogDevice, di) == false)
				{
					ErrorMessage(wLogDevice);
					goto errorHandlerDevice;
				}
				szVen = "";
				for (i = 0; i < CpiUd048::CCH_VEN; i++)
				{
					if (DevInfo->sVen[i] == 0) break;
					szVen = szVen + (Char)DevInfo->sVen[i];
				}
				szDev = "";
				for (i = 0; i < CpiUd048::CCH_DEV; i++)
				{
					if (DevInfo->sDev[i] == 0) break;
					szDev = szDev + (Char)DevInfo->sDev[i];
				}
				szVer = "";
				for (i = 0; i < CpiUd048::CCH_VER; i++)
				{
					if (DevInfo->sVer[i] == 0) break;
					szVer = szVer + (Char)DevInfo->sVer[i];
				}
				szBuf = String::Concat("GetDevInfo\n\n" +
										String::Format("wCdb  : {0}\n", DevInfo->wCdb),
										String::Format("wSdb  : {0}\n", DevInfo->wSdb),
										String::Format("dwBuff: {0}\n", DevInfo->dwBuff),
										szVen->Trim() + "\n",
										szDev->Trim() + "\n",
										szVer->Trim());
				ResultMessage(szBuf);

				/*-------------------------------------------------
				// jbgZNgXCb`̒l擾
				//-----------------------------------------------*/
				if (Ud048->GetSwitchValue(wLogDevice, &dwVal) == false)
				{
					ErrorMessage(wLogDevice);
					goto errorHandlerDevice;
				}
				szBuf = String::Concat("jbgZNgXCb`̒l\n\n" +
										String::Format("SW Val: {0:x}h", dwVal));
				ResultMessage(szBuf);

				/*-------------------------------------------------
				// Port A ̕o͂ɐݒ肷
				//-----------------------------------------------*/
				if (Ud048->SetDirections(wLogDevice, CpiUd048::DIR_A_OUTPUT) == false)
				{
					ErrorMessage(wLogDevice);
					goto errorHandlerDevice;
				}
				ResultMessage("Port A ̕o͂ɕύX");

				/*-------------------------------------------------
				// Port A AAh̃f[^o
				//-----------------------------------------------*/
				ResultMessage("Port A փf[^o");
				bDat = 0xAA;			  /* o̓f[^Zbg AAh */
				if (Ud048->OutPort(wLogDevice, CpiUd048::PORT_A, bDat) == false)
				{
					ErrorMessage(wLogDevice);
					goto errorHandlerDevice;
				}
				szBuf = String::Concat("o͊\n" +
										String::Format("Port A Out Data: {0:x2}h", bDat));
				ResultMessage(szBuf);

				/*-------------------------------------------------
				// Port A FFh̃f[^o
				//-----------------------------------------------*/
				ResultMessage("Port A փf[^o");
				bDat = 0xFF;			/* o̓f[^Zbg FFh */
				if (Ud048->OutPort(wLogDevice, CpiUd048::PORT_A, bDat) == false)
				{
					ErrorMessage(wLogDevice);
					goto errorHandlerDevice;
				}
				szBuf = String::Concat("o͊\n\n" +
										String::Format("Port A Out Data: {0:x2}h", bDat));
				ResultMessage(szBuf);

				/*-------------------------------------------------
				// Port̕Ԃ̊mF
				//-----------------------------------------------*/
				if (Ud048->GetDirections(wLogDevice, &dwDirs) == false)
				{
					ErrorMessage(wLogDevice);
					goto errorHandlerDevice;
				}
				szBuf = String::Format("Port̕\n\n" +
										String::Format("DirVal: {0:x2}h", dwDirs));
				ResultMessage(szBuf);

				/*-------------------------------------------------
				// Port B ͂̕ɐݒ
				//-----------------------------------------------*/
				ResultMessage("Port B ͂̕ɕύX");
				if (Ud048->SetDirections(wLogDevice, CpiUd048::DIR_B_INPUT) == false)
				{
					ErrorMessage(wLogDevice);
					goto errorHandlerDevice;
				}

				/*-------------------------------------------------
				// Port̕Ԃ̊mF
				//-----------------------------------------------*/
				if (Ud048->GetDirections(wLogDevice, &dwDirs) == false)
				{
					ErrorMessage(wLogDevice);
					goto errorHandlerDevice;
				}
				szBuf = String::Concat("Port̕\n\n" +
										String::Format("DirVal: {0:x2}h", dwDirs));
				ResultMessage(szBuf);

				/*-------------------------------------------------
				// tB^̐ݒ
				//-----------------------------------------------*/
				ResultMessage("̓|[gɑ΂ẴtB^ݒ");

				bInterval = CpiUd048::FILTER_INTERVAL_1260;	/* tB^TCNZbg */
				bCount = 0x02;								/* v񐔃Zbg */
				if (Ud048->SetFilter(wLogDevice, bInterval, bCount) == false)
				{
					ErrorMessage(wLogDevice);
					goto errorHandlerDevice;
				}
				szBuf = String::Concat("tB^ݒ芮\n\n" +
										String::Format("tB^TCNl\t= {0} (1260uS)\n", bInterval),
										String::Format("v񐔒l\t= {0} (2)", bCount));
				ResultMessage(szBuf);

				/*-------------------------------------------------
				// Port B f[^ǂݍ
				//-----------------------------------------------*/
				ResultMessage("Port B ̓̓f[^̓ǂݍ");
				if (Ud048->InPort(wLogDevice, CpiUd048::PORT_B, &bDat) == false)
				{
					ErrorMessage(wLogDevice);
					goto errorHandlerDevice;
				}
				szBuf = String::Concat("Port B ̓̓f[^\n\n" +
										String::Format("Port B In Data: {0:x2}h", bDat));
				ResultMessage(szBuf);

			errorHandlerDevice:
				/*-------------------------------------------------
				// CPI-UD048̎gpJ
				//-----------------------------------------------*/
				if (Ud048->Close(wLogDevice) == false)
					ErrorMessage(wLogDevice);
				else
					ResultMessage("CPI-UD048 Closed");

			errorHandlerDll:
				/*-------------------------------------------------
				// I(fXgN^)
				//-----------------------------------------------*/
				delete Ud048;

				this->Close();
			}

	/*============================================================================
	// ʂ\
	//===========================================================================*/
	private: void ResultMessage(String^ pszBuf) {
				MessageBox::Show(pszBuf, this->Text, MessageBoxButtons::OK, MessageBoxIcon::Information);
			}

	/*============================================================================
	// װүނ\
	//===========================================================================*/
	private: void ErrorMessage(short wLogDevice) {
				int dwRes = Ud048->GetLastErr(wLogDevice);
				String^ szBuf;

				szBuf = str_err(dwRes);
				szBuf = String::Concat("GetLastError\n\n",
										String::Format("Error code: {0:x8}h", dwRes),
										String::Concat(szBuf));
				MessageBox::Show(szBuf, this->Text, MessageBoxButtons::OK, MessageBoxIcon::Stop);
			}

	private: String^ str_err(int dwRes) {
				switch (dwRes)
				{
					case CpiUd048::SUCCESS:
						return "(Succeeded)";
					case CpiUd048::ERR_SYSTEM:
						return "(System error occured)";
					case CpiUd048::ERR_NO_DEVICE:
						return "(Device not found)";
					case CpiUd048::ERR_IN_USE:
						return "(Device is in use)";
					case CpiUd048::ERR_INVALID_DEVICENO:
						return "(Invalid device number)";
					case CpiUd048::ERR_INVALID_ARGUMENT:
						return "(Invalid argument)";
					case CpiUd048::ERR_INVALID_PORT:
						return "(Invalid port number)";
					case CpiUd048::ERR_BAD_DIRECTION:
						return "(Bad direction)";
					case CpiUd048::ERR_DLL:
						return "(DLL not opened)";
					case CpiUd048::ERR_TRG_DATA_INVALID:
						return "(Data not accord)";
					default:
						return "(Unknown error)";
				}
			}

	};
}

