﻿'======================================================================
' cpiud048w.vb
'
'  Copyright (C) 2011 CPI Technologies,Inc.
'======================================================================

Option Strict Off
Option Explicit On

Imports System
Imports System.Runtime.InteropServices


Public Class CpiUd048
    Implements IDisposable
    Private disposedValue As Boolean = False ' 重複する呼び出しを検出するには

    Private mErrWradll As Integer = SUCCESS             ' ラッパー関数内エラー

    '-----------------------------------------------------------------
    ' 割り込みメッセージID
    '-----------------------------------------------------------------
    Public Const WM_CHECK_TRG As Integer = &H2000       ' メッセージID

    '-----------------------------------------------------------------
    ' エラーコード
    '-----------------------------------------------------------------
    Public Const SUCCESS As Integer = 0                 ' 正常終了
    Public Const ERR_SYSTEM As Integer = 1              ' GetLastError をコール
    Public Const ERR_NO_DEVICE As Integer = 2           ' 使用可能なデバイスがない
    Public Const ERR_IN_USE As Integer = 3              ' 指定デバイスは使用中です
    Public Const ERR_INVALID_DEVICENO As Integer = 4    ' 無効な論理デバイス番号
    Public Const ERR_INVALID_ARGUMENT As Integer = 5    ' 無効な引数
    Public Const ERR_INVALID_PORT As Integer = 6        ' 無効な論理ポート
    Public Const ERR_BAD_DIRECTION As Integer = 7       ' 不正な方向
    Public Const ERR_TRG_DATA_INVALID As Integer = 8    ' ポート監視条件一致データがない
    Public Const ERR_DLL As Integer = -1                ' DLL ロード失敗

    '-----------------------------------------------------------------
    ' その他
    '-----------------------------------------------------------------
    Public Const MAX_DEVICES As Integer = 16
    Public Const DEVICE_AUTO As Short = -1

    '-----------------------------------------------------------------
    ' フィルタサイクルの設定
    '-----------------------------------------------------------------
    Public Const FILTER_INTERVAL_STOP As Byte = 0
    Public Const FILTER_INTERVAL_1260 As Byte = 1
    Public Const FILTER_INTERVAL_2520 As Byte = 2
    Public Const FILTER_INTERVAL_5040 As Byte = 3
    Public Const FILTER_INTERVAL_10080 As Byte = 4
    Public Const FILTER_INTERVAL_20160 As Byte = 5

    '-----------------------------------------------------------------
    ' ポート監視の条件
    '-----------------------------------------------------------------
    Public Const MON_NODE As Byte = 0           ' 条件なし
    Public Const MON_ALT As Byte = 1            ' 対象ビットに変化あり
    Public Const MON_AND As Byte = 2            ' 対象ビット全一致
    Public Const MON_OR As Byte = 3             ' 対象ビット部分一致

    '-----------------------------------------------------------------
    ' ウオッチドックカウンタの状態
    '---------------------------------------------------------------*/
    Public Const WDT_FLAG_OFF As Byte = 0       ' ウオッチドックが無効または、起動前
    Public Const WDT_FLAG_ON As Byte = 1        ' ウオッチドックが起動

    '-----------------------------------------------------------------
    ' ウオッチドックカウンタの設定
    '-----------------------------------------------------------------
    Public Const WDT_INTERVAL_STOP As Byte = 0
    Public Const WDT_INTERVAL_126 As Byte = 1
    Public Const WDT_INTERVAL_252 As Byte = 2
    Public Const WDT_INTERVAL_504 As Byte = 3
    Public Const WDT_INTERVAL_1008 As Byte = 4
    Public Const WDT_INTERVAL_2016 As Byte = 5

    '-----------------------------------------------------------------
    ' ユニットタイプ
    '-----------------------------------------------------------------
    Public Const TYPE_TTL As Integer = 0
    Public Const TYPE_CMOS As Integer = 1

    '-----------------------------------------------------------------
    ' 論理ポート番号
    '-----------------------------------------------------------------
    Public Const PORT_A As Integer = 0
    Public Const PORT_B As Integer = 1
    Public Const PORT_C As Integer = 2
    Public Const PORT_D As Integer = 3
    Public Const PORT_E As Integer = 4
    Public Const PORT_F As Integer = 5
    Public Const MAX_PORTS As Integer = 6   ' ポート数

    '-----------------------------------------------------------------
    ' ポート方向
    '-----------------------------------------------------------------
    Public Const DIR_A_OUTPUT As Integer = (0 << PORT_A)
    Public Const DIR_A_INPUT As Integer = (1 << PORT_A)
    Public Const DIR_B_OUTPUT As Integer = (0 << PORT_B)
    Public Const DIR_B_INPUT As Integer = (1 << PORT_B)
    Public Const DIR_C_OUTPUT As Integer = (0 << PORT_C)
    Public Const DIR_C_INPUT As Integer = (1 << PORT_C)
    Public Const DIR_D_OUTPUT As Integer = (0 << PORT_D)
    Public Const DIR_D_INPUT As Integer = (1 << PORT_D)
    Public Const DIR_E_OUTPUT As Integer = (0 << PORT_E)
    Public Const DIR_E_INPUT As Integer = (1 << PORT_E)
    Public Const DIR_F_OUTPUT As Integer = (0 << PORT_F)
    Public Const DIR_F_INPUT As Integer = (1 << PORT_F)
    Public Const DIR_ALL_OUTPUT As Integer = (DIR_A_OUTPUT Or DIR_B_OUTPUT Or DIR_C_OUTPUT Or DIR_D_OUTPUT Or DIR_E_OUTPUT Or DIR_F_OUTPUT)
    Public Const DIR_ALL_INPUT As Integer = (DIR_A_INPUT Or DIR_B_INPUT Or DIR_C_INPUT Or DIR_D_INPUT Or DIR_E_INPUT Or DIR_F_INPUT)

    '-----------------------------------------------------------------
    ' デバイス情報
    '-----------------------------------------------------------------
    Public Const CCH_VEN As Integer = 8 - 1
    Public Const CCH_DEV As Integer = 16 - 1
    Public Const CCH_VER As Integer = 4 - 1

    Structure DeviceInfo
        Dim wCdb As Short                                   ' bytes of command descriptor
        Dim wSdb As Short                                   ' bytes of status descriptor
        Dim dwBuff As Integer                               ' bytes of internal buffer
        <VBFixedArray(CCH_VEN), MarshalAs(UnmanagedType.ByValArray, _
            SizeConst:=CCH_VEN + 1)> Dim sVen() As Byte     ' vendor name
        <VBFixedArray(CCH_VEN), MarshalAs(UnmanagedType.ByValArray, _
            SizeConst:=CCH_DEV + 1)> Dim sDev() As Byte     ' device name
        <VBFixedArray(CCH_VEN), MarshalAs(UnmanagedType.ByValArray, _
            SizeConst:=CCH_VER + 1)> Dim sVer() As Byte     ' firmware version
    End Structure

    Structure TriggerCond           ' ポート監視設定の構造体
        Dim bMode As Byte           ' ポート監視モード
        Dim bMask As Byte           ' ポート監視マスク
        Dim bData As Byte           'ポート監視データ
    End Structure


    '-----------------------------------------------------------------
    ' APIエントリ
    '-----------------------------------------------------------------
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048GetLastError(ByVal wLogDevice As Short) As Integer
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048GetVersion(ByRef pdwDllVersion As Integer, ByRef pdwDriverVersion As Integer) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048Create(ByRef pwLogDevice As Short, ByVal hwnd As Integer, ByVal uWMCode As Short) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048Close(ByVal wLogDevice As Short) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048GetDevInfo(ByVal wLogDevice As Short, ByRef pDevInfo As DeviceInfo) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048GetUnitType(ByVal wLogDevice As Short, ByRef pdwType As Integer) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048GetSwitchValue(ByVal wLogDevice As Short, ByRef pdwSwitchValue As Integer) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048GetDirections(ByVal wLogDevice As Short, ByRef pdwDirections As Integer) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048SetDirections(ByVal wLogDevice As Short, ByVal dwDirections As Integer) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048InPort(ByVal wLogDevice As Short, ByVal dwLogPort As Integer, ByRef pbInValue As Byte) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048OutPort(ByVal wLogDevice As Short, ByVal dwLogPort As Integer, ByVal bOutValue As Byte) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048SetWdt(ByVal wLogDevice As Short, ByVal bWdtValue As Byte) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048ResetWdt(ByVal wLogDevice As Short) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048SetDefaultOutput(ByVal wLogDevice As Short, ByVal dwLogPort As Integer, ByVal bDefaultValue As Byte) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048GetWdtStatus(ByVal wLogDevice As Short, ByRef pbWdtStatus As Byte) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048SetTrgCond(ByVal wLogDevice As Short, ByRef dwLogPort As Integer, ByRef pTrgCond As TriggerCond) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function D048SetFilter(ByVal wLogDevice As Short, ByVal bInterval As Byte, ByVal bCount As Byte) As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function d048_init() As Boolean
    End Function
    <DllImport("cpiud048.dll")> _
    Public Shared Function d048_done() As Boolean
    End Function


    '======================================================================
    ' コンストラクタ
    '======================================================================
    Public Sub New()
        Try
            If d048_init() = False Then
                Debug.Print("CPI-UD048 Error")
                mErrWradll = ERR_DLL
            End If
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
        End Try

    End Sub

    '======================================================================
    ' 終了処理
    '======================================================================
    Protected Overridable Sub Dispose(ByVal disposing As Boolean)
        If Not Me.disposedValue Then
            If disposing Then
                ' TODO: 明示的に呼び出されたときにアンマネージ リソースを解放します
                Try
                    Call d048_done()
                Catch e As Exception
                    Debug.Print(e.Message)
                    mErrWradll = ERR_DLL
                End Try
            End If

            ' TODO: 共有のアンマネージ リソースを解放します
        End If
        Me.disposedValue = True
    End Sub

#Region " IDisposable Support "
    Public Sub Dispose() Implements IDisposable.Dispose
        ' このコードを変更しないでください。
        Dispose(True)
        GC.SuppressFinalize(Me)
    End Sub
#End Region

    '======================================================================
    ' 説明		最後に発生したエラーのコードを取得
    ' 引数		wLogDevice	エラーが発生したデバイスの論理デバイス番号
    ' 戻り値	エラーコード
    '======================================================================
    Public Function GetLastError(ByVal wLogDevice As Short) As Integer
        Try
            If mErrWradll = ERR_DLL Then        ' ラッパー関数内エラーならば
                mErrWradll = SUCCESS            ' クリア
                GetLastError = ERR_DLL
            Else
                GetLastError = D048GetLastError(wLogDevice)
            End If
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            GetLastError = ERR_DLL
        End Try
    End Function
    '======================================================================
    ' 説明		バージョン番号取得
    ' 引数		pdwDllVersion		DLL バージョン番号を格納する領域へのポインタ
    '			pdwDriverVersion	ドライババージョン番号を格納する領域へのポインタ
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function GetVersion(ByRef pdwDllVersion As Integer, ByRef pdwDriverVersion As Integer) As Integer
        Try
            GetVersion = D048GetVersion(pdwDllVersion, pdwDriverVersion)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            GetVersion = False
        End Try
    End Function
    '======================================================================
    ' 説明		デバイスの使用を宣言
    ' 引数		pwLogDevice	使用するデバイスの論理デバイス番号を格納するポインタ
    '			hwnd		ポート監視機能を使用する場合にドライバが送出するメッセージを受け取る
    '						ウィンドウのハンドルを指定します。
    '						メッセージを使用しない場合は NULL を指定します。
    '			uWMCode		ポート監視機能を使用する場合に送出するメッセージ ID の値を指定します。
    '						通常 WM_USER (0x400) 以上の値を指定します。
    '						メッセージを使用しない場合は NULL を指定します。
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function Create(ByRef pwLogDevice As Short, ByVal hwnd As Integer, ByVal uWMCode As Short)
        Try
            Create = D048Create(pwLogDevice, hwnd, uWMCode)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            Create = False
        End Try
    End Function
    '======================================================================
    ' 説明		使用中のデバイスを解放
    ' 引数		wLogDevice	解放するデバイスの論理デバイス番号
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function Close(ByVal wLogDevice As Short) As Boolean
        Try
            Close = D048Close(wLogDevice)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            Close = False
        End Try
    End Function
    '======================================================================
    ' 説明		デバイス情報を取得
    ' 引数		wLogDevice	値を取得する論理デバイス番号
    '			pDevInfo	デバイス情報を格納する構造体のポインタ
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function GetDevInfo(ByVal wLogDevice As Short, ByRef pDevInfo As DeviceInfo) As Boolean
        Try
            GetDevInfo = D048GetDevInfo(wLogDevice, pDevInfo)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            GetDevInfo = False
        End Try
    End Function
    '======================================================================
    ' 説明		ユニットタイプを取得
    ' 引数		wLogDevice	値を取得するデバイスの論理デバイス番号
    '			pdwType		タイプ値を格納する領域へのポインタ
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function GetUnitType(ByVal wLogDevice As Short, ByRef pdwType As Integer) As Boolean
        Try
            GetUnitType = D048GetUnitType(wLogDevice, pdwType)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            GetUnitType = False
        End Try
    End Function
    '======================================================================
    ' 説明		ユニットセレクトスイッチの値を取得
    ' 引数		wLogDevice		値を取得するデバイスの論理デバイス番号
    '			pdwSwitchValue	ユニットセレクトスイッチの値を格納する領域へのポインタ
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function GetSwitchValue(ByVal wLogDevice As Short, ByRef pdwSwitchValue As Integer) As Boolean
        Try
            GetSwitchValue = D048GetSwitchValue(wLogDevice, pdwSwitchValue)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            GetSwitchValue = False
        End Try
    End Function
    '======================================================================
    ' 説明		方向取得
    ' 引数		wLogDevice		方向の状態を取得するデバイスの論理デバイス番号
    '			pdwDirections	方向状態を格納する領域へのポインタ
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function GetDirections(ByVal wLogDevice As Short, ByRef pdwDirections As Integer) As Boolean
        Try
            GetDirections = D048GetDirections(wLogDevice, pdwDirections)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            GetDirections = False
        End Try
    End Function
    '======================================================================
    ' 説明		方向設定
    ' 引数		wLogDevice		方向をセットするデバイスの論理デバイス番号
    '			dwDirections	セットする方向の内容
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function SetDirections(ByVal wLogDevice As Short, ByVal dwDirections As Integer) As Boolean
        Try
            SetDirections = D048SetDirections(wLogDevice, dwDirections)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            SetDirections = False
        End Try
    End Function
    '======================================================================
    ' 説明		任意のポートからデータを入力
    ' 引数		wLogDevice	入力するデバイスの論理デバイス番号
    '			dwLogPort	入力する論理ポート
    '			pbInValue	入力データを格納する領域へのポインタ
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function InPort(ByVal wLogDevice As Short, ByVal dwLogPort As Integer, ByRef pbInValue As Byte) As Boolean
        Try
            InPort = D048InPort(wLogDevice, dwLogPort, pbInValue)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            InPort = False
        End Try
    End Function
    '======================================================================
    ' 説明		任意のポートへデータ出力
    ' 引数		wLogDevice	出力するデバイスの論理デバイス番号
    '			dwLogPort	出力する論理ポート
    '			bOutValue	出力するデータ
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function OutPort(ByVal wLogDevice As Short, ByVal dwLogPort As Integer, ByVal bOutValue As Byte) As Boolean
        Try
            OutPort = D048OutPort(wLogDevice, dwLogPort, bOutValue)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            OutPort = False
        End Try
    End Function
    '======================================================================
    ' 説明		ウオッチドックカウンタの設定およびウオッチドック機能の開始、停止
    ' 引数		wLogDevice	値を設定するデバイスの論理デバイス番号
    '			bWdtValue	カウンタ値 (0～5)
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function SetWdt(ByVal wLogDevice As Short, ByVal bWdtValue As Byte) As Boolean
        Try
            SetWdt = D048SetWdt(wLogDevice, bWdtValue)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            SetWdt = False
        End Try
    End Function
    '======================================================================
    ' 説明		ウオッチドックカウンタを初期値にする
    ' 引数		wLogDevice	値を設定するデバイスの論理デバイス番号
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function ResetWdt(ByVal wLogDevice As Short) As Boolean
        Try
            ResetWdt = D048ResetWdt(wLogDevice)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            ResetWdt = False
        End Try
    End Function
    '======================================================================
    ' 説明		ウオッチドックカウンタ経過後の出力するポートおよび値の設定
    ' 引数		wLogDevice		値を設定するデバイスの論理デバイス番号
    '			dwLogPort   	出力する論理ポート
    '			bDefaultValue	出力するデータ
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function SetDefaultOutput(ByVal wLogDevice As Short, ByVal dwLogPort As Integer, ByVal bDefaultValue As Byte) As Boolean
        Try
            SetDefaultOutput = D048SetDefaultOutput(wLogDevice, dwLogPort, bDefaultValue)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            SetDefaultOutput = False
        End Try
    End Function
    '======================================================================
    ' 説明		ウオッチドックカウンタの状態を取得
    ' 引数		wLogDevice	値を取得するデバイスの論理デバイス番号
    '			pbWdtStatus	ウオッチドックフラグ状態を格納する領域へのポインタ
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function GetWdtStatus(ByVal wLogDevice As Short, ByRef pbWdtStatus As Byte) As Boolean
        Try
            GetWdtStatus = D048GetWdtStatus(wLogDevice, pbWdtStatus)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            GetWdtStatus = False
        End Try
    End Function
    '======================================================================
    ' 説明		ポート監視の設定
    ' 引数		wLogDevice	値を設定するデバイスの論理デバイス番号
    '			dwLogPort	監視をするポートの論理番号を指定
    '			pTrgCond	ポート監視値を格納する領域へのポインタ
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function SetTrgCond(ByVal wLogDevice As Short, ByVal dwLogPort As Integer, ByRef pTrgCond As TriggerCond) As Boolean
        Try
            SetTrgCond = D048SetTrgCond(wLogDevice, dwLogPort, pTrgCond)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            SetTrgCond = False
        End Try
    End Function
    '======================================================================
    ' 説明		フィルタサイクル、一致回数の設定
    ' 引数		wLogDevice	値を設定するデバイスの論理デバイス番号
    '			bInterval	フィルターサイクル値 (0～5)
    '			bCount		一致回数（任意）
    ' 戻り値	成功 TRUE
    '			失敗 FALSE
    '======================================================================
    Public Function SetFilter(ByVal wLogDevice As Short, ByVal bInterval As Byte, ByVal bCount As Byte) As Boolean
        Try
            SetFilter = D048SetFilter(wLogDevice, bInterval, bCount)
        Catch e As Exception
            Debug.Print(e.Message)
            mErrWradll = ERR_DLL
            SetFilter = False
        End Try
    End Function

End Class
