﻿'============================================================================
' cpiud048s.vb
'
' CPI-UD048制御
'
' Copyright CPI Technologies,Inc.
'
' V1.00 Date 2011/03/23
'
' このｿｰｽにはﾗｯﾊﾟｰ関数の使用例が記述されています。
'
'==========================================================================*/

Option Strict Off
Option Explicit On

Imports System.Runtime.InteropServices

Public Class cpiud048s

    Dim Ud048 As CpiUd048

    Private Sub cpiud048s_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim i As Integer
        Dim wLogDevice As Short         ' デバイスの論理ｽﾛｯﾄ番号を格納
        Dim dwDll As Integer            ' Dllバージョン
        Dim dwDrv As Integer            ' ドライバーバージョン
        Dim dwVal As Integer            ' ユニットセレクトスイッチの値
        Dim dwDirs As Integer           ' ディレクション
        Dim bDat As Byte                ' 入出力データ変数
        Dim bInterval As Byte           ' 入力フィルタ機能 フィルタサイクルの設定
        Dim bCount As Byte              ' 入力フィルタ機能 一致回数の設定
        Dim szBuf As String
        Dim szVen As String, szDev As String, szVer As String
        Dim di As CpiUd048.DeviceInfo   ' ﾃﾞﾊﾞｲｽ情報の構造体変数
        Dim tc As CpiUd048.TriggerCond

        ' 初期化
        Ud048 = New CpiUd048()
        di = New CpiUd048.DeviceInfo()
        di.wCdb = 0
        di.wSdb = 0
        di.dwBuff = 0
        di.sVen = New Byte(CpiUd048.CCH_VEN) {}
        di.sDev = New Byte(CpiUd048.CCH_DEV) {}
        di.sVer = New Byte(CpiUd048.CCH_VER) {}
        For i = 0 To CpiUd048.CCH_VEN
            di.sVen(i) = 0
        Next
        For i = 0 To CpiUd048.CCH_DEV
            di.sDev(i) = 0
        Next
        For i = 0 To CpiUd048.CCH_VER
            di.sVer(i) = 0
        Next
        tc = New CpiUd048.TriggerCond()
        tc.bMode = 0
        tc.bMask = 0
        tc.bData = 0

        '-------------------------------------------------
        ' バージョン番号取得
        '-------------------------------------------------
        If Ud048.GetVersion(dwDll, dwDrv) = False Then
            ResultMessage("GetVersion failed")
            GoTo errorHandlerDll
        End If
        szBuf = String.Concat("GetVersion", Chr(10) + Chr(10) + _
                                String.Format("DLL    Version: {0:x8}h" + Chr(10), dwDll), _
                                String.Format("Driver Version: {0:x8}h", dwDrv))
        ResultMessage(szBuf)

        '-------------------------------------------------
        ' CPI-UD048の使用を宣言
        '-------------------------------------------------
        wLogDevice = CpiUd048.DEVICE_AUTO       ' 未使用のデバイスを探します。
        If Ud048.Create(wLogDevice, 0, 0) = False Then
            ErrorMessage(CpiUd048.DEVICE_AUTO)
            GoTo errorHandlerDll
        End If
        szBuf = String.Concat("CPI-UD048 Created" + Chr(10) + Chr(10), _
                                String.Format("Device # is: {0}", wLogDevice))
        ResultMessage(szBuf)

        '-------------------------------------------------
        ' デバイス情報を取得
        '-------------------------------------------------
        If Ud048.GetDevInfo(wLogDevice, di) = False Then
            ErrorMessage(wLogDevice)
            GoTo errorHandlerDevice
        End If
        szVen = ""
        For i = 0 To CpiUd048.CCH_VEN
            If di.sVen(i) = 0 Then Exit For
            szVen = szVen + Chr(di.sVen(i))
        Next
        szDev = ""
        For i = 0 To CpiUd048.CCH_DEV
            If di.sDev(i) = 0 Then Exit For
            szDev = szDev + Chr(di.sDev(i))
        Next
        szVer = ""
        For i = 0 To CpiUd048.CCH_VER
            If di.sVer(i) = 0 Then Exit For
            szVer = szVer + Chr(di.sVer(i))
        Next
        szBuf = String.Concat("GetDevInfo" + Chr(10) + Chr(10) + _
                                String.Format("wCdb  : {0}" + Chr(10), di.wCdb), _
                                String.Format("wSdb  : {0}" + Chr(10), di.wSdb), _
                                String.Format("dwBuff: {0}" + Chr(10), di.dwBuff), _
                                szVen.Trim() + Chr(10), _
                                szDev.Trim() + Chr(10), _
                                szVer.Trim())
        ResultMessage(szBuf)

        '-------------------------------------------------
        ' ユニットセレクトスイッチの値を取得
        '-------------------------------------------------
        If Ud048.GetSwitchValue(wLogDevice, dwVal) = False Then
            ErrorMessage(wLogDevice)
            GoTo errorHandlerDevice
        End If
        szBuf = String.Concat("ユニットセレクトスイッチの値" + Chr(10) + Chr(10) + _
                                String.Format("SW Val: {0:x}h", dwVal))
        ResultMessage(szBuf)

        '-------------------------------------------------
        ' Port A の方向を出力に設定する
        '-------------------------------------------------
        If Ud048.SetDirections(wLogDevice, CpiUd048.DIR_A_OUTPUT) = False Then
            ErrorMessage(wLogDevice)
            GoTo errorHandlerDevice
        End If
        ResultMessage("Port A の方向を出力に変更")

        '-------------------------------------------------
        ' Port A にAAhのデータを出力
        '-------------------------------------------------
        ResultMessage("Port A へデータ出力")
        bDat = &HAA           ' 出力データセット AAh
        If Ud048.OutPort(wLogDevice, CpiUd048.PORT_A, bDat) = False Then
            ErrorMessage(wLogDevice)
            GoTo errorHandlerDevice
        End If
        szBuf = String.Concat("出力完了" + Chr(10) + Chr(10) + _
                                String.Format("Port A Out Data: {0:x2}h", bDat))
        ResultMessage(szBuf)

        '-------------------------------------------------
        ' Port A にFFhのデータを出力
        '-------------------------------------------------
        ResultMessage("Port A へデータを出力")
        bDat = &HFF         ' 出力データセット FFh
        If Ud048.OutPort(wLogDevice, CpiUd048.PORT_A, bDat) = False Then
            ErrorMessage(wLogDevice)
            GoTo errorHandlerDevice
        End If
        szBuf = String.Concat("出力完了" + Chr(10) + Chr(10) + _
                                String.Format("Port A Out Data: {0:x2}h", bDat))
        ResultMessage(szBuf)

        '-------------------------------------------------
        ' Portの方向状態の確認
        '-------------------------------------------------
        If Ud048.GetDirections(wLogDevice, dwDirs) = False Then
            ErrorMessage(wLogDevice)
            GoTo errorHandlerDevice
        End If
        szBuf = String.Format("Portの方向状態" + Chr(10) + Chr(10) + _
                                String.Format("DirVal: {0:x2}h", dwDirs))
        ResultMessage(szBuf)

        '-------------------------------------------------
        ' Port B の方向を入力に設定
        '-------------------------------------------------
        ResultMessage("Port B の方向を入力に変更")
        If Ud048.SetDirections(wLogDevice, CpiUd048.DIR_B_INPUT) = False Then
            ErrorMessage(wLogDevice)
            GoTo errorHandlerDevice
        End If

        '-------------------------------------------------
        ' Portの方向状態の確認
        '-------------------------------------------------
        If Ud048.GetDirections(wLogDevice, dwDirs) = False Then
            ErrorMessage(wLogDevice)
            GoTo errorHandlerDevice
        End If
        szBuf = String.Concat("Portの方向状態" + Chr(10) + Chr(10) + _
                                String.Format("DirVal: {0:x2}h", dwDirs))
        ResultMessage(szBuf)

        '-------------------------------------------------
        ' フィルタ条件の設定
        '-------------------------------------------------
        ResultMessage("入力ポートに対してのフィルタ条件設定")

        bInterval = CpiUd048.FILTER_INTERVAL_1260   ' フィルタサイクルセット
        bCount = &H2                                ' 一致回数セット
        If Ud048.SetFilter(wLogDevice, bInterval, bCount) = False Then
            ErrorMessage(wLogDevice)
            GoTo errorHandlerDevice
        End If
        szBuf = String.Concat("フィルタ条件設定完了" + Chr(10) + Chr(10) + _
                                String.Format("フィルタサイクル値 = {0} (1260uS)" + Chr(10), bInterval), _
                                String.Format("一致回数値         = {0} (2回)", bCount))
        ResultMessage(szBuf)

        '-------------------------------------------------
        ' Port B からデータを読み込む
        '-------------------------------------------------
        ResultMessage("Port B からの入力データの読み込み")
        If Ud048.InPort(wLogDevice, CpiUd048.PORT_B, bDat) = False Then
            ErrorMessage(wLogDevice)
            GoTo errorHandlerDevice
        End If
        szBuf = String.Concat("Port B の入力データ" + Chr(10) + Chr(10) + _
                                String.Format("Port B In Data: {0:x2}h", bDat))
        ResultMessage(szBuf)

errorHandlerDevice:
        '-------------------------------------------------
        ' CPI-UD048の使用を開放
        '-------------------------------------------------
        If Ud048.Close(wLogDevice) = False Then
            ErrorMessage(wLogDevice)
        Else
            ResultMessage("CPI-UD048 Closed")
        End If

errorHandlerDll:
        '-------------------------------------------------
        ' 終了処理
        '-------------------------------------------------
        Ud048.Dispose()

        Me.Close()
    End Sub

    '============================================================================
    ' 処理結果を表示
    '============================================================================
    Private Sub ResultMessage(ByVal lpszbuf As String)
        MsgBox(lpszbuf, MsgBoxStyle.OkOnly + MsgBoxStyle.Information, Me.Text)
    End Sub

    '============================================================================
    ' ｴﾗｰﾒｯｾｰｼﾞを表示
    '============================================================================
    Private Sub ErrorMessage(ByVal wLogDevice As Short)
        Dim dwRes As Integer
        Dim szBuf As String

        dwRes = Ud048.GetLastError(wLogDevice)
        szBuf = str_err(dwRes)
        szBuf = String.Concat("GetLastError" + vbCrLf + vbCrLf, _
                                    String.Format("Error code: {0:x8}h", dwRes), _
                                    String.Concat(szBuf))
        MsgBox(szBuf, MsgBoxStyle.OkOnly + MsgBoxStyle.Critical, Me.Text)
    End Sub


    Private Function str_err(ByVal dwRes As Integer) As String

        Select Case dwRes
            Case CpiUd048.SUCCESS
                str_err = "(Succeeded)"
            Case CpiUd048.ERR_SYSTEM
                str_err = "(System error occured)"
            Case CpiUd048.ERR_NO_DEVICE
                str_err = "(Device not found)"
            Case CpiUd048.ERR_IN_USE
                str_err = "(Device is in use)"
            Case CpiUd048.ERR_INVALID_DEVICENO
                str_err = "(Invalid device number)"
            Case CpiUd048.ERR_INVALID_ARGUMENT
                str_err = "(Invalid argument)"
            Case CpiUd048.ERR_INVALID_PORT
                str_err = "(Invalid port number)"
            Case CpiUd048.ERR_BAD_DIRECTION
                str_err = "(Bad direction)"
            Case CpiUd048.ERR_DLL
                str_err = "(DLL not opened)"
            Case CpiUd048.ERR_TRG_DATA_INVALID
                str_err = "(Data not accord)"
            Case Else
                str_err = "(Unknown error)"
        End Select

    End Function

End Class
