/*============================================================================
//  cpiud048w.cs
//
//  Copyright (C) 2011 CPI Technologies,Inc.
//==========================================================================*/
using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Runtime.InteropServices;
using System.Diagnostics;

namespace Sample
{
    public class CpiUd048
    {
        private int mErrWradll = SUCCESS;	        /* bp[֐G[ */

        /*-----------------------------------------------------------------
        // 荞݃bZ[WID
        //---------------------------------------------------------------*/
        public const int WM_CHECK_TRG = 0x2000;     /* bZ[WID */

        /*-----------------------------------------------------------------
        // G[R[h
        //---------------------------------------------------------------*/
        public const int SUCCESS = 0;               /* I*/
                                                    /* Windows G[ */
        public const int ERR_SYSTEM = 1;            /* GetLastError R[ */
        public const int ERR_NO_DEVICE = 2;         /* gp\ȃfoCXȂ */
        public const int ERR_IN_USE = 3;            /* wfoCX͎gpł */
        public const int ERR_INVALID_DEVICENO = 4;  /* Ș_foCXԍ */
        public const int ERR_INVALID_ARGUMENT = 5;  /* Ȉ */
        public const int ERR_INVALID_PORT = 6;      /* Ș_|[g */
        public const int ERR_BAD_DIRECTION = 7;     /* sȕ */
        public const int ERR_TRG_DATA_INVALID = 8;  /* |[gĎvf[^Ȃ */
        public const int ERR_DLL = -1;	            /* DLL [hs */

        /*-----------------------------------------------------------------
        // ̑
        //---------------------------------------------------------------*/
        public const int MAX_DEVICES = 16;
        public const short DEVICE_AUTO = -1;

        /*-----------------------------------------------------------------
        // tB^TCN̐ݒ
        //---------------------------------------------------------------*/
        public const byte FILTER_INTERVAL_STOP = 0;
        public const byte FILTER_INTERVAL_1260 = 1;
        public const byte FILTER_INTERVAL_2520 = 2;
        public const byte FILTER_INTERVAL_5040 = 3;
        public const byte FILTER_INTERVAL_10080 = 4;
        public const byte FILTER_INTERVAL_20160 = 5;

        /*-----------------------------------------------------------------
        // |[gĎ̏
        //---------------------------------------------------------------*/
        public const byte MON_NODE = 0;         /* Ȃ */
        public const byte MON_ALT = 1;          /* Ώۃrbgɕω */
        public const byte MON_AND = 2;          /* ΏۃrbgSv */
        public const byte MON_OR = 3;           /* Ώۃrbgv */

        /*-----------------------------------------------------------------
        // EIb`hbNJE^̏
        //---------------------------------------------------------------*/
        public const byte WDT_FLAG_OFF = 0;     /* EIb`hbN܂́ANO */
        public const byte WDT_FLAG_ON = 1;      /* EIb`hbNN */

        /*-----------------------------------------------------------------
        // EIb`hbNJE^̐ݒ
        //---------------------------------------------------------------*/
        public const byte WDT_INTERVAL_STOP = 0;
        public const byte WDT_INTERVAL_126 = 1;
        public const byte WDT_INTERVAL_252 = 2;
        public const byte WDT_INTERVAL_504 = 3;
        public const byte WDT_INTERVAL_1008 = 4;
        public const byte WDT_INTERVAL_2016 = 5;

        /*-----------------------------------------------------------------
        // jbg^Cv
        //---------------------------------------------------------------*/
        public const int TYPE_TTL = 0;
        public const int TYPE_CMOS = 1;

        /*-----------------------------------------------------------------
        // _|[gԍ
        //---------------------------------------------------------------*/
        public const int PORT_A = 0;
        public const int PORT_B = 1;
        public const int PORT_C = 2;
        public const int PORT_D = 3;
        public const int PORT_E = 4;
        public const int PORT_F = 5;
        public const int MAX_PORTS = 6;     /* |[g */

        /*-----------------------------------------------------------------
        // |[g
        //---------------------------------------------------------------*/
        public const int DIR_A_OUTPUT   = (0 << PORT_A);
        public const int DIR_A_INPUT    = (1 << PORT_A);
        public const int DIR_B_OUTPUT   = (0 << PORT_B);
        public const int DIR_B_INPUT    = (1 << PORT_B);
        public const int DIR_C_OUTPUT   = (0 << PORT_C);
        public const int DIR_C_INPUT    = (1 << PORT_C);
        public const int DIR_D_OUTPUT   = (0 << PORT_D);
        public const int DIR_D_INPUT    = (1 << PORT_D);
        public const int DIR_E_OUTPUT   = (0 << PORT_E);
        public const int DIR_E_INPUT    = (1 << PORT_E);
        public const int DIR_F_OUTPUT   = (0 << PORT_F);
        public const int DIR_F_INPUT    = (1 << PORT_F);
        public const int DIR_ALL_OUTPUT = (DIR_A_OUTPUT
                                            | DIR_B_OUTPUT
                                            | DIR_C_OUTPUT
                                            | DIR_D_OUTPUT
                                            | DIR_E_OUTPUT
                                            | DIR_F_OUTPUT);
        public const int DIR_ALL_INPUT = (DIR_A_INPUT
                                            | DIR_B_INPUT
                                            | DIR_C_INPUT
                                            | DIR_D_INPUT
                                            | DIR_E_INPUT
                                            | DIR_F_INPUT);

        /*-----------------------------------------------------------------
        // foCX
        //---------------------------------------------------------------*/
        public const int CCH_VEN = 8;
        public const int CCH_DEV = 16;
        public const int CCH_VER = 4;

        [StructLayout(LayoutKind.Sequential)]
        public struct DeviceInfo
        {
            public short wCdb;          /* bytes of command descriptor */
            public short wSdb;          /* bytes of status descriptor */
            public int   dwBuff;        /* bytes of internal buffer */
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CCH_VEN)]
            public byte[] sVen;         /* vendor name */
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CCH_DEV)]
            public byte[] sDev;         /* device name */
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = CCH_VER)]
            public byte[] sVer;         /* firmware version */
        };

        [StructLayout(LayoutKind.Sequential)]
        public struct TriggerCond       /* |[gĎݒ̍\ */
        {
            public byte bMode;          /* |[gĎ[h */
            public byte bMask;          /* |[gĎ}XN */
            public byte bData;          /* |[gĎf[^ */
        }

        /*-----------------------------------------------------------------
        // APIGg
        //---------------------------------------------------------------*/
        [DllImport("cpiud048.dll")]
        public extern static int D048GetLastError(short wLogDevice);
        [DllImport("cpiud048.dll")]
        public extern static unsafe bool D048GetVersion(int* pdwDllVersion, int* pdwDriverVersion);
        [DllImport("cpiud048.dll")]
        public extern static unsafe bool D048Create(short* pwLogDevice, int hwnd, short uWMCode);
        [DllImport("cpiud048.dll")]
        public extern static bool D048Close(short wLogDevice);
        [DllImport("cpiud048.dll")]
        public extern static bool D048GetDevInfo(short wLogDevice, ref DeviceInfo pDevInfo);
        [DllImport("cpiud048.dll")]
        public extern static unsafe bool D048GetUnitType(short wLogDevice, int* pdwType);
        [DllImport("cpiud048.dll")]
        public extern static unsafe bool D048GetSwitchValue(short wLogDevice, int* pdwSwitchValue);
        [DllImport("cpiud048.dll")]
        public extern static unsafe bool D048GetDirections(short wLogDevice, int* pdwDirections);
        [DllImport("cpiud048.dll")]
        public extern static bool D048SetDirections(short wLogDevice, int dwDirections);
        [DllImport("cpiud048.dll")]
        public extern static unsafe bool D048InPort(short wLogDevice, int dwLogPort, byte* pbInValue);
        [DllImport("cpiud048.dll")]
        public extern static bool D048OutPort(short wLogDevice, int dwLogPort, byte bOutValue);
        [DllImport("cpiud048.dll")]
        public extern static bool D048SetWdt(short wLogDevice, byte bWdtValue);
        [DllImport("cpiud048.dll")]
        public extern static bool D048ResetWdt(short wLogDevice);
        [DllImport("cpiud048.dll")]
        public extern static bool D048SetDefaultOutput(short wLogDevice, int dwLogPort, byte bDefaultValue);
        [DllImport("cpiud048.dll")]
        public extern static unsafe bool D048GetWdtStatus(short wLogDevice, byte* pbWdtStatus);
        [DllImport("cpiud048.dll")]
        public extern static bool D048SetTrgCond(short wLogDevice, int dwLogPort, ref TriggerCond pTrgCond);
        [DllImport("cpiud048.dll")]
        public extern static bool D048SetFilter(short wLogDevice, byte bInterval, byte bCount);
        [DllImport("cpiud048.dll")]
        public extern static bool d048_init();
        [DllImport("cpiud048.dll")]
        public extern static bool d048_done();

        /*======================================================================
        // RXgN^
        //====================================================================*/
        public CpiUd048()
        {
            try
            {
                if (d048_init() == false)
                {
                    Debug.Print("CPI-UD048 Error");
                    mErrWradll = ERR_DLL;
                }
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
            }
        }
        /*======================================================================
        // I
        //====================================================================*/
        public void Dispose()
        {
            try
            {
                d048_done();
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
            }
        }

        /*======================================================================
        // 		ŌɔG[̃R[h擾
        // 		wLogDevice	G[foCX̘_foCXԍ
        // ߂l	G[R[h
        //====================================================================*/
        public int GetLastError(short wLogDevice)
        {
            try
            {
                if (mErrWradll == ERR_DLL)      // bp[֐G[Ȃ
                {
                    mErrWradll = SUCCESS;		// NA
                    return ERR_DLL;
                } 
                else 
                {
                    return D048GetLastError(wLogDevice);
                }
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return ERR_DLL;
            }
        }
        /*======================================================================
        // 		o[Wԍ擾
        // 		pdwDllVersion		DLL o[Wԍi[̈ւ̃|C^
        //			pdwDriverVersion	hCoo[Wԍi[̈ւ̃|C^
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public unsafe bool GetVersion(int* pdwDllVersion, int* pdwDriverVersion)
        {
            try
            {
                return D048GetVersion(pdwDllVersion, pdwDriverVersion);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		foCX̎gp錾
        // 		pwLogDevice	gpfoCX̘_foCXԍi[|C^
        //			hwnd		|[gĎ@\gpꍇɃhCoo郁bZ[W󂯎
        //						EBhẼnhw肵܂B
        //						bZ[WgpȂꍇ NULL w肵܂B
        //			uWMCode		|[gĎ@\gpꍇɑo郁bZ[W ID ̒lw肵܂B
        //						ʏ WM_USER (0x400) ȏ̒lw肵܂B
        //						bZ[WgpȂꍇ NULL w肵܂B
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public unsafe bool Create(short* pwLogDevice, int hwnd, short uWMCode)
        {
            try
            {
                return D048Create(pwLogDevice, hwnd, uWMCode);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		gp̃foCX
        // 		wLogDevice	foCX̘_foCXԍ
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public bool Close(short wLogDevice)
        {
            try
            {
                return D048Close(wLogDevice);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		foCX擾
        // 		wLogDevice	l擾_foCXԍ
        //			pDevInfo	foCXi[\̂̃|C^
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public bool GetDevInfo(short wLogDevice, ref DeviceInfo pDevInfo)
        {
            try
            {
                return D048GetDevInfo(wLogDevice, ref pDevInfo);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		jbg^Cv擾
        // 		wLogDevice	l擾foCX̘_foCXԍ
        //			pdwType		^Cvli[̈ւ̃|C^
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public unsafe bool GetUnitType(short wLogDevice, int* pdwType)
        {
            try
            {
                return D048GetUnitType(wLogDevice, pdwType);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		jbgZNgXCb`̒l擾
        // 		wLogDevice		l擾foCX̘_foCXԍ
        //			pdwSwitchValue	jbgZNgXCb`̒li[̈ւ̃|C^
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public unsafe bool GetSwitchValue(short wLogDevice, int* pdwSwitchValue)
        {
            try
            {
                return D048GetSwitchValue(wLogDevice, pdwSwitchValue);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		擾
        // 		wLogDevice		̏Ԃ擾foCX̘_foCXԍ
        //			pdwDirections	Ԃi[̈ւ̃|C^
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public unsafe bool GetDirections(short wLogDevice, int* pdwDirections)
        {
            try
            {
                return D048GetDirections(wLogDevice, pdwDirections);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		ݒ
        // 		wLogDevice		ZbgfoCX̘_foCXԍ
        //			dwDirections	Zbg̓e
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public bool SetDirections(short wLogDevice, int dwDirections)
        {
            try
            {
                return D048SetDirections(wLogDevice, dwDirections);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		Cӂ̃|[gf[^
        // 		wLogDevice	͂foCX̘_foCXԍ
        //			dwLogPort	͂_|[g
        //			pbInValue	̓f[^i[̈ւ̃|C^
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public unsafe bool InPort(short wLogDevice, int dwLogPort, byte* pbInValue)
        {
            try
            {
                return D048InPort(wLogDevice, dwLogPort, pbInValue);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		Cӂ̃|[gփf[^o
        // 		wLogDevice	o͂foCX̘_foCXԍ
        //			dwLogPort	o͂_|[g
        //			bOutValue	o͂f[^
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public bool OutPort(short wLogDevice, int dwLogPort, byte bOutValue)
        {
            try
            {
                return D048OutPort(wLogDevice, dwLogPort, bOutValue);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		EIb`hbNJE^̐ݒ肨уEIb`hbN@\̊JnA~
        // 		wLogDevice	lݒ肷foCX̘_foCXԍ
        //			bWdtValue	JE^l (0`5)
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public bool SetWdt(short wLogDevice, byte bWdtValue)
        {
            try
            {
                return D048SetWdt(wLogDevice, bWdtValue);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		EIb`hbNJE^lɂ
        // 		wLogDevice	lݒ肷foCX̘_foCXԍ
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public bool ResetWdt(short wLogDevice)
        {
            try
            {
                return D048ResetWdt(wLogDevice);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		EIb`hbNJE^oߌ̏o͂|[gђl̐ݒ
        // 		wLogDevice		lݒ肷foCX̘_foCXԍ
        //			dwLogPort   	o͂_|[g
        //			bDefaultValue	o͂f[^
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public bool SetDefaultOutput(short wLogDevice, int dwLogPort, byte bDefaultValue)
        {
            try
            {
                return D048SetDefaultOutput(wLogDevice, dwLogPort, bDefaultValue);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		EIb`hbNJE^̏Ԃ擾
        // 		wLogDevice	l擾foCX̘_foCXԍ
        //			pbWdtStatus	EIb`hbNtOԂi[̈ւ̃|C^
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public unsafe bool GetWdtStatus(short wLogDevice, byte* pbWdtStatus)
        {
            try
            {
                return D048GetWdtStatus(wLogDevice, pbWdtStatus);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		|[gĎ̐ݒ
        // 		wLogDevice	lݒ肷foCX̘_foCXԍ
        //			dwLogPort	Ď|[g̘_ԍw
        //			pTrgCond	|[gĎli[̈ւ̃|C^
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public bool SetTrgCond(short wLogDevice, int dwLogPort, ref TriggerCond pTrgCond)
        {
            try
            {
                return D048SetTrgCond(wLogDevice, dwLogPort, ref pTrgCond);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }
        /*======================================================================
        // 		tB^TCNAv񐔂̐ݒ
        // 		wLogDevice	lݒ肷foCX̘_foCXԍ
        //			bInterval	tB^[TCNl (0`5)
        //			bCount		v񐔁iCӁj
        // ߂l	 TRUE
        //			s FALSE
        //====================================================================*/
        public bool SetFilter(short wLogDevice, byte bInterval, byte bCount)
        {
            try
            {
                return D048SetFilter(wLogDevice, bInterval, bCount);
            }
            catch (Exception e)
            {
                Debug.Print(e.Message);
                mErrWradll = ERR_DLL;
                return false;
            }
        }

    }
}
