﻿/*============================================================================
//	cpiud048s.cs
//
//	CPI-UD048制御
//
//	Copyright CPI Technologies,Inc.
//
//	V1.00 Date 2011/03/23
//
//	このソースにはラッパー関数の使用例が記述されています。
//
//==========================================================================*/

//=========================================================================
// ビルド オプションの設定手順を示します。
//
// 1.プロジェクトの [プロパティ] ページを開きます。
// 2.[ビルド] プロパティ ページをクリックします。
// 3.[アンセーフ コードの許可] チェック ボックスをオンにします。
//=========================================================================

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace Sample
{
    public partial class cpiud048s : Form
    {
        static CpiUd048 Ud048;

        public cpiud048s()
        {
            InitializeComponent();
        }

        private unsafe void Form1_Load(object sender, EventArgs e)
        {
            int     i;
            short   wLogDevice;         /* デバイスの論理ｽﾛｯﾄ番号を格納 */
            int     dwDll;              /* Dllバージョン */
            int     dwDrv;              /* ドライバーバージョン */
            int     dwVal;              /* ユニットセレクトスイッチの値 */
            int     dwDirs;             /* ディレクション */
            byte    bDat;               /* 入出力データ変数 */
            byte    bInterval;          /* 入力フィルタ機能 フィルタサイクルの設定 */
            byte    bCount;             /* 入力フィルタ機能 一致回数の設定 */
            String  szBuf;
            string  szVen, szDev, szVer;
            CpiUd048.DeviceInfo di;     /* ﾃﾞﾊﾞｲｽ情報の構造体変数 */
            CpiUd048.TriggerCond tc;

            /* 初期化 */
            Ud048 = new CpiUd048();
            di = new CpiUd048.DeviceInfo();
            di.wCdb = 0;
            di.wSdb = 0;
            di.dwBuff = 0;
            di.sVen = new byte[CpiUd048.CCH_VEN];
            di.sDev = new byte[CpiUd048.CCH_DEV];
            di.sVer = new byte[CpiUd048.CCH_VER];
            for (i = 0; i < CpiUd048.CCH_VEN; i++)
                di.sVen[i] = 0;
            for (i = 0; i < CpiUd048.CCH_DEV; i++)
                di.sDev[i] = 0;
            for (i = 0; i < CpiUd048.CCH_VER; i++)
                di.sVer[i] = 0;
            tc = new CpiUd048.TriggerCond();
            tc.bMode = 0;
            tc.bMask = 0;
            tc.bData = 0;

            /*-------------------------------------------------
            // バージョン番号取得
            //-----------------------------------------------*/
            if (Ud048.GetVersion(&dwDll, &dwDrv) == false)
            {
                ResultMessage("GetVersion failed");
                goto errorHandlerDll;
            }
            szBuf = String.Concat("GetVersion\n\n",
                                    String.Format("DLL    Version: {0:x8}h\n", dwDll),
                                    String.Format("Driver Version: {0:x8}h", dwDrv));
            ResultMessage(szBuf);

            /*-------------------------------------------------
            // CPI-UD048の使用を宣言
            //-----------------------------------------------*/
            wLogDevice = CpiUd048.DEVICE_AUTO;      /* 未使用のデバイスを探します。*/
            if (Ud048.Create(&wLogDevice, 0, 0) == false)
            {
                ErrorMessage(CpiUd048.DEVICE_AUTO);
                goto errorHandlerDll;
            }
            szBuf = String.Concat("CPI-UD048 Created\n\n" +
                                    String.Format("Device # is: {0}", wLogDevice));
            ResultMessage(szBuf);

            /*-------------------------------------------------
            // デバイス情報を取得
            //-----------------------------------------------*/
            if (Ud048.GetDevInfo(wLogDevice, ref di) == false)
            {
                ErrorMessage(wLogDevice);
                return;
            }
            szVen = "";
            for (i = 0; i < CpiUd048.CCH_VEN; i++)
            {
                if (di.sVen[i] == 0) break;
                szVen = szVen + (char)di.sVen[i];
            }
            szDev = "";
            for (i = 0; i < CpiUd048.CCH_DEV; i++)
            {
                if (di.sDev[i] == 0) break;
                szDev = szDev + (char)di.sDev[i];
            }
            szVer = "";
            for (i = 0; i < CpiUd048.CCH_VER; i++)
            {
                if (di.sVer[i] == 0) break;
                szVer = szVer + (char)di.sVer[i];
            }
            szBuf = String.Concat("GetDevInfo\n\n" +
                                    String.Format("wCdb  : {0}\n", di.wCdb),
                                    String.Format("wSdb  : {0}\n", di.wSdb),
                                    String.Format("dwBuff: {0}\n", di.dwBuff),
                                    szVen.Trim() + "\n",
                                    szDev.Trim() + "\n",
                                    szVer.Trim());
            ResultMessage(szBuf);

            /*-------------------------------------------------
            // ユニットセレクトスイッチの値を取得
            //-----------------------------------------------*/
            if (Ud048.GetSwitchValue(wLogDevice, &dwVal) == false)
            {
                ErrorMessage(wLogDevice);
                goto errorHandlerDevice;
            }
            szBuf = String.Concat("ユニットセレクトスイッチの値\n\n" +
                                    String.Format("SW Val: {0:x}h", dwVal));
            ResultMessage(szBuf);

            /*-------------------------------------------------
            // Port A の方向を出力に設定する
            //-----------------------------------------------*/
            if (Ud048.SetDirections(wLogDevice, CpiUd048.DIR_A_OUTPUT) == false)
            {
                ErrorMessage(wLogDevice);
                goto errorHandlerDevice;
            }
            ResultMessage("Port A の方向を出力に変更");

            /*-------------------------------------------------
            // Port A にAAhのデータを出力
            //-----------------------------------------------*/
            ResultMessage("Port A へデータ出力");
            bDat = 0xAA;			  /* 出力データセット AAh */
            if (Ud048.OutPort(wLogDevice, CpiUd048.PORT_A, bDat) == false)
            {
                ErrorMessage(wLogDevice);
                goto errorHandlerDevice;
            }
            szBuf = String.Concat("出力完了\n" +
                                    String.Format("Port A Out Data: {0:x2}h", bDat));
            ResultMessage(szBuf);

            /*-------------------------------------------------
            // Port A にFFhのデータを出力
            //-----------------------------------------------*/
            ResultMessage("Port A へデータを出力");
            bDat = 0xFF;			/* 出力データセット FFh */
            if (Ud048.OutPort(wLogDevice, CpiUd048.PORT_A, bDat) == false)
            {
                ErrorMessage(wLogDevice);
                goto errorHandlerDevice;
            }
            szBuf = String.Concat("出力完了\n\n" +
                                    String.Format("Port A Out Data: {0:x2}h", bDat));
            ResultMessage(szBuf);

            /*-------------------------------------------------
            // Portの方向状態の確認
            //-----------------------------------------------*/
            if (Ud048.GetDirections(wLogDevice, &dwDirs) == false)
            {
                ErrorMessage(wLogDevice);
                goto errorHandlerDevice;
            }
            szBuf = String.Format("Portの方向状態\n\n" +
                                    String.Format("DirVal: {0:x2}h", dwDirs));
            ResultMessage(szBuf);

            /*-------------------------------------------------
            // Port B の方向を入力に設定
            //-----------------------------------------------*/
            ResultMessage("Port B の方向を入力に変更");
            if (Ud048.SetDirections(wLogDevice, CpiUd048.DIR_B_INPUT) == false)
            {
                ErrorMessage(wLogDevice);
                goto errorHandlerDevice;
            }

            /*-------------------------------------------------
            // Portの方向状態の確認
            //-----------------------------------------------*/
            if (Ud048.GetDirections(wLogDevice, &dwDirs) == false)
            {
                ErrorMessage(wLogDevice);
                goto errorHandlerDevice;
            }
            szBuf = String.Concat("Portの方向状態\n\n" +
                                    String.Format("DirVal: {0:x2}h", dwDirs));
            ResultMessage(szBuf);

            /*-------------------------------------------------
            // フィルタ条件の設定
            //-----------------------------------------------*/
            ResultMessage("入力ポートに対してのフィルタ条件設定");

            bInterval = CpiUd048.FILTER_INTERVAL_1260;  /* フィルタサイクルセット */
            bCount = 0x02;                              /* 一致回数セット */
            if (Ud048.SetFilter(wLogDevice, bInterval, bCount) == false)
            {
                ErrorMessage(wLogDevice);
                goto errorHandlerDevice;
            }
            szBuf = String.Concat("フィルタ条件設定完了\n\n" +
                                    String.Format("フィルタサイクル値\t= {0} (1260uS)\n", bInterval),
                                    String.Format("一致回数値\t= {0} (2回)", bCount));
            ResultMessage(szBuf);

            /*-------------------------------------------------
            // Port B からデータを読み込む
            //-----------------------------------------------*/
            ResultMessage("Port B からの入力データの読み込み");
            if (Ud048.InPort(wLogDevice, CpiUd048.PORT_B, &bDat) == false)
            {
                ErrorMessage(wLogDevice);
            }
            else
            {
                szBuf = String.Concat("Port B の入力データ\n\n" +
                                        String.Format("Port B In Data: {0:x2}h", bDat));
                ResultMessage(szBuf);
            }

        errorHandlerDevice:
            /*-------------------------------------------------
            // CPI-UD048の使用を開放
            //-----------------------------------------------*/
            if (Ud048.Close(wLogDevice) == false)
                ErrorMessage(wLogDevice);
            else
                ResultMessage("CPI-UD048 Closed");

        errorHandlerDll:
            /*-------------------------------------------------
            // 終了処理
            //-----------------------------------------------*/
            Ud048.Dispose();

            this.Close();
        }

        /*============================================================================
        // 処理結果を表示
        //===========================================================================*/
        private void ResultMessage(String lpszbuf)
        {
            MessageBox.Show(lpszbuf, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
        }

        /*============================================================================
        // エラーメッセージを表示
        //===========================================================================*/
        private void ErrorMessage(short wLogDevice)
        {
            int dwRes = Ud048.GetLastError(wLogDevice);
            String szBuf;

            szBuf = str_err(dwRes);
            szBuf = String.Concat("GetLastError\n\n",
                                    String.Format("Error code: {0:x8}h", dwRes),
                                    String.Concat(szBuf));
            MessageBox.Show(szBuf, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Stop);
        }

        private string str_err(int dwRes)
        {
            switch (dwRes)
            {
                case CpiUd048.SUCCESS:
                    return "(Succeeded)";
                case CpiUd048.ERR_SYSTEM:
                    return "(System error occured)";
                case CpiUd048.ERR_NO_DEVICE:
                    return "(Device not found)";
                case CpiUd048.ERR_IN_USE:
                    return "(Device is in use)";
                case CpiUd048.ERR_INVALID_DEVICENO:
                    return "(Invalid device number)";
                case CpiUd048.ERR_INVALID_ARGUMENT:
                    return "(Invalid argument)";
                case CpiUd048.ERR_INVALID_PORT:
                    return "(Invalid port number)";
                case CpiUd048.ERR_BAD_DIRECTION:
                    return "(Bad direction)";
                case CpiUd048.ERR_DLL:
                    return "(DLL not opened)";
                case CpiUd048.ERR_TRG_DATA_INVALID:
                    return "(Data not accord)";
                default:
                    return "(Unknown error)";
            }
        }
    
    }
}
