/***********************************************************************
* cpiud048w.h
*
* CPI-UD048 Windows API
*
* Copyright (C) CPI Technologies,Inc.
***********************************************************************/

#ifndef CPIUD048W_H
#define CPIUD048W_H

#include "cpiud048.h"

#ifdef __cplusplus
extern  "C"
{
#endif

/*-----------------------------------------------------------------
// bp[Gg
//---------------------------------------------------------------*/
BOOL  UD048DllOpen( void );
BOOL  UD048DllClose( void );
DWORD UD048GetLastError( WORD wLogDevice );
BOOL  UD048GetVersion( PDWORD pdwDllVersion, PDWORD pdwDriverVersion );
BOOL  UD048Create( PWORD pwLogDevice, HWND hwnd, UINT uWMCode );
BOOL  UD048Close( WORD wLogDevice );
BOOL  UD048GetDevInfo( WORD wLogDevice, PD048DI pDevInfo );
BOOL  UD048GetUnitType( WORD wLogDevice, PDWORD pdwType );
BOOL  UD048GetSwitchValue( WORD wLogDevice, PDWORD pdwSwitchValue );
BOOL  UD048GetDirections( WORD wLogDevice, PDWORD pdwDirections );
BOOL  UD048SetDirections( WORD wLogDevice, DWORD dwDirections );
BOOL  UD048InPort( WORD wLogDevice, DWORD dwLogPort, PBYTE pbInValue );
BOOL  UD048OutPort( WORD wLogDevice, DWORD dwLogPort, BYTE bOutValue );
BOOL  UD048SetWdt( WORD wLogDevice, BYTE bWdtValue );
BOOL  UD048ResetWdt( WORD wLogDevice );
BOOL  UD048SetDefaultOutput( WORD wLogDevice, DWORD dwLogPort, BYTE bDefaultValue );
BOOL  UD048GetWdtStatus( WORD wLogDevice, PBYTE pbWdtStatus );
BOOL  UD048SetTrgCond( WORD wLogDevice, DWORD dwLogPort, PD048PTRGCOND pTrgCond );
BOOL  UD048SetFilter( WORD wLogDevice, BYTE bInterval, BYTE bCount );


#ifdef __cplusplus
}
#endif

#endif  /* CPIUD048W_H */
