/*======================================================================
//  cpiud048w.c
//
//  Copyright (C) 2011 CPI Technologies,Inc.
//====================================================================*/
#include <windows.h>
#include <tchar.h>
#include <assert.h>
#include "cpiud048w.h"

/*======================================================================
// (static)ϐ
//====================================================================*/
#define SZ_DLL          _T("CPIUD048.DLL")

static  HMODULE s_hDll = NULL;

static FARPROC pD048GetLastError = NULL;
static FARPROC pD048GetVersion = NULL;
static FARPROC pD048Create = NULL;
static FARPROC pD048Close = NULL;
static FARPROC pD048GetDevInfo = NULL;
static FARPROC pD048GetUnitType = NULL;
static FARPROC pD048GetSwitchValue = NULL;
static FARPROC pD048GetDirections = NULL;
static FARPROC pD048SetDirections = NULL;
static FARPROC pD048InPort = NULL;
static FARPROC pD048OutPort = NULL;
static FARPROC pD048SetWdt = NULL;
static FARPROC pD048ResetWdt = NULL;
static FARPROC pD048SetDefaultOutput = NULL;
static FARPROC pD048GetWdtStatus = NULL;
static FARPROC pD048SetTrgCond = NULL;
static FARPROC pD048SetFilter = NULL;
static FARPROC pD048Done = NULL;
static FARPROC pD048Init = NULL;

static BOOL det_get(void);
static void det_inv(void);


/*======================================================================
// 		DLL [h
// 		
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048DllOpen(void)
{
	if (NULL != s_hDll)
	{
		return TRUE;		/* [hς݂͐ */
	}
	s_hDll = LoadLibrary(SZ_DLL);
	if (NULL == s_hDll)
	{
		return FALSE;
	}
	if (FALSE == det_get())
	{
		(void)UD048DllClose();
		return FALSE;
	}
	return TRUE;
}
/*======================================================================
// 		DLL 
// 		
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048DllClose(void)
{
	if (NULL == s_hDll)
	{
		return TRUE;		/* Jς݂͐ */
	}

	det_inv();

	if (FALSE == FreeLibrary(s_hDll))
	{
		return FALSE;
	}

	s_hDll = NULL;

	return TRUE;
}
/*======================================================================
// 		ŌɔG[̃R[h擾
// 		wLogDevice	G[foCX̘_foCXԍ
// ߂l	G[R[h
//====================================================================*/
DWORD UD048GetLastError(WORD wLogDevice)
{
	if (NULL == s_hDll)
		return D048_ERR_DLL;
	else
		return (*pD048GetLastError)(wLogDevice);
}
/*======================================================================
// 		o[Wԍ擾
// 		pdwDllVersion		DLL o[Wԍi[̈ւ̃|C^
//			pdwDriverVersion	hCoo[Wԍi[̈ւ̃|C^
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048GetVersion(PDWORD pdwDllVersion, PDWORD pdwDriverVersion)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048GetVersion)(pdwDllVersion, pdwDriverVersion);
	return result;
}
/*======================================================================
// 		foCX̎gp錾
// 		pwLogDevice	gpfoCX̘_foCXԍi[|C^
//			hwnd		|[gĎ@\gpꍇɃhCoo郁bZ[W󂯎
//						EBhẼnhw肵܂B
//						bZ[WgpȂꍇ NULL w肵܂B
//			uWMCode		|[gĎ@\gpꍇɑo郁bZ[W ID ̒lw肵܂B
//						ʏ WM_USER (0x400) ȏ̒lw肵܂B
//						bZ[WgpȂꍇ NULL w肵܂B
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048Create(PWORD pwLogDevice, HWND hwnd, UINT uWMCode)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048Create)(pwLogDevice, hwnd, uWMCode);
	return result;
}
/*======================================================================
// 		gp̃foCX
// 		wLogDevice	foCX̘_foCXԍ
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048Close(WORD wLogDevice)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048Close)(wLogDevice);
	return result;
}
/*======================================================================
// 		foCX擾
// 		wLogDevice	l擾_foCXԍ
//			pDevInfo	foCXi[\̂̃|C^
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048GetDevInfo(WORD wLogDevice, PD048DI pDevInfo)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048GetDevInfo)(wLogDevice, pDevInfo);
	return result;
}
/*======================================================================
// 		jbg^Cv擾
// 		wLogDevice	l擾foCX̘_foCXԍ
//			pdwType		^Cvli[̈ւ̃|C^
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048GetUnitType(WORD wLogDevice, PDWORD pdwType)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048GetUnitType)(wLogDevice, pdwType);
	return result;
}
/*======================================================================
// 		jbgZNgXCb`̒l擾
// 		wLogDevice		l擾foCX̘_foCXԍ
//			pdwSwitchValue	jbgZNgXCb`̒li[̈ւ̃|C^
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048GetSwitchValue(WORD wLogDevice, PDWORD pdwSwitchValue)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048GetSwitchValue)(wLogDevice, pdwSwitchValue);
	return result;
}
/*======================================================================
// 		擾
// 		wLogDevice		̏Ԃ擾foCX̘_foCXԍ
//			pdwDirections	Ԃi[̈ւ̃|C^
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048GetDirections(WORD wLogDevice, PDWORD  pdwDirections)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048GetDirections)(wLogDevice, pdwDirections);
	return result;
}
/*======================================================================
// 		ݒ
// 		wLogDevice		ZbgfoCX̘_foCXԍ
//			dwDirections	Zbg̓e
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048SetDirections(WORD wLogDevice, DWORD dwDirections)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048SetDirections)(wLogDevice, dwDirections);
	return result;
}
/*======================================================================
// 		Cӂ̃|[gf[^
// 		wLogDevice	͂foCX̘_foCXԍ
//			dwLogPort	͂_|[g
//			pbInValue	̓f[^i[̈ւ̃|C^
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048InPort(WORD wLogDevice, DWORD dwLogPort, PBYTE pbInValue)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048InPort)(wLogDevice, dwLogPort, pbInValue);
	return result;
}
/*======================================================================
// 		Cӂ̃|[gփf[^o
// 		wLogDevice	o͂foCX̘_foCXԍ
//			dwLogPort	o͂_|[g
//			bOutValue	o͂f[^
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048OutPort(WORD wLogDevice, DWORD dwLogPort, BYTE bOutValue)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048OutPort)(wLogDevice, dwLogPort, bOutValue);
	return result;
}
/*======================================================================
// 		EIb`hbNJE^̐ݒ肨уEIb`hbN@\̊JnA~
// 		wLogDevice	lݒ肷foCX̘_foCXԍ
//			bWdtValue	JE^l (0`5)
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048SetWdt(WORD wLogDevice, BYTE bWdtValue)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048SetWdt)(wLogDevice, bWdtValue);
	return result;
}
/*======================================================================
// 		EIb`hbNJE^lɂ
// 		wLogDevice	lݒ肷foCX̘_foCXԍ
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048ResetWdt(WORD wLogDevice)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048ResetWdt)(wLogDevice);
	return result;
}
/*======================================================================
// 		EIb`hbNJE^oߌ̏o͂|[gђl̐ݒ
// 		wLogDevice		lݒ肷foCX̘_foCXԍ
//			dwLogPort   	o͂_|[g
//			bDefaultValue	o͂f[^
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048SetDefaultOutput(WORD wLogDevice, DWORD dwLogPort, BYTE bDefaultValue)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048SetDefaultOutput)(wLogDevice, dwLogPort, bDefaultValue);
	return result;
}
/*======================================================================
// 		EIb`hbNJE^̏Ԃ擾
// 		wLogDevice	l擾foCX̘_foCXԍ
//			pbWdtStatus	EIb`hbNtOԂi[̈ւ̃|C^
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048GetWdtStatus(WORD wLogDevice, PBYTE pbWdtStatus)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048GetWdtStatus)(wLogDevice, pbWdtStatus);
	return result;
}
/*======================================================================
// 		|[gĎ̐ݒ
// 		wLogDevice	lݒ肷foCX̘_foCXԍ
//			dwLogPort	Ď|[g̘_ԍw
//			pTrgCond	|[gĎli[̈ւ̃|C^
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048SetTrgCond(WORD wLogDevice, DWORD dwLogPort, PD048PTRGCOND pTrgCond)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048SetTrgCond)(wLogDevice, dwLogPort, pTrgCond);
	return result;
}
/*======================================================================
// 		tB^TCNAv񐔂̐ݒ
// 		wLogDevice	lݒ肷foCX̘_foCXԍ
//			bInterval	tB^[TCNl (0`5)
//			bCount		v񐔁iCӁj
// ߂l	 TRUE
//			s FALSE
//====================================================================*/
BOOL UD048SetFilter(WORD wLogDevice, BYTE bInterval, BYTE bCount)
{
	BOOL result = FALSE;
	if (NULL != s_hDll)
		result = (*pD048SetFilter)(wLogDevice, bInterval, bCount);
	return result;
}
/*----------------------------------------------------------------------
// 		Gg擾
// 		
// ߂l	 TRUE
//			s FALSE
//--------------------------------------------------------------------*/
static BOOL det_get(void)
{
	pD048GetLastError = GetProcAddress(s_hDll, _T("D048GetLastError"));
	if (pD048GetLastError == NULL)
		return FALSE;
	pD048GetVersion = GetProcAddress(s_hDll, _T("D048GetVersion"));
	if (pD048GetVersion == NULL)
		return FALSE;
	pD048Create = GetProcAddress(s_hDll, _T("D048Create"));
	if (pD048Create == NULL)
		return FALSE;
	pD048Close = GetProcAddress(s_hDll, _T("D048Close"));
	if (pD048Close == NULL)
		return FALSE;
	pD048GetDevInfo = GetProcAddress(s_hDll, _T("D048GetDevInfo"));
	if (pD048GetDevInfo == NULL)
		return FALSE;
	pD048GetUnitType = GetProcAddress(s_hDll, _T("D048GetUnitType"));
	if (pD048GetUnitType == NULL)
		return FALSE;
	pD048GetSwitchValue = GetProcAddress(s_hDll, _T("D048GetSwitchValue"));
	if (pD048GetSwitchValue == NULL)
		return FALSE;
	pD048GetDirections = GetProcAddress(s_hDll, _T("D048GetDirections"));
	if (pD048GetDirections == NULL)
		return FALSE;
	pD048SetDirections = GetProcAddress(s_hDll, _T("D048SetDirections"));
	if (pD048SetDirections == NULL)
		return FALSE;
	pD048InPort = GetProcAddress(s_hDll, _T("D048InPort"));
	if (pD048InPort == NULL)
		return FALSE;
	pD048OutPort = GetProcAddress(s_hDll, _T("D048OutPort"));
	if (pD048OutPort == NULL)
		return FALSE;
	pD048SetWdt = GetProcAddress(s_hDll, _T("D048SetWdt"));
	if (pD048SetWdt == NULL)
		return FALSE;
	pD048ResetWdt = GetProcAddress(s_hDll, _T("D048ResetWdt"));
	if (pD048ResetWdt == NULL)
		return FALSE;
	pD048SetDefaultOutput = GetProcAddress(s_hDll, _T("D048SetDefaultOutput"));
	if (pD048SetDefaultOutput == NULL)
		return FALSE;
	pD048GetWdtStatus = GetProcAddress(s_hDll, _T("D048GetWdtStatus"));
	if (pD048GetWdtStatus == NULL)
		return FALSE;
	pD048SetTrgCond = GetProcAddress(s_hDll, _T("D048SetTrgCond"));
	if (pD048SetTrgCond == NULL)
		return FALSE;
	pD048SetFilter = GetProcAddress(s_hDll, _T("D048SetFilter"));
	if (pD048SetFilter == NULL)
		return FALSE;
	pD048Done = GetProcAddress(s_hDll, _T("d048_done"));
	if (pD048Done == NULL)
		return FALSE;
	pD048Init = GetProcAddress(s_hDll, _T("d048_init"));
	if (pD048Init == NULL)
		return FALSE;

	return (*pD048Init)();
}
/*----------------------------------------------------------------------
// 		Gg
// 		
// ߂l	 TRUE
//			s FALSE
//--------------------------------------------------------------------*/
static void det_inv(void)
{
	(void)(*pD048Done)();
}
