/***********************************************************************
* cpiud048.h
*
* CPI-UD048 Windows API
*
* Copyright (C) CPI Technologies,Inc.
***********************************************************************/

#ifndef CPIUD048_H   /*[*/
#define CPIUD048_H

#ifdef __cplusplus
extern  "C"
{
#endif


/*-----------------------------------------------------------------
// 荞݃bZ[WID
//---------------------------------------------------------------*/
#define WM_CHECK_TRG				0x2000		/* bZ[WID */

/*-----------------------------------------------------------------
// G[R[h
//---------------------------------------------------------------*/
#define D048_SUCCESS				0			/* I*/
												/* Windows G[ */
#define D048_ERR_SYSTEM				1			/* GetLastError R[ */
#define D048_ERR_NO_DEVICE			2   		/* gp\ȃfoCXȂ */
#define D048_ERR_IN_USE				3   		/* wfoCX͎gpł */
#define D048_ERR_INVALID_DEVICENO	4   		/* Ș_foCXԍ */
#define D048_ERR_INVALID_ARGUMENT	5			/* Ȉ */
#define D048_ERR_INVALID_PORT		6			/* Ș_|[g */
#define D048_ERR_BAD_DIRECTION		7			/* sȕ */
#define	D048_ERR_TRG_DATA_INVALID	8			/*  |[gĎvf[^Ȃ */
#define D048_ERR_DLL				( ~0UL )	/* DLL [hs */

/*-----------------------------------------------------------------
// ̑
//---------------------------------------------------------------*/
#define D048_MAX_DEVICES			16
#define D048_DEVICE_AUTO			( ( WORD )~0 )

/*-----------------------------------------------------------------
// tB^TCN̐ݒ
//---------------------------------------------------------------*/
#define D048_FILTER_INTERVAL_STOP	0
#define D048_FILTER_INTERVAL_1260	1
#define D048_FILTER_INTERVAL_2520	2
#define D048_FILTER_INTERVAL_5040	3
#define D048_FILTER_INTERVAL_10080	4
#define D048_FILTER_INTERVAL_20160	5

/*-----------------------------------------------------------------
// |[gĎ̏
//---------------------------------------------------------------*/
#define D048_MON_NODE				0		/* Ȃ */
#define D048_MON_ALT				1		/* Ώۃrbgɕω */
#define D048_MON_AND				2		/* ΏۃrbgSv */
#define D048_MON_OR					3		/* Ώۃrbgv */

/*-----------------------------------------------------------------
// EIb`hbNJE^̏
//---------------------------------------------------------------*/
#define D048_WDT_FLAG_OFF			0		/* EIb`hbN܂́ANO */
#define D048_WDT_FLAG_ON			1		/* EIb`hbNN */

/*-----------------------------------------------------------------
// EIb`hbNJE^̐ݒ
//---------------------------------------------------------------*/
#define D048_WDT_INTERVAL_STOP		0
#define D048_WDT_INTERVAL_126		1
#define D048_WDT_INTERVAL_252		2
#define D048_WDT_INTERVAL_504		3
#define D048_WDT_INTERVAL_1008		4
#define D048_WDT_INTERVAL_2016		5

/*-----------------------------------------------------------------
// jbg^Cv
//---------------------------------------------------------------*/
#define D048_TYPE_TTL				0
#define D048_TYPE_CMOS				1

/*-----------------------------------------------------------------
// _|[gԍ
//---------------------------------------------------------------*/
#define D048_PORT_A					0
#define D048_PORT_B					1
#define D048_PORT_C					2
#define D048_PORT_D					3
#define D048_PORT_E					4
#define D048_PORT_F					5
#define D048_MAX_PORTS				6		/* |[g */

/*-----------------------------------------------------------------
// |[g
//---------------------------------------------------------------*/
#define D048_DIR_A_OUTPUT			( 0 << D048_PORT_A )
#define D048_DIR_A_INPUT			( 1 << D048_PORT_A )
#define D048_DIR_B_OUTPUT			( 0 << D048_PORT_B )
#define D048_DIR_B_INPUT			( 1 << D048_PORT_B )
#define D048_DIR_C_OUTPUT			( 0 << D048_PORT_C )
#define D048_DIR_C_INPUT			( 1 << D048_PORT_C )
#define D048_DIR_D_OUTPUT			( 0 << D048_PORT_D )
#define D048_DIR_D_INPUT			( 1 << D048_PORT_D )
#define D048_DIR_E_OUTPUT			( 0 << D048_PORT_E )
#define D048_DIR_E_INPUT			( 1 << D048_PORT_E )
#define D048_DIR_F_OUTPUT			( 0 << D048_PORT_F )
#define D048_DIR_F_INPUT			( 1 << D048_PORT_F )
#define D048_DIR_ALL_OUTPUT			( D048_DIR_A_OUTPUT     \
										| D048_DIR_B_OUTPUT \
										| D048_DIR_C_OUTPUT \
										| D048_DIR_D_OUTPUT \
										| D048_DIR_E_OUTPUT \
										| D048_DIR_F_OUTPUT \
									)
#define D048_DIR_ALL_INPUT			( D048_DIR_A_INPUT     \
										| D048_DIR_B_INPUT \
										| D048_DIR_C_INPUT \
										| D048_DIR_D_INPUT \
										| D048_DIR_E_INPUT \
										| D048_DIR_F_INPUT \
									)

/*-----------------------------------------------------------------
// foCX
//---------------------------------------------------------------*/
#define D048_CCH_VEN				8
#define D048_CCH_DEV				16
#define D048_CCH_VER				4

typedef struct  SD048DI {
	WORD  wCdb;						/* bytes of command descriptor */
	WORD  wSdb;						/* bytes of status descriptor */
	DWORD dwBuff;					/* bytes of internal buffer */
	char sVen[ D048_CCH_VEN ];		/* vendor name */
	char sDev[ D048_CCH_DEV ];		/* device name */
	char sVer[ D048_CCH_VER ];		/* firmware version */
} TD048DI, *PD048DI;



#ifdef  WIN32   /*[*/

typedef struct SD048PTRGCOND {		/* |[gĎݒ̍\ */
	BYTE bMode;						/* |[gĎ[h */
	BYTE bMask;						/* |[gĎ}XN */
	BYTE bData;						/* |[gĎf[^ */
} TD048PTRGCOND, *PD048PTRGCOND;


/*-----------------------------------------------------------------
// APIGg
//---------------------------------------------------------------*/
DWORD WINAPI D048GetLastError( WORD wLogDevice );
BOOL  WINAPI D048GetVersion( PDWORD pdwDllVersion, PDWORD pdwDriverVersion );
BOOL  WINAPI D048Create( PWORD pwLogDevice, HWND hwnd, UINT uWMCode );
BOOL  WINAPI D048Close( WORD wLogDevice );
BOOL  WINAPI D048GetDevInfo( WORD wLogDevice, PD048DI pDevInfo );
BOOL  WINAPI D048GetUnitType( WORD wLogDevice, PDWORD pdwType );
BOOL  WINAPI D048GetSwitchValue( WORD wLogDevice, PDWORD pdwSwitchValue );
BOOL  WINAPI D048GetDirections( WORD wLogDevice, PDWORD pdwDirections );
BOOL  WINAPI D048SetDirections( WORD wLogDevice, DWORD dwDirections );
BOOL  WINAPI D048InPort( WORD wLogDevice, DWORD dwLogPort, PBYTE pbInValue );
BOOL  WINAPI D048OutPort( WORD wLogDevice, DWORD dwLogPort, BYTE bOutValue );
BOOL  WINAPI D048SetWdt( WORD wLogDevice, BYTE bWdtValue );
BOOL  WINAPI D048ResetWdt( WORD wLogDevice );
BOOL  WINAPI D048SetDefaultOutput( WORD wLogDevice, DWORD dwLogPort, BYTE bDefaultValue );
BOOL  WINAPI D048GetWdtStatus( WORD wLogDevice, PBYTE pbWdtStatus );
BOOL  WINAPI D048SetTrgCond( WORD wLogDevice, DWORD dwLogPort, PD048PTRGCOND pTrgCond );
BOOL  WINAPI D048SetFilter( WORD wLogDevice, BYTE bInterval, BYTE bCount );


#endif  /*] WIN32 */

#ifdef __cplusplus
}
#endif

#endif  /* CPIUD048_H */
