Attribute VB_Name = "Sample"
'============================================================================
'  cpiud048s.bas
'
'  CPI-UD048
'
'  Copyright CPI Technologies,Inc.
'
'  V1.00 Date 2011/03/23
'
'  ̃\[Xɂ̓bp[֐̎gpႪLqĂ܂B
'
'============================================================================

Option Explicit

Private Const szTitle = "Sample"
Private Declare Function GetLastError Lib "kernel32" () As Long

'============================================================================
'  ۸т̊Jn
'=============================================================================
Sub Main()
    Dim i As Integer
    Dim wLogDevice As Integer   ' foCX̘_ۯĔԍi[
    Dim dwDll As Long           ' Dllo[W
    Dim dwDrv As Long           ' hCo[o[W
    Dim di As SD048DI           ' foCX̍\̕ϐ
    Dim dwVal As Long           ' jbgZNgXCb`̒l
    Dim dwDirs As Long          ' fBNV
    Dim bDat As Byte            ' o̓f[^ϐ
    Dim bInterval As Byte       ' ̓tB^@\ tB^TCN̐ݒ
    Dim bCount As Byte          ' ̓tB^@\ v񐔂̐ݒ
    Dim szBuf As String
    Dim szVen As String, szDev As String, szVer As String

    '-------------------------------------------------
    ' cpiud048.dll ̎gp錾
    '-------------------------------------------------
    If UD048DllOpen() = False Then
        ResultMessage ("UD048DllOpen error")
        GoTo errorHandlerDll            ' cpiud048.dll ̃[hɎs܂
    End If
    ResultMessage ("UD048DllOpen succeeded")

    '-------------------------------------------------
    ' o[Wԍ擾
    '-------------------------------------------------
    If UD048GetVersion(dwDll, dwDrv) = False Then
        ResultMessage ("GetVersion failed")
        GoTo errorHandlerDll
    End If
    szBuf = "GetVersion" + Chr(10) + Chr(10) + _
            "DLL    Version: " + Right("00000000" + Hex(dwDll), 8) + "h" + Chr(10) + _
            "Driver Version: " + Right("00000000" + Hex(dwDrv), 8) + "h"
    ResultMessage (szBuf)

    '-------------------------------------------------
    ' CPI-UD048̎gp錾
    '-------------------------------------------------
    wLogDevice = D048_DEVICE_AUTO       ' gp̃foCXT܂B
    If UD048Create(wLogDevice, 0, 0) = False Then
        ErrorMessage (D048_DEVICE_AUTO)
        GoTo errorHandlerDll
    End If
    szBuf = "CPI-UD048 Created" + Chr(10) + Chr(10) + _
            "Device # is: " + Str(wLogDevice)
    ResultMessage (szBuf)

    '-------------------------------------------------
    ' foCX擾
    '-------------------------------------------------
    If UD048GetDevInfo(wLogDevice, di) = False Then
        ErrorMessage (wLogDevice)
        GoTo errorHandlerDevice
    End If
    szVen = ""
    For i = 1 To D048_CCH_VEN
        If di.sVen(i) = &H0 Then Exit For
        szVen = szVen + Chr(di.sVen(i))
    Next
    szDev = ""
    For i = 1 To D048_CCH_DEV
        If di.sDev(i) = &H0 Then Exit For
        szDev = szDev + Chr(di.sDev(i))
    Next
    szVer = ""
    For i = 1 To D048_CCH_VER
        If di.sVer(i) = &H0 Then Exit For
        szVer = szVer + Chr(di.sVer(i))
    Next
    szBuf = "GetDevInfo" + Chr(10) + Chr(10) + _
            "wCdb  : " + Str(di.wCdb) + Chr(10) + _
            "wSdb  : " + Str(di.wSdb) + Chr(10) + _
            "dwBuff: " + Str(di.dwBuff) + Chr(10) + _
            "sVen  : " + RTrim(szVen) + Chr(10) + _
            "sDev  : " + RTrim(szDev) + Chr(10) + _
            "sVer  : " + RTrim(szVer) + Chr(10)
    ResultMessage (szBuf)

    '-------------------------------------------------
    ' jbgZNgXCb`̒l擾
    '-------------------------------------------------
    If UD048GetSwitchValue(wLogDevice, dwVal) = False Then
        ErrorMessage (wLogDevice)
        GoTo errorHandlerDevice
    End If
    szBuf = "jbgZNgXCb`̒l" + Chr(10) + Chr(10) + _
            "SW Val: " + Hex(dwVal) + "h"
    ResultMessage (szBuf)

    '-------------------------------------------------
    ' Port A ̕o͂ɐݒ肷
    '-----------------------------------------------*/
    If UD048SetDirections(wLogDevice, D048_DIR_A_OUTPUT) = False Then
        ErrorMessage (wLogDevice)
        GoTo errorHandlerDevice
    End If
    ResultMessage ("Port A ̕o͂ɕύX")

    '-------------------------------------------------
    ' Port A AAh̃f[^o
    '-------------------------------------------------
    ResultMessage ("Port A փf[^o")
    bDat = &HAA                 ' o̓f[^Zbg AAh
    If UD048OutPort(wLogDevice, D048_PORT_A, bDat) = False Then
        ErrorMessage (wLogDevice)
        GoTo errorHandlerDevice
    End If
    szBuf = "o͊" + Chr(10) + Chr(10) + _
            "Port A Out Data: " + Right("00" + Hex(bDat), 2) + "h"
    ResultMessage (szBuf)

    '-------------------------------------------------
    ' Port A FFh̃f[^o
    '-------------------------------------------------
    ResultMessage ("Port A փf[^o")
    bDat = &HFF                 ' o̓f[^Zbg FFh
    If UD048OutPort(wLogDevice, D048_PORT_A, bDat) = False Then
        ErrorMessage (wLogDevice)
        GoTo errorHandlerDevice
    End If
    szBuf = "o͊" + Chr(10) + Chr(10) + _
            "Port A Out Data: " + Right("00" + Hex(bDat), 2) + "h"
    ResultMessage (szBuf)

    '-------------------------------------------------
    ' Port̕Ԃ̊mF
    '-------------------------------------------------
    If UD048GetDirections(wLogDevice, dwDirs) = False Then
        ErrorMessage (wLogDevice)
        GoTo errorHandlerDevice
    End If
    szBuf = "Port̕" + Chr(10) + Chr(10) + _
            "DirVal: " + Right("00" + Hex(dwDirs), 2) + "h"
    ResultMessage (szBuf)

    '-------------------------------------------------
    ' Port B ͂̕ɐݒ
    '-------------------------------------------------
    ResultMessage ("Port B ͂̕ɕύX")
    If UD048SetDirections(wLogDevice, D048_DIR_B_INPUT) = False Then
        ErrorMessage (wLogDevice)
        GoTo errorHandlerDevice
    End If

    '-------------------------------------------------
    ' Port̕Ԃ̊mF
    '-------------------------------------------------
    If UD048GetDirections(wLogDevice, dwDirs) = False Then
        ErrorMessage (wLogDevice)
        GoTo errorHandlerDevice
    End If
    szBuf = "Port̕" + Chr(10) + Chr(10) + _
            "DirVal: " + Right("00" + Hex(dwDirs), 2) + "h"
    ResultMessage (szBuf)

    '-------------------------------------------------
    ' tB^̐ݒ
    '-------------------------------------------------
    ResultMessage ("̓|[gɑ΂ẴtB^ݒ")

    bInterval = D048_FILTER_INTERVAL_1260   ' tB^TCNZbg
    bCount = &H2                            ' v񐔃Zbg
    If UD048SetFilter(wLogDevice, bInterval, bCount) = False Then
        ErrorMessage (wLogDevice)
        GoTo errorHandlerDevice
    End If
    szBuf = "tB^ݒ芮" + Chr(10) + Chr(10) + _
            "tB^TCNl" + vbTab + "= " + Str(bInterval) + " (1260uS)" + Chr(10) + _
            "v񐔒l" + vbTab + "= " + Str(bCount) + "  (2)"
    ResultMessage (szBuf)

    '-------------------------------------------------
    ' Port B f[^ǂݍ
    '-------------------------------------------------
    ResultMessage ("Port B ̓̓f[^̓ǂݍ")
    If UD048InPort(wLogDevice, D048_PORT_B, bDat) = False Then
        ErrorMessage (wLogDevice)
        GoTo errorHandlerDevice
    End If
    szBuf = "Port B ̓̓f[^" + Chr(10) + Chr(10) + _
            "Port B In Data: " + Right("00" + Hex(bDat), 2) + "h"
    ResultMessage (szBuf)

errorHandlerDevice:
    '-------------------------------------------------
    ' CPI-UD048̎gpJ
    '-------------------------------------------------
    If UD048Close(wLogDevice) = False Then
        ErrorMessage (wLogDevice)
    Else
        ResultMessage ("CPI-UD048 Closed")
    End If

errorHandlerDll:
    '-------------------------------------------------
    ' cpiud048.dll ̎gpJ
    '-------------------------------------------------
    If UD048DllClose() = False Then
        ErrorMessage (wLogDevice)
    Else
        ResultMessage ("UD048DllClose succeeded")
    End If

End Sub

'============================================================================
' ʂ\
'============================================================================
Private Sub ResultMessage(ByVal lpszbuf As String)

    MsgBox lpszbuf, vbOKOnly + vbInformation
    
End Sub

'============================================================================
' G[bZ[W\
'============================================================================
Private Sub ErrorMessage(ByVal wLogDevice As Integer)
    Dim dwRes As Long
    Dim szBuf As String

    dwRes = UD048GetLastError(wLogDevice)

    szBuf = "GetLastError" + Chr(10) + Chr(10) + _
            "Error code: " + Right("00000000" + Hex(dwRes), 8) + "h(" + str_err(dwRes) + ")"
    MsgBox szBuf, vbOKOnly + vbCritical
End Sub

Private Function str_err(ByVal dwRes As Long)

    Select Case dwRes
        Case D048_SUCCESS
            str_err = "Succeeded"
        Case D048_ERR_SYSTEM
            str_err = "System error occured"
        Case D048_ERR_NO_DEVICE
            str_err = "Device not found"
        Case D048_ERR_IN_USE
            str_err = "Device is in use"
        Case D048_ERR_INVALID_DEVICENO
            str_err = "Invalid device number"
        Case D048_ERR_INVALID_ARGUMENT
            str_err = "Invalid argument"
        Case D048_ERR_INVALID_PORT
            str_err = "Invalid port number"
        Case D048_ERR_BAD_DIRECTION
            str_err = "Bad direction"
        Case D048_ERR_DLL
            str_err = "DLL not opened"
        Case D048_ERR_TRG_DATA_INVALID
            str_err = "Data not accord"
        Case Else
            str_err = "Unknown error"
    End Select

End Function

