//============================================================================
//	cpiud048s.pas
//
//	CPI-UD048
//
//	Copyright CPI Technologies,Inc.
//
//	V1.00 Date 2011/03/23
//
//	̃\[Xɂ̓bp[֐̎gpႪLqĂ܂B
//
//============================================================================

unit cpiud048s;

interface

uses
  Windows, Messages, SysUtils, Forms, cpiud048w;

const
  szTitle = 'Sample';

type
  TForm1 = class(TForm)
    procedure FormCreate(Sender: TObject);
  private
    { Private 錾 }
    procedure ResultMessage(szBuf: String);
    procedure ErrorMessage(wLogDevice: Word);
    function str_err(dwRes: DWord): String;
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var
  i: Word;
  wLogDevice: Word;     // foCX̘_ۯĔԍi[
  dwDll: DWord;         // Dllo[W
  dwDrv: DWord;         // hCo[o[W
  di: SD048DI;          // foCX̍\̕ϐ
  dwVal: DWord;         // jbgZNgXCb`̒l
  dwDirs: Dword;        // fBNV
  bDat: Byte;           // o̓f[^ϐ
  bInterval: Byte;      // ̓tB^@\ tB^TCN̐ݒ
  bCount: Byte;         // ̓tB^@\ v񐔂̐ݒ
  szBuf: String;
  szVen, szDev, szVer: String;
begin
  //-------------------------------------------------
  // cpiud048.dll ̎gp錾
  //-------------------------------------------------
  if UD048DllOpen() = False then begin
    ResultMessage('UD048DllOpen error');
    Halt;               // cpiud048.dll ̃[hɎs܂
  end;
  ResultMessage('UD048DllOpen succeeded');

  //-------------------------------------------------
  // o[Wԍ擾
  //-------------------------------------------------
  if UD048GetVersion(&dwDll, &dwDrv) = False then begin
    ResultMessage('GetVersion failed');
    Halt;
  end;
  szBuf := Format('GetVersion'#10#10 +
                  'DLL    Version: %0.8xh'#10 +
                  'Driver Version: %0.8xh',
                  [dwDll, dwDrv]);
  ResultMessage(szBuf);

  //-------------------------------------------------
  // CPI-UD048̎gp錾
  //-------------------------------------------------
  wLogDevice := D048_DEVICE_AUTO;     // gp̃foCXT܂B
  if UD048Create(&wLogDevice, 0, 0) = False then begin
    ErrorMessage(D048_DEVICE_AUTO);
    Halt;
  end;
  szBuf := Format('CPI-UD048 Created'#10#10 +
                  'Device # is: %d',
                  [wLogDevice]);
  ResultMessage(szBuf);

  //-------------------------------------------------
  // foCX擾
  //-------------------------------------------------
  if UD048GetDevInfo(wLogDevice, @di) = False then begin
    ErrorMessage(wLogDevice);
    Halt;
  end;
  szVen := '';
  for i := 0 to D048_CCH_VEN - 1 do begin
    if di.sVen[i] = $0 then break;
    szVen := szVen + chr(di.sVen[i]);
  end;
  szDev := '';
  for i := 0 to D048_CCH_DEV - 1 do begin
    if di.sDev[i] = $0 then break;
    szDev := szDev + chr(di.sDev[i]);
  end;
  szVer := '';
  for i := 0 to D048_CCH_VER - 1 do begin
    if di.sVer[i] = $0 then break;
    szVer := szVer + chr(di.sVer[i]);
  end;
  szBuf := Format('GetDevInfo'#10#10 +
                  'wCdb  : %d'#10 +
                  'wSdb  : %d'#10 +
                  'dwBuff: %d'#10 +
                  'sVen  : %s'#10 +
                  'sDev  : %s'#10 +
                  'sVer  : %s',
                  [di.wCdb,
                   di.wSdb,
                   di.dwBuff,
                   szVen,
                   szDev,
                   szVer]);
  ResultMessage(szBuf);

  //-------------------------------------------------
  // jbgZNgXCb`̒l擾
  //-------------------------------------------------
  if UD048GetSwitchValue(wLogDevice, &dwVal) = False then begin
    ErrorMessage(wLogDevice);
    Halt;
  end;
  szBuf := Format('jbgZNgXCb`̒l'#10#10 +
                  'SW Val: %xh',
                  [dwVal]);
  ResultMessage(szBuf);

  //-------------------------------------------------
  // Port A ̕o͂ɐݒ肷
  //-------------------------------------------------
  if UD048SetDirections(wLogDevice, D048_DIR_A_OUTPUT) = False then begin
    ErrorMessage(wLogDevice);
    Halt;
  end;
  ResultMessage('Port A ̕o͂ɕύX');

  //-------------------------------------------------
  // Port A AAh̃f[^o
  //-------------------------------------------------
  ResultMessage('Port A փf[^o');
  bDat := $AA;         // o̓f[^Zbg AAh
  if UD048OutPort(wLogDevice, D048_PORT_A, bDat) = False then begin
    ErrorMessage(wLogDevice);
    Halt;
  end;
  szBuf := Format('o͊'#10#10 +
                  'Port A Out Data: %0.2xh',
                  [bDat]);
  ResultMessage(szBuf);

  //-------------------------------------------------
  // Port A FFh̃f[^o
  //-------------------------------------------------
  ResultMessage('Port A փf[^o');
  bDat := $FF;          // o̓f[^Zbg FFh
  if UD048OutPort(wLogDevice, D048_PORT_A, bDat) = False then begin
    ErrorMessage(wLogDevice);
    Halt;
  end;
  szBuf := Format('o͊'#10#10 +
                  'Port A Out Data: %0.2xh',
                  [bDat]);
  ResultMessage(szBuf);

  //-------------------------------------------------
  // Port̕Ԃ̊mF
  //-------------------------------------------------
  if UD048GetDirections(wLogDevice, &dwDirs) = False then begin
    ErrorMessage(wLogDevice);
    Halt;
  end;
  szBuf := Format('Port̕'#10#10 +
                  'DirVal: %0.2xh',
                  [dwDirs]);
  ResultMessage(szBuf);

  //-------------------------------------------------
  // Port B ͂̕ɐݒ
  //-------------------------------------------------
  ResultMessage('Port B ͂̕ɕύX');
  if UD048SetDirections(wLogDevice, D048_DIR_B_INPUT) = False then begin
    ErrorMessage(wLogDevice);
    Halt;
  end;

  //-------------------------------------------------
  // Port̕Ԃ̊mF
  //-------------------------------------------------
  if UD048GetDirections(wLogDevice, &dwDirs) = False then begin
     ErrorMessage(wLogDevice);
      Halt;
  end;
  szBuf := Format('Port̕'#10#10 +
                  'DirVal: %0.2xh',
                  [dwDirs]);
  ResultMessage(szBuf);

  //-------------------------------------------------
  // tB^̐ݒ
  //-------------------------------------------------
  ResultMessage('̓|[gɑ΂ẴtB^ݒ');

  bInterval := D048_FILTER_INTERVAL_1260;   // tB^TCNZbg
  bCount := $02;                            // v񐔃Zbg
  if UD048SetFilter(wLogDevice, bInterval, bCount) = False then begin
    ErrorMessage(wLogDevice);
    Halt;
  end;
  szBuf := Format('tB^ݒ芮'#10#10 +
                  'tB^TCNl = %d (1260uS)'#10 +
                  'v񐔒l         = %d (2)',
                  [bInterval,
                   bCount]);
  ResultMessage(szBuf);

  //-------------------------------------------------
  // Port B f[^ǂݍ
  //-------------------------------------------------
  ResultMessage('Port B ̓̓f[^̓ǂݍ');
  if UD048InPort(wLogDevice, D048_PORT_B, &bDat) = False then begin
    ErrorMessage(wLogDevice);
    Halt;
  end;
  szBuf := Format('Port B ̓̓f[^'#10#10 +
                  ' Port B In Data: %0.2xh',
                  [bDat]);
  ResultMessage(szBuf);

  //-------------------------------------------------
  // CPI-UD048̎gpJ
  //-------------------------------------------------
  if UD048Close(wLogDevice) = False then begin
    ErrorMessage(wLogDevice);
    Halt;
  end;
  ResultMessage('CPI-UD048 Closed');

  //-------------------------------------------------
  // cpiud048.dll ̎gpJ
  //-------------------------------------------------
  if UD048DllClose() = False then begin
    ErrorMessage(wLogDevice);
    Halt;
  end;
  ResultMessage('UD048DllClose succeeded');
end;

//-------------------------------------------------------------------
// ʂ\
//-------------------------------------------------------------------
procedure TForm1.ResultMessage(szBuf: String);
begin
  MessageBox(Handle, PChar(szBuf), szTitle, MB_OK + MB_ICONINFORMATION);
end;
//-------------------------------------------------------------------
// G[bZ[W\
//-------------------------------------------------------------------
procedure TForm1.ErrorMessage(wLogDevice: Word);
var
  dwRes: DWord;
  szBuf: String;
begin
  dwRes := UD048GetLastError(wLogDevice);
  szBuf := Format('GetLastError'#10#10 +
                  'Error code: %.8xh(%s)'
                  ,[dwRes, str_err(dwRes)]);
  MessageBox(Handle, PChar(szBuf), szTitle, MB_OK + MB_ICONSTOP);
end;

function TForm1.str_err(dwRes: DWord): String;
begin
  case dwRes of
    D048_SUCCESS:
      Result := 'Succeeded';
    D048_ERR_SYSTEM:
      Result := 'System error occured';
    D048_ERR_NO_DEVICE:
      Result := 'Device not found';
    D048_ERR_IN_USE:
      Result := 'Device is in use';
    D048_ERR_INVALID_DEVICENO:
      Result := 'Invalid device number';
    D048_ERR_INVALID_ARGUMENT:
      Result := 'Invalid argument';
    D048_ERR_INVALID_PORT:
      Result := 'Invalid port number';
    D048_ERR_BAD_DIRECTION:
      Result := 'Bad direction';
    D048_ERR_DLL:
      Result := 'DLL not opened';
    D048_ERR_TRG_DATA_INVALID:
      Result := 'Data not accord';
    else
      Result := 'Unknown error';
  end;
end;

end.
