/*****************************************************************************
 *	aisa21w.c
 *
 *	aISA-P21
 *
 *	Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
 *
 *	Date 1998/03/24
 *
 *****************************************************************************/
#include <windows.h>
#include <tchar.h>
#include "aisa21w.h"	// aISA-P21

//---------- X^eBbN֐ & X^eBbNϐ(萔)	----------------------
static BOOL Aisa21wGetDllExportFunc();
static HMODULE hDLL = NULL;

// DLL GNX|[g֐AhX̊i[pϐ
static FARPROC pAisa21GetVersion;
static FARPROC pAisa21Create;
static FARPROC pAisa21Close;
static FARPROC pAisa21GetResource;
static FARPROC pAisa21InPort;
static FARPROC pAisa21OutPort;
static FARPROC pAisa21GetLastError;

BOOL Aisa21wDllOpen ( void )
/*****************************************************************************
 * @\  aisa21.dll[h
 * 	 Ȃ
 * ߒl	 TRUE  --- 
 *		 FALSE --- s
 *****************************************************************************/
{
	if (hDLL != NULL) {
		return FALSE;
	}
	hDLL = (HMODULE)LoadLibrary(AISA21_DLL_NAME);
	if (hDLL == NULL) {
		return FALSE;
	}
	if (Aisa21wGetDllExportFunc() == FALSE) {
		// DLL GNX|[g֐擾ɎŝŁADLL N[Y
		Aisa21wDllClose();
		return FALSE;
	}
	return TRUE;
}

BOOL Aisa21wDllClose ( void )
/*****************************************************************************
 * @\  aisa21.dllA[h
 * 	 Ȃ
 * ߒl	 TRUE  --- 
 *		 FALSE --- s
 *****************************************************************************/
{
	if (hDLL == NULL) {
		return FALSE;
	}
	if (FreeLibrary(hDLL) == TRUE) {
		hDLL = NULL;
		return TRUE;
	}
	return FALSE;
}

BOOL Aisa21wGetVersion ( PDWORD pdwDllVer, PDWORD pdwDrvVer )
/*****************************************************************************
 * @\  aISA-P21DLL,Driver̃o[Wԍ擾
 * 	 pdwDllVer --- DLLo[Wԍi[AhX
 *		 pdwDrvVer --- Drivero[Wԍi[AhX
 * ߒl	 TRUE		   --- 
 *		 FALSE		   --- s
 *****************************************************************************/
{
	if (hDLL == NULL) {
		return FALSE;
	}
	return (*pAisa21GetVersion)(pdwDllVer, pdwDrvVer);
}

BOOL Aisa21wCreate ( PWORD pwLogSlot )
/*****************************************************************************
 * @\  aISA-P21̔Cӂ̃foCX̎gp錾
 * 	 pwLogSlot	--- gpfoCXi[AhX
 * ߒl	 TRUE		--- 
 *		 FALSE		--- s
 *****************************************************************************/
{
	if (hDLL == NULL) {
		return FALSE;
	}
	return (*pAisa21Create)(pwLogSlot);
}

BOOL Aisa21wClose ( WORD wLogSlot )
/*****************************************************************************
 * @\  aISA-P21̔Cӂ̃foCX̎gpJ
 * 	 wLogSlot  --- gpfoCX
 * ߒl	 TRUE	   --- 
 *		 FALSE	   --- s
 *****************************************************************************/
{
	if (hDLL == NULL) {
		return FALSE;
	}
	return (*pAisa21Close)(wLogSlot);
}

BOOL Aisa21wGetResource ( WORD wLogSlot, PAISA21R pResInfo )
/*****************************************************************************
 * @\  wfoCX̃\[X擾
 * 	 wLogSlot --- ׂfoCX
 *		 pResInfo --- \[Xi[\̂̃AhX
 * ߒl	 TRUE	  --- 
 *		 FALSE	  --- s
 *****************************************************************************/
{
	if (hDLL == NULL) {
		return FALSE;
	}
	return (*pAisa21GetResource)(wLogSlot, pResInfo);
}

BOOL Aisa21wInPort ( WORD wLogSlot, DWORD dwPort, PBYTE pbInValue )
/*****************************************************************************
 * @\  Cӂ̃|[gf[^
 * 	 wLogSlot  --- ͂foCX
 *		 dwPort	   --- ͂|[g
 *		 pbInValue --- ̓f[^i[AhX
 * ߒl	 TRUE	   --- 
 *		 FALSE	   --- s
 *****************************************************************************/
{
	if (hDLL == NULL) {
		return FALSE;
	}
	return (*pAisa21InPort)(wLogSlot, dwPort, pbInValue);
}

BOOL Aisa21wOutPort ( WORD wLogSlot, DWORD dwPort, BYTE bOutValue )
/*****************************************************************************
 * @\  Cӂ̃|[gփf[^o
 * 	 wLogSlot  --- o͂foCX
 *		 dwPort	   --- o͂|[g
 *		 bOutValue --- o̓f[^
 * ߒl	 TRUE	   --- 
 *		 FALSE	   --- s
 *****************************************************************************/
{
	if (hDLL == NULL) {
		return FALSE;
	}
	return (*pAisa21OutPort)(wLogSlot, dwPort, bOutValue);
}

DWORD Aisa21wGetLastError ( WORD wLogSlot )
/*****************************************************************************
 * @\  aISA-P21̃G[R[h
 * 	 wLogSlot  --- G[foCX
 * ߒl	 TRUE	   --- 
 *		 FALSE	   --- s
 *****************************************************************************/
{
	if (hDLL == NULL) {
		return AISA21_ERR_WRAPDLL;
	}
	return (*pAisa21GetLastError)(wLogSlot);
}

static BOOL Aisa21wGetDllExportFunc ( void )
/*---------------------------------------------------------------------------
 * 	 DLLGNX|[g֐AhX̎擾
 * 	 Ȃ
 * ߒl	 TRUE	   --- 
 *		 FALSE	   --- s
 *---------------------------------------------------------------------------*/
{
	// Aisa21GetVersion ̃AhX擾
	pAisa21GetVersion = GetProcAddress(hDLL, _T("Aisa21GetVersion"));
	if (pAisa21GetVersion == NULL) {
		return FALSE;
	}

	// Aisa21Create ̃AhX擾
	pAisa21Create = GetProcAddress(hDLL, _T("Aisa21Create"));
	if (pAisa21Create == NULL) {
		return FALSE;
	}

	// Aisa21Close ̃AhX擾
	pAisa21Close = GetProcAddress(hDLL, _T("Aisa21Close"));
	if (pAisa21Close == NULL) {
		return FALSE;
	}

	// Aisa21GetResource ̃AhX擾
	pAisa21GetResource = GetProcAddress(hDLL, _T("Aisa21GetResource"));
	if (pAisa21GetResource == NULL) {
		return FALSE;
	}

	// Aisa21InPort ̃AhX擾
	pAisa21InPort = GetProcAddress(hDLL, _T("Aisa21InPort"));
	if (pAisa21InPort == NULL) {
		return FALSE;
	}

	// Aisa21OutPort ̃AhX擾
	pAisa21OutPort = GetProcAddress(hDLL, _T("Aisa21OutPort"));
	if (pAisa21OutPort == NULL) {
		return FALSE;
	}

	// Aisa21GetLastError ̃AhX擾
	pAisa21GetLastError = GetProcAddress(hDLL, _T("Aisa21GetLastError"));
	if (pAisa21GetLastError == NULL) {
		return FALSE;
	}
	return TRUE;	// SĂ DLL GNX|[g֐AhX擾
}
