/*****************************************************************************
 *	aisa21s.c
 *
 *	aISA-P21
 *
 *	Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
 *
 *	Date 1998/04/20
 *
 *	̃\[Xɂ̓bp[֐̎gpႪLqĂ܂B
 *
 *****************************************************************************/
#define	STRICT
#include	<windows.h>
#include	<tchar.h>
#include	"aisa21w.h"

const TCHAR szTitle[] = _T("Sample");
const TCHAR szP21[] = _T("aISA-P21");
static void ResultMessage(LPCTSTR lpszbuf);
static void ErrorMessage(WORD wLogSlot);

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
												LPSTR lpCmdLine, int nCmdShow)
{
	TCHAR szbuf[256];
	DWORD dwDLLVer, dwDrvVer;
	BOOL  bResult;					// 
	WORD  wLogSlot;					// foCXi[
	BYTE  InValue, OutValue;
	AISA21RESOURCE ri;				// \[X

//-----------------	 aisa21.dll ̎gp錾 --------------------------------
	if (Aisa21wDllOpen() == FALSE) {
		ErrorMessage(AISA21_SLOT_AUTO);
		return 1;			// aisa21.dll ̃[hɎs܂
	}

//--------------------	o[Wԍ\	----------------------------------
	// aISA-P21 DLL,Driver̃o[Wԍ擾
	if (Aisa21wGetVersion(&dwDLLVer, &dwDrvVer) == FALSE) {
		ErrorMessage(AISA21_SLOT_AUTO);
		return 1;
	}
	wsprintf(szbuf, _T("GetVersion\n") _T("DLL Version: %08lxh\n")
							_T("Drv Version: %08lxh"), dwDLLVer, dwDrvVer );
	ResultMessage(szbuf);

//-----------------------  aISA-P21̎gp錾	 ---------------------------

	wLogSlot = AISA21_SLOT_AUTO;			// gp̃foCXT܂B
	bResult = Aisa21wCreate( &wLogSlot );
				// wLogSlot -- ꍇA̎̃foCXi[܂B
	if (bResult == FALSE) {
		ErrorMessage(AISA21_SLOT_AUTO);		// foCX܂B
		return 1;
	}
	wsprintf(szbuf, _T("aISA-P21 Created\n\n") _T("LogSlot: %2d\n"), wLogSlot);
	ResultMessage(szbuf);

//------------------------------  \[X擾  -------------------------
	if (Aisa21wGetResource(wLogSlot, &ri) == FALSE) {
		ErrorMessage(wLogSlot);
		return 1;
	}
	wsprintf(szbuf, _T("Board Name: %s\n") _T("NumPorts: %2d\n")
					_T("IO Address: %04xh-%04xh\n") ,
					szP21, ri.dwIOPortLength[0], ri.dwIOPortBase[0],
					ri.dwIOPortBase[0] + ri.dwIOPortLength[0] - 1 );
	ResultMessage(szbuf);

//------------------   Port0 ɔCӂ̃f[^o  ----------------------------
	OutValue = (BYTE)0xAA;					// o̓f[^ AAh

	if (Aisa21wOutPort(wLogSlot, AISA21_PORT_0, OutValue) == FALSE) {
		ErrorMessage(wLogSlot);
		return 1;
	}
	wsprintf(szbuf, _T("Port0 փf[^o\n")
					_T("Port0 Out Data: %02xh"), OutValue);
	ResultMessage(szbuf);

//---------------------	 Port0 f[^ǂݍ	 -------------------------
	InValue = (BYTE)0x00;

	if (Aisa21wInPort(wLogSlot, AISA21_PORT_0, &InValue) == FALSE) {
		ErrorMessage(wLogSlot);
		return 1;
	}
	wsprintf(szbuf, _T("Port0 f[^\n")
					_T("Port0 In Data: %02xh"), InValue);
	ResultMessage(szbuf);

//-------------------  aISA-P21̎gpJ	 -------------------------------
	if (Aisa21wClose(wLogSlot) == FALSE) {
		ErrorMessage(wLogSlot);
		return 1;
	}
	ResultMessage(_T("aISA-P21 Closed"));

//----------------------  aisa21.dll ̎gpJ  ----------------------------
	if (Aisa21wDllClose() == FALSE) {
		MessageBox(NULL, _T("DLL ̃A[hɎs܂B"),
										szTitle, MB_OK | MB_ICONSTOP);
		return 1;			// aisa21.dll ̃A[hɎs܂B
	}
	return 0;
}

// ʂ\
static void ResultMessage(LPCTSTR lpszbuf)
{
	MessageBox(NULL, lpszbuf, szTitle, MB_OK | MB_ICONINFORMATION);
}

// G[bZ[W\
static void ErrorMessage(WORD wLogSlot)
{
	DWORD dwRes = Aisa21wGetLastError(wLogSlot);
	TCHAR szbuf[50];

	switch (dwRes) {
		case AISA21_ERR_SYSTEM:
			wsprintf(szbuf, _T("System error\n\n")
							_T("Error code: %08lxh"), GetLastError());
			break;

		case AISA21_ERR_WRAPDLL:
			wsprintf(szbuf, _T("DLL Load error"));
			break;

		default:
			wsprintf(szbuf, _T("aISA-P21 error\n\n")
							_T("Error code: %08lxh"), dwRes);
			break;
	}
	MessageBox(NULL, szbuf, szTitle, MB_OK | MB_ICONSTOP);
}
