/******************************************************************************
 * @\:   P21izjhCopwb_t@C
 * File:   aisa21.h
 * :   VTD205b & VC++5.0
 * :   萔ƌ^`̂ݎgp
 * ҏW:   TAB4ŌĂˁB
 *****************************************************************************/
#ifndef	AISA21_H
#define	AISA21_H	0x7021

#ifdef	__cplusplus
extern	"C"
{
#endif

//----------------------- G[R[h̒` ------------------------
#define	AISA21_SUCCESS				0	// Successfully proccessed
#define	AISA21_ERR_SYSTEM			1	// Call GetLastError() 
#define	AISA21_ERR_NO_DEVICE		2	// No card 
#define	AISA21_ERR_IN_USE			3	// Device is in use 
#define	AISA21_ERR_INVALID_SLOT		4	// Invalid logical slot
#define	AISA21_ERR_RESOURCE			5	// Resource exhaustion 
#define	AISA21_ERR_INVALID_PORT		6	// Invalid port 
#define	AISA21_ERR_INVALID_ARGUMENT	7	// Invalid argument 

//--------------------- Port numbers --------------------
#define	AISA21_PORT_0		0
#define	AISA21_PORT_1		1

//---------------------- Miscsellaneous ------------------
#define	AISA21_MAX_SLOTS	16			// Maximum number of slots 
#define	AISA21_SLOT_AUTO	((WORD) ~0U)

//----------------------- Device ID ----------------------
#define	AISA21_DEVICE_ID	(0x21UL | ('P' << 8) | (0x0000UL << 16))

//---------------- Resource infomation structure ---------
#define	AISA21_MAX_MEM		9
#define	AISA21_MAX_IO		20
#define	AISA21_MAX_IRQ		7
#define	AISA21_MAX_DMA		7

typedef	struct	_AISA21RESOURCE {
	DWORD	dwNumMemWindows;				// Not used 
	DWORD	dwMemBase[AISA21_MAX_MEM];		// Not used 
	DWORD	dwMemLength[AISA21_MAX_MEM];		// Not used 
	DWORD	dwMemAttrib[AISA21_MAX_MEM];	// Not used 
	DWORD	dwNumIOPorts;					// Num IO ports 
	DWORD	dwIOPortBase[AISA21_MAX_IO];	// I/O port base 
	DWORD	dwIOPortLength[AISA21_MAX_IO];	// I/O port length 
	DWORD	dwNumIRQs;						// Num IRQ info
	DWORD	dwIRQRegisters[AISA21_MAX_IRQ];	// IRQ list 
	DWORD	dwIRQAttrib[AISA21_MAX_IRQ];	// IRQ Attrib list
	DWORD	dwNumDMAs;						// Not used 
	DWORD	dwDMALst[AISA21_MAX_DMA];		// Not used 
	DWORD	dwDMAAttrib[AISA21_MAX_DMA];	// Not used 
	DWORD	dwReserved1[3];					// Not used 
}	AISA21RESOURCE;

typedef		AISA21RESOURCE *PAISA21R;
typedef		AISA21RESOURCE FAR *LPAISA21R;

#ifndef	AISA21_API
#define	AISA21_API	1

BOOL WINAPI Aisa21Create ( LPWORD lpwLogSlot );
/*****************************************************************************
 * @\: foCX̎gpJn錾
 * : lpwLogSlot --- Specify slot
 * ߒl: TRUE  --- Success
 *		 FALSE --- failure
 *****************************************************************************/

BOOL WINAPI Aisa21Close ( WORD wLogSlot );
/*****************************************************************************
 * @\: foCX̎gpI錾
 * : wLogSlot --- Specify device
 * ߒl: TRUE  --- Success
 *		 FALSE --- failure
 *****************************************************************************/
 
BOOL WINAPI Aisa21GetVersion (LPDWORD lpdwDllVersion, LPDWORD lpdwVxdVersion);
/*****************************************************************************
 * @\: DLLVxD̃o[W擾
 * : lpdwDllVersion --- DLL version
 *		 lpdwVxdVersion --- VxD version
 * ߒl: TRUE  --- Success
 *		 FALSE --- failure
 *****************************************************************************/

BOOL WINAPI Aisa21GetResource ( WORD wLogSlot, LPAISA21R lpres );
/*****************************************************************************
 * @\: foCX̃\[X擾
 * : wLogSlot --- Specify device
 *		 lpres    --- Resource infomation
 * ߒl: TRUE  --- Success
 *		 FALSE --- failure
 *****************************************************************************/

BOOL WINAPI Aisa21InPort (WORD wLogSlot, DWORD dwLogPort, LPBYTE lpbInValue);
/*****************************************************************************
 * @\: ̓|[g̃f[^擾
 * : wLogSlot   --- Specify device
 *		 dwLogPort  --- Logical I/O port number
 *		 lpbInValue --- Input value
 * ߒl: TRUE  --- Success
 *		 FALSE --- failure
 *****************************************************************************/

BOOL WINAPI Aisa21OutPort ( WORD wLogSlot,DWORD dwPort, BYTE bOutValue );
/*****************************************************************************
 * @\: o̓|[gւ̃f[^o
 * : wLogSlot --- Specify device
 *		 dwPort --- Logical I/O port number
 *		 bOutValue --- Output value
 * ߒl: TRUE  --- Success
 *		 FALSE --- failure
 *****************************************************************************/

DWORD WINAPI Aisa21GetLastError ( WORD wLogSlot );
/*****************************************************************************
 * @\: Ō̃G[擾
 * : wLogSlot --- Specify device
 * ߒl: TRUE  --- Success
 *		 FALSE --- failure
 *****************************************************************************/

#endif	// #ifndef AISA21_API

#ifdef	__cplusplus
}
#endif
#endif	// #ifndef AISA21_H
