Attribute VB_Name = "Wrapper"
'*****************************************************************************
'* aisa21w.bas
'*
'* aISA-P21
'*
'* Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
'*
'* Date 1998/04/28
'*
'*****************************************************************************
Option Explicit

Declare Function LoadLibrary Lib "kernel32" Alias "LoadLibraryA" (ByVal lpLibFileName As String) As Long
Declare Function FreeLibrary Lib "kernel32" (ByVal hLibModule As Long) As Long
Declare Function GetProcAddress Lib "kernel32" (ByVal hModule As Long, ByVal lpProcName As String) As Long

Global Const AISA21_DLL_NAME = "aisa21.dll"  ' DLLt@C
Global Const AISA21_ERR_WRAPDLL = -1        ' bp[֐G[

Dim hDLL As Long                'DLLւ̃nh

'*****************************************************************************
'* @\     aisa21.dll[h
'*      Ȃ
'* ߂l   True  --- 
'*          False --- s
'*****************************************************************************
Function Aisa21wDllOpen() As Boolean

    Aisa21wDllOpen = False
    
    If hDLL <> 0 Then Exit Function
    hDLL = LoadLibrary(AISA21_DLL_NAME)
    
    If hDLL = 0 Then Exit Function
    
    If Aisa21wGetDllExportFunc() = False Then
        Aisa21wDllClose     ' DLL GNX|[g֐LmFɎŝŁADLL N[Y
        Exit Function
    End If
    
    Aisa21wDllOpen = True

End Function

'*****************************************************************************
'* @\     aisa21.dllA[h
'*      Ȃ
'* ߂l   True  --- 
'*          False --- s
'*****************************************************************************
Function Aisa21wDllClose() As Boolean
    
    If hDLL = 0 Then
        Aisa21wDllClose = True
        Exit Function
    End If
    
    If FreeLibrary(hDLL) <> 0 Then
        hDLL = 0
        Aisa21wDllClose = True
        Exit Function
    End If
    
    Aisa21wDllClose = False

End Function

'*****************************************************************************
'* @\     aISA-P21 DLL,Driver̃o[Wԍ擾
'*      pdwDllVer --- DLLo[Wԍi[
'*          pdwDrvVer --- Drivero[Wԍi[
'* ߂l   True          --- 
'*          False         --- s
'*****************************************************************************
Function Aisa21wGetVersion(pdwDllVer As Long, pdwDrvVer As Long) As Boolean
    
    If hDLL = 0 Then
        Aisa21wGetVersion = 0
        Exit Function
    End If
    
    If Aisa21GetVersion(pdwDllVer, pdwDrvVer) <> 0 Then
        Aisa21wGetVersion = True
    Else
        Aisa21wGetVersion = False
    End If

End Function

'*****************************************************************************
'* @\     aISA-P21̔Cӂ̃foCX̎gp錾
'*      pwLogSlot --- gpfoCXi[AhX
'* ߂l   True      --- 
'*          False     --- s
'*****************************************************************************
Function Aisa21wCreate(pwLogSlot As Integer) As Boolean
    
    If hDLL = 0 Then
        Aisa21wCreate = False
        Exit Function
    End If
    
    If Aisa21Create(pwLogSlot) <> 0 Then
        Aisa21wCreate = True
    Else
        Aisa21wCreate = False
    End If

End Function

'*****************************************************************************
'* @\     aISA-P21̔Cӂ̃foCX̎gpJ
'*      wLogSlot --- gpfoCX
'* ߂l   True     --- 
'*          False    --- s
'*****************************************************************************
Function Aisa21wClose(wLogSlot As Integer) As Boolean
    
    If hDLL = 0 Then
        Aisa21wClose = False
        Exit Function
    End If
    
    If Aisa21Close(wLogSlot) <> 0 Then
        Aisa21wClose = True
    Else
        Aisa21wClose = False
    End If

End Function

'*****************************************************************************
'* @\     wfoCX̃\[X擾
'*      wLogSlot --- ׂfoCX
'*          pResInfo --- \[Xi[\̂̃AhX
'* ߂l   True     --- 
'*          False    --- s
'*****************************************************************************
Function Aisa21wGetResource(wLogSlot As Integer, pResInfo As AISA21RESOURCE) As Boolean
    
    If hDLL = 0 Then
        Aisa21wGetResource = False
        Exit Function
    End If
    
    If Aisa21GetResource(wLogSlot, pResInfo) <> 0 Then
        Aisa21wGetResource = True
    Else
        Aisa21wGetResource = False
    End If

End Function

'*****************************************************************************
'* @\     Cӂ̃|[gf[^
'*      wLogSlot  --- ͂foCX
'*          dwPort    --- ͂|[g
'*          pbInValue --- ̓f[^i[
'* ߂l   True      --- 
'*          False     --- s
'*****************************************************************************
Function Aisa21wInPort(wLogSlot As Integer, dwPort As Long, pbInValue As Byte) As Boolean
    
    If hDLL = 0 Then
        Aisa21wInPort = False
        Exit Function
    End If
    
    If Aisa21InPort(wLogSlot, dwPort, pbInValue) <> 0 Then
        Aisa21wInPort = True
    Else
        Aisa21wInPort = False
    End If

End Function

'*****************************************************************************
'* @\     Cӂ̃|[gփf[^o
'*      wLogSlot  --- o͂foCX
'*          dwPort    --- o͂|[g
'*          bOutValue --- o͂f[^
'* ߂l   True      --- 
'*          False     --- s
'*****************************************************************************
Function Aisa21wOutPort(wLogSlot As Integer, dwPort As Long, bOutValue As Byte) As Boolean
    
    If hDLL = 0 Then
        Aisa21wOutPort = False
        Exit Function
    End If
    
    If Aisa21OutPort(wLogSlot, dwPort, bOutValue) <> 0 Then
        Aisa21wOutPort = True
    Else
        Aisa21wOutPort = False
    End If

End Function

'*****************************************************************************
'* @\      aISA-P21̃G[R[h𓾂
'*       wLogSlot --- G[foCX
'* ߂l             --- G[R[h
'*****************************************************************************
Function Aisa21wGetLastError(wLogSlot As Integer) As Long
    
    If hDLL = 0 Then
        Aisa21wGetLastError = AISA21_ERR_WRAPDLL
        Exit Function
    End If
    
    Aisa21wGetLastError = Aisa21GetLastError(wLogSlot)

End Function

'*****************************************************************************
'* @\     DLLGNX|[g֐L̊mF
'*      Ȃ
'* ߂l   True  --- 
'*          False --- s
'*****************************************************************************
Private Function Aisa21wGetDllExportFunc() As Boolean
    
    Dim pFunc As Long
    
    Aisa21wGetDllExportFunc = False
    
    ' Aisa21GetVersion ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Aisa21GetVersion")
    If pFunc = 0 Then Exit Function
          
    ' Aisa21Create ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Aisa21Create")
    If pFunc = 0 Then Exit Function
          
    ' Aisa21Close ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Aisa21Close")
    If pFunc = 0 Then Exit Function

    ' Aisa21GetResource ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Aisa21GetResource")
    If pFunc = 0 Then Exit Function

    ' Aisa21InPort ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Aisa21InPort")
    If pFunc = 0 Then Exit Function

    ' Aisa21OutPort ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Aisa21OutPort")
    If pFunc = 0 Then Exit Function

    ' Aisa21GetLastError ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Aisa21GetLastError")
    If pFunc = 0 Then Exit Function

    Aisa21wGetDllExportFunc = True  ' SĂ DLL GNX|[g֐݂̑mF

End Function
