Attribute VB_Name = "Sample"
'*****************************************************************************
'* aisa21s.bas
'*
'* aISA-P21
'*
'* Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
'*
'* Date 1998/05/19
'*
'*  ̃\[Xɂ̓bp[֐̎gpႪLqĂ܂B
'*
'*****************************************************************************
Option Explicit

Private Const szName = "aISA-P21"
Private Declare Function GetLastError Lib "kernel32" () As Long

Sub Main()

    Dim strbuf As String
    Dim dwDllVer As Long                ' DLL̃o[W
    Dim dwDrvVer As Long                ' Driver̃o[W
    Dim bResult As Boolean              ' 
    Dim wLogSlot As Integer             ' foCXi[
    Dim InValue As Byte                 ' o̓f[^
    Dim OutValue As Byte
    Dim ri As AISA21RESOURCE            ' \[X

'---------------------------------------------------------------------------
    ' aisa21.dll ̎gp錾
    If Aisa21wDllOpen() = False Then
        ErrorMessage (AISA21_SLOT_AUTO)
        Exit Sub                ' aisa21.dll ̃[hɎs܂B
    End If

'---------------------------------------------------------------------------
    ' o[Wԍ\
    If Aisa21wGetVersion(dwDllVer, dwDrvVer) = False Then ' aISA-P21DLL,Driver̃o[Wԍ擾
        ErrorMessage (AISA21_SLOT_AUTO)
        Exit Sub
    End If

    strbuf = "GetVersion" + Chr(10) + _
             "DLL Version: &H" + Hex(dwDllVer) + Chr(10) + _
             "Drv Version: &H" + Hex(dwDrvVer)
    ResultMessage (strbuf)

'---------------------------------------------------------------------------
    ' aISA-P21̎gp錾
    wLogSlot = AISA21_SLOT_AUTO     ' gp̃foCXT܂B
    bResult = Aisa21wCreate(wLogSlot)

    If bResult = False Then         ' foCX܂B
        ErrorMessage (AISA21_SLOT_AUTO)
        Exit Sub
    End If

    strbuf = "aISA-P21 Created" + Chr(10) + Chr(10) + _
          "LogSlot: " + Str(wLogSlot)

    ResultMessage (strbuf)

'---------------------------------------------------------------------------
    ' \[X擾
    If Aisa21wGetResource(wLogSlot, ri) = False Then
        ErrorMessage (wLogSlot)
        Exit Sub
    End If

    strbuf = "Board Name: " + szName + Chr(10) + _
             "NumPorts: " + Str(ri.dwIOPortLength(1)) + Chr(10) + _
             "IO Address: &H" + Hex(ri.dwIOPortBase(1)) + _
             "-&H" + Hex(ri.dwIOPortBase(1) + ri.dwIOPortLength(1) - 1)

    ResultMessage (strbuf)

'---------------------------------------------------------------------------
    ' Port 0ɔCӂ̃f[^o
    ' &HAA -> 10101010
    OutValue = &HAA

    If Aisa21wOutPort(wLogSlot, AISA21_PORT_0, OutValue) = False Then
        ErrorMessage (wLogSlot)
        Exit Sub
    End If

    strbuf = "Port 0փf[^o" + Chr(10) + _
             "Port 0 Out Data: &H" + Hex(OutValue)

    ResultMessage (strbuf)

'---------------------------------------------------------------------------
    ' Port 0 f[^ǂݍ
    InValue = &H0

    If Aisa21wInPort(wLogSlot, AISA21_PORT_0, InValue) = False Then
        ErrorMessage (wLogSlot)
        Exit Sub
    End If

    strbuf = "Port 0 f[^" + Chr(10) + _
             "Port 0 In Data: &H" + Hex(InValue)

    ResultMessage (strbuf)

'---------------------------------------------------------------------------
    ' aISA-P21̎gpJ
    If Aisa21wClose(wLogSlot) = False Then
        ErrorMessage (wLogSlot)
        Exit Sub
    End If

    ResultMessage ("aISA-P21 Closed")

'---------------------------------------------------------------------------
    ' aisa21.dll̎gpJ
    If Aisa21wDllClose() = False Then
        MsgBox "DLL ̃A[hɎs܂B", vbOKOnly + vbCritical
        Exit Sub        ' aisa21.dll ̃A[hɎs܂B
    End If

End Sub

' ʂ\
Private Sub ResultMessage(lpszbuf As String)

    MsgBox lpszbuf, vbOKOnly + vbInformation

End Sub


' G[bZ[W\
Private Sub ErrorMessage(wLogSlot As Integer)

    Dim dwRes As Long
    Dim szbuf As String

    dwRes = Aisa21wGetLastError(wLogSlot)

    Select Case dwRes
    Case AISA21_ERR_SYSTEM
        szbuf = "System error" + Chr(10) + Chr(10) + _
                "Error code: &H" + _
                Hex(GetLastError())

    Case AISA21_ERR_WRAPDLL
        szbuf = "DLL Load error"

    Case Else                           ' ̑̒l̏ꍇB
        szbuf = "aISA-P21 error" + Chr(10) + Chr(10) + _
                "Error code: &H" + _
                Hex(dwRes)
    End Select

    MsgBox szbuf, vbOKOnly + vbCritical

End Sub
