Attribute VB_Name = "DLLDef"
'-----------------------------------------------------------------------
'       aisa21.bas
'
'       AISA-P21 Win32 API.
'-----------------------------------------------------------------------

Option Explicit

' Errors

Global Const AISA21_SUCCESS = 0                ' Successfully proccessed
Global Const AISA21_ERR_SYSTEM = 1             ' Call GetLastError()
Global Const AISA21_ERR_NO_DEVICE = 2          ' No card
Global Const AISA21_ERR_IN_USE = 3             ' Device is in use
Global Const AISA21_ERR_INVALID_SLOT = 4       ' Invalid logical slot
Global Const AISA21_ERR_RESOURCE = 5           ' Resource exhaustion
Global Const AISA21_ERR_INVALID_PORT = 6       ' Invalid port
Global Const AISA21_ERR_INVALID_ARGUMENT = 7   ' Invalid port

' Port numbers

Global Const AISA21_PORT_0 = 0
Global Const AISA21_PORT_1 = 1


' Miscsellaneous

Global Const AISA21_MAX_SLOTS = 16             ' Maximum number of slots

Global Const AISA21_SLOT_AUTO = &HFFFF

' Device ID

Global Const AISA21_DEVICE_ID = &H5021

' Resource infomation structure

Global Const AISA21_MAX_MEM = 9
Global Const AISA21_MAX_IO = 20
Global Const AISA21_MAX_IRQ = 7
Global Const AISA21_MAX_DMA = 7

Type AISA21RESOURCE
    dwNumMemWindows As Long                         ' Not used
    dwMemBase(1 To AISA21_MAX_MEM) As Long          ' Not used
    dwMemLength(1 To AISA21_MAX_MEM) As Long        ' Not used
    dwMemAttrib(1 To AISA21_MAX_MEM) As Long        ' Not used
    dwNumIOPorts As Long                            ' Num IO ports
    dwIOPortBase(1 To AISA21_MAX_IO) As Long        ' I/O port base
    dwIOPortLength(1 To AISA21_MAX_IO) As Long      ' I/O port length
    dwNumIRQs As Long                               ' Num IRQ info
    dwIRQRegisters(1 To AISA21_MAX_IRQ) As Long     ' IRQ list
    dwIRQAttrib(1 To AISA21_MAX_IRQ) As Long        ' IRQ Attrib list
    dwNumDMAs As Long                               ' Not used
    dwDMALst(1 To AISA21_MAX_DMA) As Long           ' Not used
    dwDMAAttrib(1 To AISA21_MAX_DMA) As Long        ' Not used
    dwReserved1(1 To 3) As Long                     ' Not used
End Type

Declare Function Aisa21GetVersion Lib "aisa21" (lpdwDllVer As Long, lpdwDrvVer As Long) As Long
Declare Function Aisa21Create Lib "aisa21" (lpwLogSlot As Integer) As Long
Declare Function Aisa21Close Lib "aisa21" (ByVal wLogSlot As Integer) As Long
Declare Function Aisa21GetResource Lib "aisa21" (ByVal wLogSlot As Integer, lpres As AISA21RESOURCE) As Long
Declare Function Aisa21InPort Lib "aisa21" (ByVal wLogSlot As Integer, ByVal dwLogPort As Long, lpbInValue As Byte) As Long
Declare Function Aisa21OutPort Lib "aisa21" (ByVal wLogSlot As Integer, ByVal dwLogPort As Long, ByVal bOutValue As Byte) As Long
Declare Function Aisa21GetLastError Lib "aisa21" (ByVal wLogSlot As Integer) As Long
