//****************************************************************************
//	aisa21w.pas
//
//	aISA-P21
//
//	Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
//
//	Date 1998/05/19
//
//****************************************************************************

unit aisa21w;

interface

uses
	Windows;

{ Errors }

const
	AISA21_SUCCESS							= 0;	 { ُȂ }
	AISA21_ERR_SYSTEM						= 1;	 { GetLastError sĂ }
	AISA21_ERR_NO_DEVICE				= 2;	 { gXbgȂ}
	AISA21_ERR_IN_USE						= 3;	 { w肳ꂽXbg͎gp }
	AISA21_ERR_INVALID_SLOT			= 4;	 { sȃXbgԍw肵 }
	AISA21_ERR_RESOURCE					= 5;	 { \[XG[ }
	AISA21_ERR_INVALID_PORT			= 6;	 { sȃ|[gv }
	AISA21_ERR_INVALID_ARGUMENT = 7;	 { sȈv }

{ Port numbers }

const
	AISA21_PORT_0	= 0;
	AISA21_PORT_1	= 1;


{ Miscellaneous }

const
	AISA21_MAX_SLOTS	= 16;	{ Maximum number of slots }


{ Device ID }

const
	AISA21_DEVICE_ID	= $00005021;

const
	AISA21_ERR_WRAPDLL = DWord(-1); { bp[֐G[ }

const
	AISA21_DLL_NAME = 'aisa21.dll';		{ DLL }

function Aisa21wDllOpen: Boolean;			{ DLL [h }
function Aisa21wDllClose: Boolean;		{ DLL A[h }


const
	AISA21_SLOT_AUTO = $ffff;

{ aISA-P21 DLL,Driver̃o[Wԍ擾 }
function Aisa21wGetVersion(var pdwDllVer: DWord; var pdwDrvVer: DWord): Boolean;


{ CӂaISA-P21̎gp錾 }
function Aisa21wCreate(var pwLogSlot: Word): Boolean;
{ CӂaISA-P21̎gpJ }
function Aisa21wClose(wLogSlot: Word): Boolean;


{ Resource infomation structure }

const
		AISA21_MAX_MEM	=	 9;
		AISA21_MAX_IO		= 20;
		AISA21_MAX_IRQ	=	 7;
		AISA21_MAX_DMA	=	 7;

type
		TAISA21RESOURCE = record
				dwNumMemWindows:DWORD;																	{ EBhE gp }
				dwMemBase:			array [1 .. AISA21_MAX_MEM] of DWORD;		{ EChEx[XAhX@gp }
				dwMemLength:		array [1 .. AISA21_MAX_MEM] of DWORD;		{ EChE@gp }
				dwMemAttrib:		array [1 .. AISA21_MAX_MEM] of DWORD;		{ EChE@gp }
				dwNumIOPorts:		DWORD;																	{ I/O|[g }
				dwIOPortBase:		array [1 .. AISA21_MAX_IO] of DWORD;		{ I/O|[gx[XAhX }
				dwIOPortLength: array [1 .. AISA21_MAX_IO] of DWORD;		{ I/O|[g }
				dwNumIRQs:			DWORD;																	{ IRQ@gp }
				dwIRQRegisters: array [1 .. AISA21_MAX_IRQ] of DWORD;		{ IRQXg gp }
				dwIRQAttrib:		array [1 .. AISA21_MAX_IRQ] of DWORD;		{ IRQXg gp }
				dwNumDMAs:			DWORD;																	{ DMA`l gp }
				dwDMALst:				array [1 .. AISA21_MAX_DMA] of DWORD;		{ DMA`lXg gp }
				dwDMAAttrib:		array [1 .. AISA21_MAX_DMA] of DWORD;		{ DMA`lXg gp }
				dwReserved1:		array [1 .. 3] of DWORD;								{ \  }
		end;

PAISA21RESOURCE = ^TAISA21RESOURCE;

{ \[X擾 }
function Aisa21wGetResource(wLogSlot: Word;  pResInfo: PAISA21RESOURCE): Boolean;

{ Cӂ̃|[gf[^ }
function Aisa21wInPort(wLogSlot: Word; dwPort: DWord; var pbInValue: Byte): Boolean;
{ Cӂ̃|[gփf[^o }
function Aisa21wOutPort(wLogSlot: Word; dwPort: DWord; bOutValue: Byte): Boolean;


{ aISA-P21̃G[R[h }
function Aisa21wGetLastError(wLogSlot: Word): DWord;

implementation

type
	TAisa21GetVersion = function(var pdwDllVer: DWORD; var	pdwDrvVer: DWORD): BOOL; stdcall;
	TAisa21Create = function(var pwLogSlot: Word): BOOL; stdcall;
	TAisa21Close = function(wLogSlot:	WORD): BOOL; stdcall;
	TAisa21GetResource = function(wLogSlot: WORD; res: PAISA21RESOURCE):	BOOL; stdcall;
	TAisa21InPort = function(wLogSlot: WORD; dwLogPort: DWORD; var lpbInValue: BYTE): BOOL; stdcall;
	TAisa21OutPort = function(wLogSlot: WORD; dwLogPort: DWORD; bOutValue: BYTE): BOOL; stdcall;
	TAisa21GetLastError = function(wLogSlot: WORD): DWORD; stdcall;

function Aisa21wGetDllExportFunc: Boolean; forward;

{$J+}
const
	hDLL: THandle = 0;
{$J-}

 { DLL GNX|[g֐AhX̊i[ϐ }
var
	pAisa21GetVersion: TAisa21GetVersion;
	pAisa21Create: TAisa21Create;
	pAisa21Close: TAisa21Close;
	pAisa21GetResource: TAisa21GetResource;
	pAisa21InPort: TAisa21InPort;
	pAisa21OutPort: TAisa21OutPort;
	pAisa21GetLastError: TAisa21GetLastError;


//****************************************************************************
// @\			aisa21.dll[h
// 			Ȃ
// ߂l 	True  --- 
//		  		False --- s
//****************************************************************************
function Aisa21wDllOpen: Boolean;
begin
	Result := False;

	if hDLL <> 0 then Exit;

	hDLL := LoadLibrary(AISA21_DLL_NAME);
	if hDLL = 0 then Exit;

	if Aisa21wGetDllExportFunc = False then
  begin
       Aisa21wDllClose;	// DLL GNX|[g֐擾ɎŝŁADLL N[Y
		   Exit;
  end;

	Result := True;
end;

//****************************************************************************
// @\			aisa21.dllA[h
// 			Ȃ
// ߂l 	True  --- 
//		  		False --- s
//****************************************************************************
function Aisa21wDllClose: Boolean;
begin
	Result := True;

	if hDLL = 0 then Exit;

	if FreeLibrary(hDLL) = True then hDLL := 0
	else Result := False;
end;

//****************************************************************************
// @\			aISA-P21 DLL,Driver̃o[Wԍ擾
// 			pdwDllVer --- DLLo[Wԍi[
//					pdwDrvVer --- Drvo[Wԍi[
// ߂l 	True  				--- 
//		  		False 				--- s
//****************************************************************************
function Aisa21wGetVersion(var pdwDllVer: DWord; var pdwDrvVer: DWord): Boolean;
begin
	Result := False;

	if hDLL = 0 then Exit;

	Result := pAisa21GetVersion(pdwDllVer, pdwDrvVer);
end;

//****************************************************************************
// @\			aISA-P21̔Cӂ̃foCX̎gp錾
// 			pwLogSlot	 --- gpfoCXi[AhX
// ߂l 	True  		 --- 
//		  		False 		 --- s
//****************************************************************************
function Aisa21wCreate(var pwLogSlot: Word): Boolean;
begin
  Result := False;

  if hDLL = 0 then Exit;

	Result := pAisa21Create(pwLogSlot);
end;

//****************************************************************************
// @\			aISA-P21̔Cӂ̃foCX̎gpJ
// 			wLogSlot --- gpfoCX
// ߂l 	True  	 --- 
//		  		False 	 --- s
//****************************************************************************
function Aisa21wClose(wLogSlot: Word): Boolean;
begin
  Result := False;

	if hDLL = 0 then Exit;

	Result := pAisa21Close(wLogSlot);
end;


//****************************************************************************
// @\		wfoCX̃\[X擾
// 			wLogSlot --- ׂfoCX
//					pResInfo --- \[Xi[\̂̃AhX
// ߂l 	True  	 --- 
//		  		False 	 --- s
//****************************************************************************
function Aisa21wGetResource(wLogSlot: Word;  pResInfo: PAISA21RESOURCE): Boolean;
begin
	Result := False;

	if hDLL = 0 then Exit;

	Result := pAisa21GetResource(wLogSlot, pResInfo);
end;


//****************************************************************************
// @\			Cӂ̃|[gf[^
// 			wLogSlot	--- ͂foCX
//					dwPort		--- ͂|[g
//					pbInValue --- ̓f[^i[
// ߂l 	True  		--- 
//		  		False 		--- s
//****************************************************************************
function Aisa21wInPort(wLogSlot: Word; dwPort: DWord; var pbInValue: Byte): Boolean;
begin
	Result := False;

	if hDLL = 0 then Exit;

	Result := pAisa21InPort(wLogSlot, dwPort, pbInValue);
end;

//****************************************************************************
// @\			Cӂ̃|[gփf[^o
// 			wLogSlot	--- o͂foCX
//					dwPort		--- o͂|[g
//					bOutValue --- o͂f[^
// ߂l 	True  		--- 
//		  		False 		--- s
//****************************************************************************
function Aisa21wOutPort(wLogSlot: Word; dwPort: DWord; bOutValue: Byte): Boolean;
begin
	Result := False;

	if hDLL = 0 then Exit;

	Result := pAisa21OutPort(wLogSlot, dwPort, bOutValue);
end;

//****************************************************************************
// @\			aISA-P21̃G[R[h
// 			wLogSlot --- G[foCX
// ߂l 				 	 --- G[R[h
//****************************************************************************
function Aisa21wGetLastError(wLogSlot: Word): DWord;
begin
	Result := AISA21_ERR_WRAPDLL;

	if hDLL = 0 then Exit;

	Result := pAisa21GetLastError(wLogSlot);
end;

//****************************************************************************
// 	  	DLLGNX|[g֐AhX̎擾
// 	  	Ȃ
// ߂l 	True  --- 
//		  		False --- s
//****************************************************************************
function Aisa21wGetDllExportFunc: Boolean;
begin
	Result := False;

	// Aisa21GetVersion ̃AhX擾
	pAisa21GetVersion := GetProcAddress(hDLL, 'Aisa21GetVersion');
	if @pAisa21GetVersion = nil then Exit;

	// Aisa21Create ̃AhX擾
	pAisa21Create := GetProcAddress(hDLL, 'Aisa21Create');
	if @pAisa21Create = nil then Exit;

	// Aisa21Close ̃AhX擾
	pAisa21Close := GetProcAddress(hDLL, 'Aisa21Close');
	if @pAisa21Close = nil then Exit;

	// Aisa21GetResource ̃AhX擾
	pAisa21GetResource := GetProcAddress(hDLL, 'Aisa21GetResource');
	if @pAisa21GetResource = nil then Exit;

	// Aisa21InPort ̃AhX擾
	pAisa21InPort := GetProcAddress(hDLL, 'Aisa21InPort');
	if @pAisa21InPort = nil then Exit;

	// Aisa21OutPort ̃AhX擾
	pAisa21OutPort := GetProcAddress(hDLL, 'Aisa21OutPort');
	if @pAisa21OutPort = nil then Exit;

	// Aisa21GetLastError ̃AhX擾
	pAisa21GetLastError := GetProcAddress(hDLL, 'Aisa21GetLastError');
	if @pAisa21GetLastError = nil then Exit;

	Result := True;	// SĂ DLL GNX|[g֐AhX擾
end;

end.

