//****************************************************************************
//	aisa21s.pas
//
//	aISA-P21
//
//	Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
//
//	Date 1998/05/19
//
//	̃\[Xɂ̓bp[֐̎gpႪLqĂ܂B
//
//****************************************************************************
unit aisa21s;

interface

uses
	Windows, Messages, SysUtils, Forms, aisa21w;

const
	szTitle = 'Sample';
	szName = 'aISA-P21';

type
	TForm1 = class(TForm)
		procedure FormCreate(Sender: TObject);
	private
		procedure ResultMessage(strbuf: String);
		procedure ErrorMessage(wLogSlot: Word);
	public
		{ Public 錾 }
	end;

var
	Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
	strbuf:	 String;
	dwDLLVer, dwDrvVer: DWord;	// DLLCDrivero[W
	bResult:	Boolean;					// 
	wLogSlot: Word;							// foCXi[
	InValue:	Byte;							// o̓f[^
	OutValue: Byte;
	ri:				TAISA21RESOURCE;	// \[X
begin
//---------------------------------------------------------------------------
	// aisa21.dll ̎gp錾
	if Aisa21wDllOpen() = False then
	begin
		ErrorMessage(AISA21_SLOT_AUTO);
		Exit;			// aisa21.dll ̃[hɎs܂
	end;

//---------------------------------------------------------------------------
	// o[Wԍ\
	// aISA-P21 DLL,Driver̃o[Wԍ擾
	if Aisa21wGetVersion(dwDLLVer, dwDrvVer) = False then
	begin
		ErrorMessage(AISA21_SLOT_AUTO);
		Exit;
	end;

	strbuf := Format('GetVersion'#10 +
					 'DLL Version: %08xH'#10 +
					 'Drv Version: %08xH',
										 [dwDLLVer, dwDrvVer]);

	ResultMessage(strbuf);

//---------------------------------------------------------------------------
	// aISA-P21̎gp錾
	wLogSlot := AISA21_SLOT_AUTO;				// gp̃foCXT܂B
	bResult := Aisa21wCreate(wLogSlot);	// ꍇA̎̃foCXi[܂B

	if bResult = False then		// foCX܂B
	begin
		ErrorMessage(AISA21_SLOT_AUTO);
		Exit;
	end;

	strbuf := Format('aISA-P21 Created'#10#10 +
									 'LogSlot: %2d', [wLogSlot]);

	ResultMessage(strbuf);


//---------------------------------------------------------------------------
	// \[X擾
	if Aisa21wGetResource(wLogSlot, @ri) = False then
	begin
		ErrorMessage(wLogSlot);
		Exit;
	end;

	strbuf := Format('Board Name: %s'#10 +
						 'NumPorts: %2d'#10 +
						 'IO Address: %04xH -%04xH'#10,
											[szName, ri.dwIOPortLength[1],
											ri.dwIOPortBase[1],
											ri.dwIOPortBase[1] + ri.dwIOPortLength[1] - 1]);

	ResultMessage(strbuf);

//---------------------------------------------------------------------------
	// Port 0 ɔCӂ̃f[^o
	// o̓f[^ AAh
	OutValue := Byte($AA);

	if Aisa21wOutPort(wLogSlot, AISA21_PORT_0, OutValue) = False then
	begin
		ErrorMessage(wLogSlot);
		Exit;
	end;

	strbuf := Format('Port 0 փf[^o'#10 +
					 'Port 0 Out Data: %02xH',
					 [OutValue]);

	ResultMessage(strbuf);

//---------------------------------------------------------------------------
	// A Port f[^ǂݍ
	InValue := Byte($00);

	if Aisa21wInPort(wLogSlot, AISA21_PORT_0, InValue) = False then
	begin
		ErrorMessage(wLogSlot);
		Exit;
	end;

	strbuf := Format('Port 0 f[^'#10 +
					 'Port 0 In Data: %02xH',
					 [InValue]);

	ResultMessage(strbuf);

//---------------------------------------------------------------------------
	// aISA-P21̎gpJ
	if Aisa21wClose(wLogSlot) = False then
	begin
		ErrorMessage(wLogSlot);
		Exit;
	end;

	ResultMessage('aISA-P21 Closed');

	// aisa21.dll ̎gpJ
	if Aisa21wDllClose() = False then
	begin
		Application.MessageBox(PChar('DLL ̃A[hɎs܂B'), szTitle, MB_OK + MB_ICONSTOP);
		Exit;			// aisa21.dll ̃A[hɎs܂B
	end;

end;

// ʂ\
procedure TForm1.ResultMessage(strbuf: String);
begin
	Application.MessageBox(PChar(strbuf), szTitle, MB_OK + MB_ICONINFORMATION);
end;

// G[bZ[W\
procedure TForm1.ErrorMessage(wLogSlot: Word);
var
	dwRes: DWord;
	strbuf: String;
begin
	dwRes := Aisa21wGetLastError(wLogSlot);

	case dwRes of
		AISA21_ERR_SYSTEM:
			strbuf := Format('System error'#10#10'Error code: %08xH', [GetLastError()]);

		AISA21_ERR_WRAPDLL:
			strbuf := 'DLL Load error';
	else
		strbuf := Format('aISA-P21 error'#10#10'Error code: %08xH',[dwRes]);
	end;

	Application.MessageBox(PChar(strbuf), szTitle, MB_OK + MB_ICONSTOP);
end;

end.
