/*****************************************************************************/
/*	apci8806w.c																 */
/*																			 */
/*	aPCI-8806F/H														 */
/*																			 */
/*	Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.									 */
/*****************************************************************************/

#include <windows.h>
#include <tchar.h>

#include "apci8806w.h"	// aPCI-8806F/H

/*---------- X^eBbN֐ -----------------------------------------------*/
static BOOL Apci8806wGetDllExportFunc();


/*---------- X^eBbNϐ(萔) -----------------------------------------*/
static HMODULE hDLL = NULL;

// DLL GNX|[g֐AhX̊i[ϐ
static FARPROC pApci8806GetVersion;
static FARPROC pApci8806Create;
static FARPROC pApci8806Close;
static FARPROC pApci8806GetResource;
static FARPROC pApci8806SetData;
static FARPROC pApci8806GetCH;
static FARPROC pApci8806GetLastError;


/*****************************************************************************/
/* 	  apci8806.dll[h												 */
/* 	  																 */
/* ߂l  TRUE															 */
/*		  s FALSE														 */
/*****************************************************************************/
BOOL Apci8806wDllOpen()
{
	if (hDLL != NULL)
		return FALSE;

	hDLL = (HMODULE)LoadLibrary(APCI8806_DLL_NAME);
	if (hDLL == NULL)
		return FALSE;

	if (!Apci8806wGetDllExportFunc())
	{
		Apci8806wDllClose();	// DLL GNX|[g֐擾ɎŝŁADLL N[Y
		return FALSE;
	}

	return TRUE;
}

/*****************************************************************************/
/* 	  apci8806.dllA[h											 */
/* 	  																 */
/* ߂l  TRUE															 */
/*		  s FALSE														 */
/*****************************************************************************/
BOOL Apci8806wDllClose()
{
	if (hDLL == NULL)
		return TRUE;

	if (FreeLibrary(hDLL))
	{
		hDLL = NULL;
		return TRUE;
	}

	return FALSE;
}

/*****************************************************************************/
/* 	  aPCI-8806F/H DLL,Vxd̃o[Wԍ擾							 */
/* 	  pdwDllVersion DLLo[Wԍ̊i[AhX					 */
/*		  pdwVxdVersion Vxdo[Wԍ̊i[AhX					 */
/* ߂l  TRUE															 */
/*		  s FALSE														 */
/*****************************************************************************/
BOOL Apci8806wGetVersion(PDWORD pdwDllVersion, PDWORD pdwVxdVersion)
{
	if (hDLL == NULL)
		return FALSE;

	return (*pApci8806GetVersion)(pdwDllVersion, pdwVxdVersion);
}

/*****************************************************************************/
/* 	  aPCI-8806F/H̔Cӂ̃foCX̎gp錾							 */
/* 	  pwLogSlot gpfoCXi[AhX						 */
/*		  hWnd		bZ[W󂯎EBhEnh					 */
/*		  uWMBase	bZ[WID̊l									 */
/*		  pvInitArg ̂߂̗\										 */
/* ߂l  TRUE															 */
/*		  s FALSE														 */
/*****************************************************************************/
BOOL Apci8806wCreate(PWORD pwLogSlot)
{
	if (hDLL == NULL)
		return FALSE;

	return (*pApci8806Create)(pwLogSlot);
}

/*****************************************************************************/
/* 	  aPCI-8806F/H̔Cӂ̃foCX̎gpJ							 */
/* 	  wLogSlot gpfoCX											 */
/* ߂l  TRUE															 */
/*		  s FALSE														 */
/*****************************************************************************/
BOOL Apci8806wClose(WORD wLogSlot)
{
	if (hDLL == NULL)
		return FALSE;

	return (*pApci8806Close)(wLogSlot);
}

/*****************************************************************************/
/* 	  wfoCX̃\[X擾									 */
/* 	  wLogSlot ׂfoCX											 */
/*		  pResInfo \[Xi[\̂̃AhX					 */
/* ߂l  TRUE															 */
/*		  s FALSE														 */
/*****************************************************************************/
BOOL Apci8806wGetResource(WORD wLogSlot, PAPCI8806R pResInfo)
{
	if (hDLL == NULL)
		return FALSE;

	return (*pApci8806GetResource)(wLogSlot, pResInfo);
}

/*****************************************************************************/
/* 	  o̓f[^̐ݒ													 */
/* 	  wLogSlot _Xbg												 */
/*		  wChData  ݃`l(0 ` 3)									 */
/*		  wDaData  D/A݃f[^										 */
/* ߂l  TRUE															 */
/*		  s FALSE														 */
/*****************************************************************************/
BOOL Apci8806wSetData(WORD wLogSlot, WORD wChData, WORD wDaData)
{
	if (hDLL == NULL)
		return FALSE;

	return (*pApci8806SetData)(wLogSlot, wChData, wDaData);
}

/*****************************************************************************/
/* 	  O͏Ԃ̎擾												 */
/* 	  wLogSlot _Xbg												 */
/*		  pdwCH1   CH1̏												 */
/*		  pdwCH2   CH2̏												 */
/* ߂l  TRUE															 */
/*		  s FALSE														 */
/*****************************************************************************/
BOOL Apci8806wGetCH(WORD wLogSlot, PDWORD pdwCH1, PDWORD pdwCH2)
{
	if (hDLL == NULL)
		return FALSE;

	return (*pApci8806GetCH)(wLogSlot, pdwCH1, pdwCH2);
}

/*****************************************************************************/
/* 	  aPCI-8806F/H̃G[R[h										 */
/* 	  wLogSlot	G[foCX								 */
/* ߂l G[R[h														 */
/*****************************************************************************/
DWORD Apci8806wGetLastError(WORD wLogSlot)
{
	if (hDLL == NULL)
		return APCI8806_ERR_WRAPDLL;

	return (*pApci8806GetLastError)(wLogSlot);
}

/*---------------------------------------------------------------------------*/
/* 	  DLLGNX|[g֐AhX̎擾									 */
/* 	  																 */
/* ߂l  TRUE															 */
/*		  s FALSE														 */
/*---------------------------------------------------------------------------*/
static BOOL Apci8806wGetDllExportFunc()
{
	// Apci8806GetVersion ̃AhX擾
	pApci8806GetVersion = GetProcAddress(hDLL, _T("Apci8806GetVersion"));
	if (pApci8806GetVersion == NULL)
		return FALSE;

	// Apci8806Create ̃AhX擾
	pApci8806Create = GetProcAddress(hDLL, _T("Apci8806Create"));
	if (pApci8806Create == NULL)
		return FALSE;

	// Apci8806Close ̃AhX擾
	pApci8806Close = GetProcAddress(hDLL, _T("Apci8806Close"));
	if (pApci8806Close == NULL)
		return FALSE;

	// Apci8806GetResource ̃AhX擾
	pApci8806GetResource = GetProcAddress(hDLL, _T("Apci8806GetResource"));
	if (pApci8806GetResource == NULL)
		return FALSE;

	// Apci8806SetData ̃AhX擾
	pApci8806SetData = GetProcAddress(hDLL, _T("Apci8806SetData"));
	if (pApci8806SetData == NULL)
		return FALSE;

	// Apci8806GetCH ̃AhX擾
	pApci8806GetCH = GetProcAddress(hDLL, _T("Apci8806GetCH"));
	if (pApci8806GetCH == NULL)
		return FALSE;

	// Apci8806GetLastError ̃AhX擾
	pApci8806GetLastError = GetProcAddress(hDLL, _T("Apci8806GetLastError"));
	if (pApci8806GetLastError == NULL)
		return FALSE;

	return TRUE;	// SĂ DLL GNX|[g֐AhX擾
}
