//*****************************************************************************
// apci8806s.c
//
// aPCI-8806F/H
// Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
//
// ̃\[Xɂ̓bp[֐̎gpႪLqĂ܂
//*****************************************************************************

#define	STRICT
#include	<windows.h>
#include	<tchar.h>

#include "apci8806w.h"


const TCHAR szTitle[] = _T("Sample");
const TCHAR sz8806[] = _T("aPCI-8806");

static void ResultMessage(LPCTSTR lpszbuf);
static void ErrorMessage(WORD wLogSlot);


int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	TCHAR szbuf[256];
	DWORD dwDLLVer, dwVxdVer;
	BOOL  bResult;			// 
	WORD  wLogSlot;			// foCXi[
	APCI8806RESOURCE ri;	// \[X
	WORD  i;
	WORD  wDaData;			// D/A݃f[^
	DWORD dwCH1;			// CH1̏
	DWORD dwCH2;			// CH2̏

/*---------------------------------------------------------------------------*/
	// apci8806.dll ̎gp錾
	if (Apci8806wDllOpen() == FALSE)
	{
		ErrorMessage(APCI8806_SLOT_AUTO);
		return 1;			// apci8806.dll ̃[hɎs܂
	}

/*---------------------------------------------------------------------------*/
	// o[Wԍ\
	// aPCI-8806F/H DLL,VxD̃o[Wԍ擾
	if (Apci8806wGetVersion(&dwDLLVer, &dwVxdVer) == FALSE)
	{
		ErrorMessage(APCI8806_SLOT_AUTO);
		return 1;
	}

	wsprintf(szbuf, _T("GetVersion\n")
					_T("DLL Version: %08lxh\n")
					_T("Vxd Version: %08lxh"),
					dwDLLVer,
					dwVxdVer);
	ResultMessage(szbuf);

/*---------------------------------------------------------------------------*/
	// aPCI-8806F/H̎gp錾
	wLogSlot = APCI8806_SLOT_AUTO;		// gp̃foCXT܂B
	// ꍇA̎̃foCXi[܂B
	bResult = Apci8806wCreate(&wLogSlot);

	if (bResult == FALSE)		// foCX܂B
	{
		ErrorMessage(APCI8806_SLOT_AUTO);
		return 1;
	}

	wsprintf(szbuf, _T("aPCI-8806F/H Created\n\n")
					_T("LogSlot: %2d"),
					 wLogSlot);

	ResultMessage(szbuf);

/*---------------------------------------------------------------------------*/
	// \[X擾
	if (Apci8806wGetResource(wLogSlot, &ri) == FALSE)
	{
		ErrorMessage(wLogSlot);
		return 1;
	}

	wsprintf(szbuf, _T("Board Name: %s\n")
					_T("NumPorts: %2d\n")
					_T("IO Address: %04xh-%04xh"),
					sz8806,
					ri.dwIOPortLength[0],
					ri.dwIOPortBase[0], ri.dwIOPortBase[0] + ri.dwIOPortLength[0] - 1);

	ResultMessage(szbuf);

/*---------------------------------------------------------------------------*/
	// o̓f[^̐ݒ
	wDaData = 0x0FFF;

	// gp{[h aPCI-8806H ̏ꍇAŌ 2`lւ̏o͖͂܂B
	for (i = 0; i < APCI8806_MAX_CH_F; i++)
		if (Apci8806wSetData(wLogSlot, i, wDaData) == FALSE)
		{
			ErrorMessage(wLogSlot);
			return 1;
		}

	ResultMessage(_T("o̓f[^ݒ肵܂B"));

/*---------------------------------------------------------------------------*/
	// O͏Ԃ̎擾
	if (Apci8806wGetCH(wLogSlot, &dwCH1, &dwCH2) == FALSE)
	{
		ErrorMessage(wLogSlot);
		return 1;
	}

	wsprintf(szbuf, _T("O͏Ԃ̎擾\n")
					_T("CH1̏=%lxh\n")
					_T("CH2̏=%lxh"),
					dwCH1, dwCH2);

	ResultMessage(szbuf);

/*---------------------------------------------------------------------------*/
	// aPCI-8806F/H̎gpJ
	if (Apci8806wClose(wLogSlot) == FALSE)
	{
		ErrorMessage(wLogSlot);
		return 1;
	}

	ResultMessage(_T("aPCI-8806F/H Closed"));

/*---------------------------------------------------------------------------*/
	// apci8806.dll ̎gpJ
	if (Apci8806wDllClose() == FALSE)
	{
		MessageBox(NULL, _T("DLL ̃A[hɎs܂B"), szTitle, MB_OK | MB_ICONSTOP);
		return 1;			// apci8806.dll ̃A[hɎs܂B
	}

	return 0;
}

// ʂ\
static void ResultMessage(LPCTSTR lpszbuf)
{
	MessageBox(NULL, lpszbuf, szTitle, MB_OK | MB_ICONINFORMATION);
}

// G[bZ[W\
static void ErrorMessage(WORD wLogSlot)
{
	DWORD dwRes = Apci8806wGetLastError(wLogSlot);
	TCHAR szbuf[50];

	switch (dwRes)
	{
		case APCI8806_ERR_WRAPDLL:
			wsprintf(szbuf, _T("DLL Load error"));
			break;

		default:
			wsprintf(szbuf, _T("aPCI-8806F/H error\n\n")
							_T("Error code: %08lxh"),
							dwRes);
			break;
	}

	MessageBox(NULL, szbuf, szTitle, MB_OK | MB_ICONSTOP);
}
