#ifndef _APCI8806_H_
#define _APCI8806_H_

#ifdef __cplusplus
extern "C" {
#endif

#define APCI8806_MAX_CH_F		4
#define APCI8806_MAX_CH_H		2

// őXbg
#define APCI8806_MAX_SLOTS		16

// _Xbgw
#define APCI8806_SLOT_AUTO		((WORD) ~0U)

// \[X\
#define APCI8806_MAX_MEM  9
#define APCI8806_MAX_IO   20
#define APCI8806_MAX_IRQ  7
#define APCI8806_MAX_DMA  7

typedef struct _APCI8806RESOURCE {
    DWORD   dwNumMemWindows;                      // Not used
    DWORD   dwMemBase       [APCI8806_MAX_MEM];   // Not used
    DWORD   dwMemLength     [APCI8806_MAX_MEM];   // Not used
    DWORD   dwMemAttrib     [APCI8806_MAX_MEM];   // Not used
    DWORD   dwNumIOPorts;                         // Num IO ports
    DWORD   dwIOPortBase    [APCI8806_MAX_IO];    // I/O port base
    DWORD   dwIOPortLength  [APCI8806_MAX_IO];    // I/O port length
    DWORD   dwNumIRQs;                            // Not used
    DWORD   dwIRQRegisters  [APCI8806_MAX_IRQ];   // Not used
    DWORD   dwIRQAttrib     [APCI8806_MAX_IRQ];   // Not used
	DWORD	dwNumDMAs;							  // Not used
    DWORD   dwDMALst        [APCI8806_MAX_DMA];   // Not used
    DWORD   dwDMAAttrib     [APCI8806_MAX_DMA];   // Not used
    DWORD   dwReserved1     [3];				  // Not used
} APCI8806RESOURCE, *PAPCI8806R;

// G[R[h
#define APCI8806_SUCCESS                0  // ُȂiIj
#define APCI8806_ERR_SYSTEM             1  // Windows  GetLastError() R[Ă
#define APCI8806_ERR_NO_DEVICE          2  // gp\ȃfoCX܂
#define APCI8806_ERR_IN_USE             3  // w̃foCX͎gpł
#define APCI8806_ERR_INVALID_SLOT       4  // Ș_Xbgł
#define APCI8806_ERR_RESOURCE			5  // \[XG[
#define APCI8806_ERR_INVALID_PORT		6  // sȃ|[gv
#define APCI8806_ERR_INVALID_ARGUMENT   7  // sȈv܂
#define APCI8806_ERR_CHANNEL            10 // `lݒ肪sł
#define APCI8806_ERR_TIMEOUT            11 // f[^o͂Ɏs܂


// hCoƂckk̃o[W擾
BOOL
WINAPI
Apci8806GetVersion(
	PDWORD pdwDllVersion,		// ckk̃o[W
	PDWORD pdwDrvVersion);		// hCõo[W

// foCX̎gp錾
BOOL
WINAPI
Apci8806Create(
	PWORD pwLogSlot );			// _Xbgw

// foCX̊J錾
BOOL
WINAPI
Apci8806Close(
	WORD wLogSlot);				// _Xbgw

// I/O\[X̎擾
BOOL
WINAPI
Apci8806GetResource(
	WORD wLogSlot,				// _Xbgw
	PAPCI8806R pres);			// \[X

// o̓f[^̐ݒ
BOOL
WINAPI
Apci8806SetData(
	WORD wLogSlot,				// _Xbgw
	WORD wChData,				// ݃`l(0`3)
	WORD wDaData );				// D/A݃f[^

// O͏Ԃ̎擾
BOOL
WINAPI
Apci8806GetCH(
	WORD wLogSlot,				// _Xbgw
	PDWORD pdwCH1,				// CH1̏
	PDWORD pdwCH2 );			// CH2̏

// G[R[h̎擾
DWORD
WINAPI
Apci8806GetLastError(
	WORD wLogSlot);				// _Xbgw

#ifdef __cplusplus
}
#endif

#endif
