Attribute VB_Name = "Wrapper"
'*****************************************************************************
'* apci8806w.bas                                                             *
'*                                                                           *
'* aPCI-8806F/H                                                          *
'*                                                                           *
'* Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.                                   *
'*                                                                           *
'*****************************************************************************
Option Explicit
Declare Function LoadLibrary Lib "kernel32" Alias "LoadLibraryA" (ByVal lpLibFileName As String) As Long
Declare Function FreeLibrary Lib "kernel32" (ByVal hLibModule As Long) As Long
Declare Function GetProcAddress Lib "kernel32" (ByVal hModule As Long, ByVal lpProcName As String) As Long

Global Const APCI8806_DLL_NAME = "apci8806.dll" ' DLL

Dim hDLL As Long                'DLLւ̃nh

Global Const APCI8806_MAX_CH_W = 4  ' aISA-A06W̃`l
Global Const APCI8806_MAX_CH_H = 2  ' aISA-A06H̃`l

Global Const APCI8806_ERR_WRAPDLL = -1  ' bp[֐G[

'*****************************************************************************
'*    apci8806.dll[h                                               *
'*                                                                   *
'* ߂l  True                                                          *
'*        s False                                                         *
'*****************************************************************************
Function Apci8806wDllOpen() As Boolean

    Apci8806wDllOpen = False

    If hDLL <> 0 Then Exit Function

    hDLL = LoadLibrary(APCI8806_DLL_NAME)
    If hDLL = 0 Then Exit Function

    If Apci8806wGetDllExportFunc() = False Then
        Apci8806wDllClose     ' DLL GNX|[g֐LmFɎŝŁADLL N[Y
        Exit Function
    End If

    Apci8806wDllOpen = True

End Function

'*****************************************************************************
'*    apci8806.dllA[h                                           *
'*                                                                   *
'* ߂l  True                                                          *
'*        s False                                                         *
'*****************************************************************************
Function Apci8806wDllClose() As Boolean

    Apci8806wDllClose = True

    If hDLL = 0 Then Exit Function

    If FreeLibrary(hDLL) <> 0 Then hDLL = 0 Else Apci8806wDllClose = False

End Function

'*****************************************************************************
'*    aPCI-8806F/H DLL,Vxd̃o[Wԍ擾                            *
'*    pdwDllVersion DLLo[Wԍi[                              *
'*        pdwVxdVersion Vxdo[Wԍi[                              *
'* ߂l  True                                                          *
'*        s False                                                         *
'*****************************************************************************
Function Apci8806wGetVersion(pdwDllVersion As Long, pdwVxdVersion As Long) As Boolean

    Apci8806wGetVersion = False

    If hDLL = 0 Then Exit Function

    If Apci8806GetVersion(pdwDllVersion, pdwVxdVersion) = 0 Then Exit Function

    Apci8806wGetVersion = True

End Function

'*****************************************************************************
'*    aPCI-8806F/H̔Cӂ̃foCX̎gp錾                           *
'*    pwLogSlot gpfoCXi[AhX                       *
'*        hWnd      bZ[W󂯎EBhEnh                   *
'*        uWMBase   bZ[WID̊l                                     *
'*        pvInitArg ̂߂̗\                                         *
'* ߂l  True                                                          *
'*        s False                                                         *
'*****************************************************************************
Function Apci8806wCreate(pwLogSlot As Integer) As Boolean
    
    Apci8806wCreate = False

    If hDLL = 0 Then Exit Function

    If Apci8806Create(pwLogSlot) = 0 Then Exit Function

    Apci8806wCreate = True

End Function

'*****************************************************************************
'*    aPCI-8806F/H̔Cӂ̃foCX̎gpJ                           *
'*    wLogSlot gpfoCX                                          *
'* ߂l  True                                                          *
'*        s False                                                         *
'*****************************************************************************
Function Apci8806wClose(wLogSlot As Integer) As Boolean
    
    Apci8806wClose = False

    If hDLL = 0 Then Exit Function

    If Apci8806Close(wLogSlot) = 0 Then Exit Function

    Apci8806wClose = True

End Function

'*****************************************************************************
'*    wfoCX̃\[X擾                                   *
'*    wLogSlot ׂfoCX                                            *
'*        pResInfo \[Xi[\                              *
'* ߂l  True                                                          *
'*        s False                                                         *
'*****************************************************************************
Function Apci8806wGetResource(wLogSlot As Integer, pResInfo As APCI8806RESOURCE) As Boolean

    Apci8806wGetResource = False

    If hDLL = 0 Then Exit Function

    If Apci8806GetResource(wLogSlot, pResInfo) = 0 Then Exit Function

    Apci8806wGetResource = True

End Function
'*****************************************************************************
'*    o̓f[^̐ݒ                                                   *
'*    wLogSlot _Xbg                                              *
'*        wChData  ݃`l(0 ` 3)                                  *
'*        wDaData  D/A݃f[^                                         *
'* ߂l  True                                                          *
'*        s False                                                         *
'*****************************************************************************
Function Apci8806wSetData(wLogSlot As Integer, wChData As Integer, wDaData As Integer) As Boolean

    Apci8806wSetData = False

    If hDLL = 0 Then Exit Function

    If Apci8806SetData(wLogSlot, wChData, wDaData) = 0 Then Exit Function

    Apci8806wSetData = True

End Function

'*****************************************************************************
'*    O͏Ԃ̎擾                                                 *
'*    wLogSlot _Xbg                                              *
'*        pdwCH1   CH1̏                                                 *
'*        pdwCH2   CH2̏                                                 *
'* ߂l  True                                                          *
'*        s False                                                         *
'*****************************************************************************
Function Apci8806wGetCH(wLogSlot As Integer, pdwCH1 As Long, pdwCH2 As Long) As Boolean

    Apci8806wGetCH = False

    If hDLL = 0 Then Exit Function

    If Apci8806GetCH(wLogSlot, pdwCH1, pdwCH2) = 0 Then Exit Function

    Apci8806wGetCH = True

End Function

'*****************************************************************************
'*    aPCI-8806F/H̃G[R[h                                         *
'*    wLogSlot  G[foCX                                 *
'* ߂l G[R[h                                                       *
'*****************************************************************************
Function Apci8806wGetLastError(wLogSlot As Integer) As Long

    Apci8806wGetLastError = APCI8806_ERR_WRAPDLL

    If hDLL = 0 Then Exit Function

    Apci8806wGetLastError = Apci8806GetLastError(wLogSlot)

End Function

'*---------------------------------------------------------------------------*
'*    DLLGNX|[g֐L̊mF                                      *
'*                                                                   *
'* ߂l  True                                                          *
'*        s False                                                         *
'*---------------------------------------------------------------------------*
Private Function Apci8806wGetDllExportFunc() As Boolean

    Dim pFunc As Long

    Apci8806wGetDllExportFunc = False

    ' Apci8806GetVersion ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Apci8806GetVersion")
    If pFunc = 0 Then Exit Function

    ' Apci8806Create ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Apci8806Create")
    If pFunc = 0 Then Exit Function

    ' Apci8806Close ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Apci8806Close")
    If pFunc = 0 Then Exit Function

    ' Apci8806GetResource ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Apci8806GetResource")
    If pFunc = 0 Then Exit Function

    ' Apci8806SetData ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Apci8806SetData")
    If pFunc = 0 Then Exit Function

    ' Apci8806GetCH ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Apci8806GetCH")
    If pFunc = 0 Then Exit Function

    ' Apci8806GetLastError ̃AhX擾
    pFunc = GetProcAddress(hDLL, "Apci8806GetLastError")
    If pFunc = 0 Then Exit Function

    Apci8806wGetDllExportFunc = True  ' SĂ DLL GNX|[g֐݂̑mF

End Function

