Attribute VB_Name = "Sample"
'*****************************************************************************
'* apci8806s.bas                                                             *
'*                                                                           *
'* aPCI-8806F/H                                                          *
'*                                                                           *
'* Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.                                   *
'*                                                                           *
'*  ̃\[Xɂ̓bp[֐̎gpႪLqĂ܂B                   *
'*                                                                           *
'*****************************************************************************
Option Explicit

Private Const sz8806 = "aPCI-8806"

Public Sub Main()

    Dim strbuf As String
    Dim dwDllVer As Long, dwDrvVer As Long
    Dim bResult As Boolean          ' 
    Dim wLogSlot As Integer         ' foCXi[
    Dim ri As APCI8806RESOURCE      ' \[X
    Dim i As Integer
    Dim wDaData As Integer          ' D/A݃f[^
    Dim dwCH1 As Long               ' CH1̏
    Dim dwCH2 As Long               ' CH2̏

'---------------------------------------------------------------------------
    ' apci8806.dll ̎gp錾
    If Apci8806wDllOpen() = False Then
        ErrorMessage (APCI8806_SLOT_AUTO)
        Exit Sub                ' apci8806.dll ̃[hɎs܂
    End If

'---------------------------------------------------------------------------
    ' o[Wԍ\
    If Apci8806wGetVersion(dwDllVer, dwDrvVer) = False Then ' aPCI-8806F/HDLL,Drṽo[Wԍ擾
        ErrorMessage (APCI8806_SLOT_AUTO)
        Exit Sub
    End If

    strbuf = "GetVersion" + Chr(10) + _
             "DLL Version: &H" + Hex(dwDllVer) + Chr(10) + _
             "DRV Version: &H" + Hex(dwDrvVer)
    ResultMessage (strbuf)

'---------------------------------------------------------------------------
    ' aPCI-8806F/H̎gp錾
    wLogSlot = APCI8806_SLOT_AUTO       ' gp̃foCXT܂B
    ' ŏ̈͐ꍇA̎̃foCXi[܂B
    bResult = Apci8806wCreate(wLogSlot)

    If bResult = False Then           ' foCX܂B
        ErrorMessage (APCI8806_SLOT_AUTO)
        Exit Sub
    End If

    strbuf = "aPCI-8806F/H Created" + Chr(10) + Chr(10) + _
          "LogSlot: " + Str(wLogSlot)

    ResultMessage (strbuf)

'---------------------------------------------------------------------------
    ' \[X擾
    If Apci8806wGetResource(wLogSlot, ri) = False Then
        ErrorMessage (wLogSlot)
        Exit Sub
    End If

    strbuf = "Board Name: " + sz8806 + Chr(10) + _
             "NumPorts: " + Str(ri.dwIOPortLength(1)) + Chr(10) + _
             "IO Address: &H" + Hex(ri.dwIOPortBase(1)) + _
             "-&H" + Hex(ri.dwIOPortBase(1) + ri.dwIOPortLength(1) - 1)

    ResultMessage (strbuf)

'---------------------------------------------------------------------------
    ' o̓f[^̐ݒ
    wDaData = &HFFF
    
    ' gp{[h aPCI-8806H ̏ꍇAŌ 2`lւ̏o͖͂܂B
    For i = 0 To APCI8806_MAX_CH_W - 1
        If Apci8806wSetData(wLogSlot, i, wDaData) = False Then
            ErrorMessage (wLogSlot)
            Exit Sub
        End If
    Next i

    ResultMessage ("o̓f[^ݒ肵܂B")

'---------------------------------------------------------------------------
    ' O͏Ԃ̎擾
    If Apci8806wGetCH(wLogSlot, dwCH1, dwCH2) = False Then
        ErrorMessage (wLogSlot)
        Exit Sub
    End If

    strbuf = "O͏Ԃ̎擾" + Chr(10) + _
             "CH1̏=&H" + Hex(dwCH1) + Chr(10) + _
             "CH2̏=&H" + Hex(dwCH2)

    ResultMessage (strbuf)

'---------------------------------------------------------------------------
    ' aPCI-8806F/H̎gpJ
    If Apci8806wClose(wLogSlot) = False Then
        ErrorMessage (wLogSlot)
        Exit Sub
    End If

    ResultMessage ("aPCI-8806F/H Closed")

'---------------------------------------------------------------------------
    ' aPCI-8806F/H ̎gpJ
    If Apci8806wDllClose() = False Then
        MsgBox "DLL ̃A[hɎs܂B", vbOKOnly + vbCritical
        Exit Sub        ' apci8806.dll ̃A[hɎs܂B
    End If

End Sub

' ʂ\
Private Sub ResultMessage(lpszbuf As String)

    MsgBox lpszbuf, vbOKOnly + vbInformation

End Sub


' G[bZ[W\
Private Sub ErrorMessage(wLogSlot As Integer)

    Dim dwRes As Long
    Dim szbuf As String

    dwRes = Apci8806wGetLastError(wLogSlot)

    Select Case dwRes
    Case APCI8806_ERR_WRAPDLL
        szbuf = "DLL Load error"

    Case Else                           ' ̑̒l̏ꍇB
        szbuf = "aPCI-8806F/H error" + Chr(10) + Chr(10) + _
                "Error code: &H" + _
                Hex(dwRes)
    End Select

    MsgBox szbuf, vbOKOnly + vbCritical

End Sub


