//****************************************************************************
//	apci8806w.pas
//
//	aPCI8806F/H
//
//	Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
//
//****************************************************************************

unit apci8806w;

interface

uses
	Windows;

const
{ őXbg }
	APCI8806_MAX_SLOTS = 16;

{ _Xbgw }
	APCI8806_SLOT_AUTO = $ffff;

{ G[R[h̒` }
	APCI8806_SUCCESS                =0;  { ُȂiIj }
	APCI8806_ERR_SYSTEM             =1;  { Windows  GetLastError() R[Ă }
	APCI8806_ERR_NO_DEVICE          =2;  { gp\ȃfoCX܂ }
	APCI8806_ERR_IN_USE             =3;  { w̃foCX͎gpł }
	APCI8806_ERR_INVALID_SLOT       =4;  { Ș_Xbgł }
	APCI8806_ERR_RESOURCE						=5;  { \[XG[ }
	APCI8806_ERR_INVALID_PORT				=6;  { sȃ|[gv }
	APCI8806_ERR_INVALID_ARGUMENT   =7;  { sȈv܂ }
	APCI8806_ERR_CHANNEL            =10; { `lݒ肪sł }
	APCI8806_ERR_TIMEOUT            =11; { f[^o͂Ɏs܂B }

{ I/O\[XzE }
	APCI8806_MAX_MEM =	9;	{ MAX_MEM_REGISTERS }
	APCI8806_MAX_IO	= 20; { MAX_IO_PORTS }
	APCI8806_MAX_IRQ	= 7;	{ MAX_IRQS }
	APCI8806_MAX_DMA	= 7;	{ MAX_DMA_CHANNELS }

{ ***** I/O\[X\ ***** }
{ YfoCXgpI/O\[XAvP[V󂯎邽߂̍\́B}
type
	TAPCI8806RESOURCE = record
		dwNumMemWindows:DWORD;															{ EBhE gp }
		dwMemBase:			array	[1 .. APCI8806_MAX_MEM]of DWORD;	{ EChEx[XAhX@gp }
		dwMemLength:		array	[1 .. APCI8806_MAX_MEM]of DWORD;	{ EChE@gp }
		dwMemAttrib:		array	[1 .. APCI8806_MAX_MEM]of DWORD;	{ EChE@gp }
		dwNumIOPorts:DWORD;           		          				    { I/O|[g }
		dwIOPortBase:		array	[1 .. APCI8806_MAX_IO]of DWORD;		{ I/O|[gx[XAhX }
		dwIOPortLength:	array	[1 .. APCI8806_MAX_IO]of DWORD;		{ I/O|[g }
		dwNumIRQs:DWORD;     					        				          { IRQ@gp }
		dwIRQRegisters:	array	[1 .. APCI8806_MAX_IRQ]of DWORD;	{ IRQXg gp }
		dwIRQAttrib:		array	[1 .. APCI8806_MAX_IRQ]of DWORD;	{ IRQXg gp }
		umDMAs:DWORD;											  										{ DMA`l gp }
		dwDMALst:				array	[1 .. APCI8806_MAX_DMA]of DWORD;	{ DMA`lXg gp }
		dwDMAAttrib:		array	[1 .. APCI8806_MAX_DMA]of DWORD;	{ DMA`lXg gp }
		dwReserved1:		array	[1 .. 3]of DWORD;									{ \  }
	end;

PAPCI8806RESOURCE = ^TAPCI8806RESOURCE;

const
	APCI8806_MAX_CH_F = 4;														{ aPCI8806F̃`l }
	APCI8806_MAX_CH_H = 2;														{ aPCI8806H̃`l }

const
	APCI8806_ERR_WRAPDLL = DWord(-1); 								{ bp[֐G[ }

const
	APCI8806_DLL_NAME = 'apci8806.dll';								{ DLL }

function Apci8806wDllOpen: Boolean;										{ DLL [h }
function Apci8806wDllClose: Boolean;									{ DLL A[h }

{ aPCI8806F/H DLL,hCõo[Wԍ擾 }
function Apci8806wGetVersion(var pdwDllVersion: DWord; var pdwDrvVersion: DWord): Boolean;

{ CӂaPCI8806F/H̎gp錾 }
function Apci8806wCreate(var pwLogSlot: Word): Boolean;

{ CӂaPCI8806F/H̎gpJ }
function Apci8806wClose(wLogSlot: Word): Boolean;

{ \[X擾 }
function Apci8806wGetResource(wLogSlot: Word; pResInfo: PAPCI8806RESOURCE): Boolean;

{ o̓f[^̐ݒ }
function Apci8806wSetData(wLogSlot: Word; wChData: Word; wDaData: Word): Boolean;

{ O͏Ԃ̎擾 }
function Apci8806wGetCH(wLogSlot: Word; var pdwCH1: DWord; var pdwCH2: DWord): Boolean;

{ APCI8806F/H̃G[擾 }
function Apci8806wGetLastError(wLogSlot: Word): DWord;

implementation

type
	TApci8806Create = function(var pwLogSlot): Bool; stdcall;
	TApci8806Close = function(wLogSlot: Word): Bool; stdcall;
	TApci8806GetVersion = function(var pdwDllVer: DWord; var pdwDrvVer: DWord): Bool; stdcall;
	TApci8806GetResource = function(wLogSlot: Word; pres: PAPCI8806RESOURCE): Bool; stdcall;
	TApci8806SetData = function(wLogSlot: Word; wChData: Word; wDaData: Word): Bool; stdcall;
	TApci8806GetLastError = function(wLogSlot: Word): DWord; stdcall;
	TApci8806GetCH = function(wLogSlot: Word; var	pdwCH1: DWord; var pdwCH2: DWord): Bool; stdcall;

function Apci8806wGetDllExportFunc: Boolean; forward;

{$J+}
const
	hDLL: THandle = 0;
{$J-}

{ DLL GNX|[g֐AhX̊i[ϐ }
var
	pApci8806GetVersion:		TApci8806GetVersion;
	pApci8806Create:				TApci8806Create;
	pApci8806Close:					TApci8806Close;
	pApci8806GetResource:		TApci8806GetResource;
	pApci8806SetData:				TApci8806SetData;
	pApci8806GetCH:					TApci8806GetCH;
	pApci8806GetLastError:	TApci8806GetLastError;


//****************************************************************************
// 		apci8806.dll[h
// 		
// ߂l  True
//				s False
//****************************************************************************
function Apci8806wDllOpen: Boolean;
begin
	Result := False;

	if hDLL <> 0 then Exit;

	hDLL := LoadLibrary(APCI8806_DLL_NAME);
	if hDLL = 0 then Exit;

	if Apci8806wGetDllExportFunc = False then
  begin
		Apci8806wDllClose;	// DLL GNX|[g֐擾ɎŝŁADLL N[Y
		Exit;
	end;

	Result := True;
end;

//****************************************************************************
// 		apci8806.dllA[h
// 		
// ߂l  True
//				s False
//****************************************************************************
function Apci8806wDllClose: Boolean;
begin
	Result := True;

	if hDLL = 0 then Exit;

	if FreeLibrary(hDLL) = True then hDLL := 0
	else Result := False;
end;

//****************************************************************************
// 		aPCI8806F/H DLL,Vxd̃o[Wԍ擾
// 		pdwDllVersion DLLo[Wԍi[
//				pdwDrvVersion Drvo[Wԍi[
// ߂l  True
//				s False
//****************************************************************************
function Apci8806wGetVersion(var pdwDllVersion: DWord; var pdwDrvVersion: DWord): Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result := pApci8806GetVersion(pdwDllVersion, pdwDrvVersion);
end;

//****************************************************************************
// 		aPCI8806F/H̔Cӂ̃foCX̎gp錾
// 		pwLogSlot	 gpfoCXi[AhX
// ߂l  True
//				s False
//****************************************************************************
function Apci8806wCreate(var pwLogSlot:Word): Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result := pApci8806Create(pwLogSlot);
end;

//****************************************************************************
// 		APCI8806F/H̔Cӂ̃foCX̎gpJ
// 		wLogSlot gpfoCX
// ߂l  True
//				s False
//****************************************************************************
function Apci8806wClose(wLogSlot: Word): Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result := pApci8806Close(wLogSlot);
end;

//****************************************************************************
// 		wfoCX̃\[X擾
// 		wLogSlot ׂfoCX
//				pResInfo \[Xi[\̂̃AhX
// ߂l  True
//				s False
//****************************************************************************
function Apci8806wGetResource(wLogSlot: Word; pResInfo: PAPCI8806RESOURCE): Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result := pApci8806GetResource(wLogSlot, pResInfo);
end;

//****************************************************************************
// 	  o̓f[^̐ݒ
// 	  wLogSlot _Xbg
//		  	wChData  ݃`l(0 ` 3)
//		  	wDaData  D/A݃f[^
// ߂l  True
//		  	s False
//****************************************************************************
function Apci8806wSetData(wLogSlot: Word; wChData: Word; wDaData: Word): Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result := pApci8806SetData(wLogSlot, wChData, wDaData);
end;

//****************************************************************************
// 	  O͏Ԃ̎擾
// 	  wLogSlot _Xbg
//		  	pdwCH1   CH1̏
//		  	pdwCH2   CH2̏
// ߂l  True
//		  	s False
//****************************************************************************
function Apci8806wGetCH(wLogSlot: Word; var pdwCH1: DWord; var pdwCH2: DWord): Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result := pApci8806GetCH(wLogSlot, pdwCH1, pdwCH2);
end;

//****************************************************************************
// 		APCI8806F/H̃G[R[h
// 		wLogSlot	G[foCX
// ߂l G[R[h
//****************************************************************************
function Apci8806wGetLastError(wLogSlot: Word): DWord;
begin
	Result := APCI8806_ERR_WRAPDLL;
	if hDLL = 0 then Exit;
	Result := pApci8806GetLastError(wLogSlot);
end;

//---------------------------------------------------------------------------
// 	  DLLGNX|[g֐AhX̎擾
// 	  
// ߂l  True
//		  	s False
//---------------------------------------------------------------------------
function Apci8806wGetDllExportFunc: Boolean;
begin
	Result := False;

	// Apci8806GetVersion ̃AhX擾
	pApci8806GetVersion := GetProcAddress(hDLL, 'Apci8806GetVersion');
	if @pApci8806GetVersion = nil then Exit;

	// Apci8806Create ̃AhX擾
	pApci8806Create := GetProcAddress(hDLL, 'Apci8806Create');
	if @pApci8806Create = nil then Exit;

	// Apci8806Close ̃AhX擾
	pApci8806Close := GetProcAddress(hDLL, 'Apci8806Close');
	if @pApci8806Close = nil then Exit;

	// Apci8806GetResource ̃AhX擾
	pApci8806GetResource := GetProcAddress(hDLL, 'Apci8806GetResource');
	if @pApci8806GetResource = nil then Exit;

	// Apci8806SetData ̃AhX擾
	pApci8806SetData := GetProcAddress(hDLL, 'Apci8806SetData');
	if @pApci8806SetData = nil then Exit;

  // Apci8806GetCH ̃AhX擾
	pApci8806GetCH := GetProcAddress(hDLL, 'Apci8806GetCH');
	if @pApci8806GetCH = nil then Exit;

	// Apci8806GetLastError ̃AhX擾
	pApci8806GetLastError := GetProcAddress(hDLL, 'Apci8806GetLastError');
	if @pApci8806GetLastError = nil then Exit;

	Result := True;	// SĂ DLL GNX|[g֐AhX擾
end;

end.

