//===================================================================
// Apci8304w.c - wrapper for C/C++
//-------------------------------------------------------------------
// Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
//===================================================================
#include <windows.h>
#include <tchar.h>

#include "Apci8304w.h"

static BOOL	   _Apci8304wGetDllExportFunc( void );
static HMODULE hDLL = NULL;

static FARPROC pApci8304GetVersion;
static FARPROC pApci8304Create;
static FARPROC pApci8304Close;
static FARPROC pApci8304GetResource;
static FARPROC pApci8304GetSwitchValue;
static FARPROC pApci8304GetLastError;
static FARPROC pApci8304SioStart;
static FARPROC pApci8304SioGetStatus;
static FARPROC pApci8304SioRead;
static FARPROC pApci8304SioWrite;
static FARPROC pApci8304SioReset;
static FARPROC pApci8304SioStop;

//===================================================================
//   		DLL [h
//   		Ȃ
// ߂l		TRUE	
//				FALSE	s
//===================================================================
BOOL Apci8304wDllOpen( void )
{
	if ( hDLL != NULL ) return FALSE;
	hDLL = (HMODULE)LoadLibrary(APCI8304_DLL_NAME);
	if ( hDLL == NULL ) return FALSE;
	if ( _Apci8304wGetDllExportFunc() == FALSE ) {
		Apci8304wDllClose();
		return FALSE;
	}
	return TRUE;
}
//===================================================================
//   		DLL A[h
//   		Ȃ
// ߂l		TRUE	
//				FALSE	s
//===================================================================
BOOL Apci8304wDllClose( void )
{
	if ( hDLL == NULL ) return FALSE;
	if ( FreeLibrary(hDLL) == TRUE ) {
		hDLL = NULL;
		return TRUE;
	}
	return FALSE;
}
//===================================================================
//   		DLL,Driver ̃o[W擾
//   		pdwDllVer			DLL o[Wԍi[̈
//				pdwDrvVer			DRV o[Wԍi[̈
// ߂l		 TRUE
//				s FALSE
//===================================================================
BOOL Apci8304wGetVersion( PDWORD pdwDllVer, PDWORD pdwDrvVer )
{
	if ( hDLL == NULL ) return APCI8304_ERR_WRAPDLL;
	return (*pApci8304GetVersion)(pdwDllVer, pdwDrvVer);
}
//===================================================================
//   		foCXgp錾
//   		pwLogSlot				gpfoCXԍi[̈
// ߂l		 TRUE
//				s FALSE
//===================================================================
BOOL Apci8304wCreate( PWORD pwLogSlot )
{
	if ( hDLL == NULL ) return FALSE;
	return (*pApci8304Create)(pwLogSlot);
}
//===================================================================
//   		foCXJ
//   		wLogSlot				foCX̘_Xbgԍ
// ߂l		 TRUE
//				s FALSE
//===================================================================
BOOL Apci8304wClose( WORD wLogSlot )
{
	if ( hDLL == NULL ) return FALSE;
	return (*pApci8304Close)(wLogSlot);
}
//===================================================================
//   		\[X擾
//   		wLogSlot				foCX̘_Xbgԍ
//				pRes					\[Xi[̈
// ߂l		 TRUE
//				s FALSE
//===================================================================
BOOL Apci8304wGetResource( WORD wLogSlot, PAPCI8304R pRes )
{
	if ( hDLL == NULL ) return FALSE;
	return (*pApci8304GetResource)(wLogSlot,pRes);
}
//===================================================================
//   		arml擾
//   		wLogSlot				foCX̘_Xbgԍ
//				pdwSwitchValue			armli[̈
// ߂l		 TRUE
//				s FALSE
//===================================================================
BOOL Apci8304wGetSwitchValue( WORD wLogSlot, PDWORD pdwSwitchValue )
{
	if ( hDLL == NULL ) return FALSE;
	return (*pApci8304GetSwitchValue)(wLogSlot,pdwSwitchValue);
}
//===================================================================
//   		G[擾
//   		wLogSlot				foCX̘_Xbgԍ
// ߂l		G[
//===================================================================
DWORD Apci8304wGetLastError( WORD wLogSlot )
{
	if ( hDLL == NULL ) return APCI8304_ERR_WRAPDLL;
	return (*pApci8304GetLastError)(wLogSlot);
}
//===================================================================
//   		VAʐMJn
//   		wLogSlot				foCX̘_Xbgԍ
//				wCh						gp`l
//				pMode					샂[hi[Ă̈
// ߂l		 TRUE
//				s FALSE
//===================================================================
BOOL Apci8304wSioStart( WORD wLogSlot, WORD wCh, PSIOMODE pMode )
{
	if ( hDLL == NULL ) return FALSE;
	return (*pApci8304SioStart)(wLogSlot,wCh,pMode);
}
//===================================================================
//   		ʐMXe[^X擾
//   		wLogSlot				foCX̘_Xbgԍ
//				wCh						gp`l
//				pStatus					Xe[^Xi[̈
// ߂l		 TRUE
//				s FALSE
//===================================================================
BOOL Apci8304wSioGetStatus( WORD wLogSlot, WORD wCh, PSIOSTATUS pStatus )
{
	if ( hDLL == NULL ) return FALSE;
	return (*pApci8304SioGetStatus)(wLogSlot,wCh,pStatus);
}
//===================================================================
//   		f[^M
//   		wLogSlot				foCX̘_Xbgԍ
//				wCh						gp`l
//				pbData					Mf[^ۑ̈
//				dwDataSize				Mf[^
// ߂l		 TRUE
//				s FALSE
//===================================================================
BOOL Apci8304wSioRead( WORD wLogSlot, WORD wCh, PBYTE pbData, DWORD dwDataSize )
{
	if ( hDLL == NULL ) return FALSE;
	return (*pApci8304SioRead)(wLogSlot,wCh,pbData,dwDataSize);
}
//===================================================================
//   		f[^M
//   		wLogSlot				foCX̘_Xbgԍ
//				wCh						gp`l
//				pbData					Mf[^̈
//				dwDataSize				Mf[^
// ߂l		 TRUE
//				s FALSE
//===================================================================
BOOL Apci8304wSioWrite( WORD wLogSlot, WORD wCh, PBYTE pbData, DWORD dwDataSize )
{
	if ( hDLL == NULL ) return FALSE;
	return (*pApci8304SioWrite)(wLogSlot,wCh,pbData,dwDataSize);
}
//===================================================================
//   		obt@̃Zbg
//   		wLogSlot				foCX̘_Xbgԍ
//				wCh						gp`l
// ߂l		 TRUE
//				s FALSE
//===================================================================
BOOL Apci8304wSioReset( WORD wLogSlot, WORD wCh )
{
	if ( hDLL == NULL ) return FALSE;
	return (*pApci8304SioReset)(wLogSlot,wCh);
}
//===================================================================
//   		VAʐM~
//   		wLogSlot				foCX̘_Xbgԍ
//				wCh						gp`l
// ߂l		 TRUE
//				s FALSE
//===================================================================
BOOL Apci8304wSioStop( WORD wLogSlot, WORD wCh )
{
	if ( hDLL == NULL ) return FALSE;
	return (*pApci8304SioStop)(wLogSlot,wCh);
}
//-------------------------------------------------------------------
// 			DLL߰Ċ֐ڽ̎擾
// 			
// ߂l		 TRUE
//				s FALSE
//-------------------------------------------------------------------
static BOOL _Apci8304wGetDllExportFunc( void )
{
	pApci8304GetVersion		= GetProcAddress(hDLL, _T("Apci8304GetVersion"));
	pApci8304Create			= GetProcAddress(hDLL, _T("Apci8304Create"));
	pApci8304Close			= GetProcAddress(hDLL, _T("Apci8304Close"));
	pApci8304GetResource	= GetProcAddress(hDLL, _T("Apci8304GetResource"));
	pApci8304GetSwitchValue	= GetProcAddress(hDLL, _T("Apci8304GetSwitchValue"));
	pApci8304GetLastError	= GetProcAddress(hDLL, _T("Apci8304GetLastError"));
	pApci8304SioStart		= GetProcAddress(hDLL, _T("Apci8304SioStart"));
	pApci8304SioGetStatus	= GetProcAddress(hDLL, _T("Apci8304SioGetStatus"));
	pApci8304SioRead		= GetProcAddress(hDLL, _T("Apci8304SioRead"));
	pApci8304SioWrite		= GetProcAddress(hDLL, _T("Apci8304SioWrite"));
	pApci8304SioReset		= GetProcAddress(hDLL, _T("Apci8304SioReset"));
	pApci8304SioStop		= GetProcAddress(hDLL, _T("Apci8304SioStop"));

	if ( pApci8304GetVersion == NULL )		return FALSE;
	if ( pApci8304Create == NULL )			return FALSE;
	if ( pApci8304Close == NULL )			return FALSE;
	if ( pApci8304GetResource == NULL )		return FALSE;
	if ( pApci8304GetSwitchValue == NULL )	return FALSE;
	if ( pApci8304GetLastError == NULL )	return FALSE;
	if ( pApci8304SioStart == NULL )		return FALSE;
	if ( pApci8304SioGetStatus == NULL )	return FALSE;
	if ( pApci8304SioRead == NULL )			return FALSE;
	if ( pApci8304SioWrite == NULL )		return FALSE;
	if ( pApci8304SioReset == NULL )		return FALSE;
	if ( pApci8304SioStop == NULL )			return FALSE;

	return TRUE;
}