//===================================================================
// Apci8304s.c
//-------------------------------------------------------------------
// ̃\[Xɂ̓bp[֐̎gpႪLqĂ܂
//
// Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
//===================================================================
#define	STRICT
#include <windows.h>
#include <tchar.h>
#include "Apci8304w.h"

#define BUFSIZE 512

static void ResultMessage(LPCTSTR lpszbuf);
static void ErrorMessage(WORD wLogSlot);
//===================================================================
// C
//===================================================================
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
										LPSTR lpCmdLine, int nCmdShow)
{
	TCHAR				szbuf[1024];
	DWORD				dwDLLVer, dwDrvVer;
	WORD				wLogSlot;
	APCI8304_RESOURCE	Res;
	DWORD				dwSwitch;
	SIOMODE				Mode;
	SIOSTATUS			Status;
	BYTE				Buff[BUFSIZE];		// Mobt@

	//---------------------------------------------------------------
	// DLL̎gp錾
	//---------------------------------------------------------------
	if ( Apci8304wDllOpen() == FALSE ) {
		ErrorMessage(APCI8304_SLOT_AUTO);
		return 1;
	}
	ResultMessage("DLL[h܂B");
	//---------------------------------------------------------------
	// o[Wԍ擾
	//---------------------------------------------------------------
	if ( Apci8304wGetVersion(&dwDLLVer, &dwDrvVer) == FALSE ) {
		ErrorMessage(APCI8304_SLOT_AUTO);
		return 1;
	}
	wsprintf(szbuf, _T("o[Wԍ擾\n")
					_T("DLL Version : %08lxh\n")
					_T("Drv Version : %08lxh"), dwDLLVer, dwDrvVer );
	ResultMessage(szbuf);
	//---------------------------------------------------------------
	// foCX̎gp錾
	//---------------------------------------------------------------
	wLogSlot = APCI8304_SLOT_AUTO;
	if ( Apci8304wCreate( &wLogSlot ) == FALSE ) {
		ErrorMessage(APCI8304_SLOT_AUTO);
		return 1;
	}
	wsprintf(szbuf, _T("foCX̎gp錾\n\n")
					_T("LogSlot : %2d"), wLogSlot);
	ResultMessage(szbuf);
	//---------------------------------------------------------------
	// \[X擾
	//---------------------------------------------------------------
	if ( Apci8304wGetResource( wLogSlot, &Res ) == FALSE ) {
		ErrorMessage(wLogSlot);
		return 1;
	}
	wsprintf(szbuf, _T("\[X擾\n")
					_T("NumPorts : %d\n")
					_T("IO Address[0] : %04xH - %04xH\n")
					_T("IO Address[1] : %04xH - %04xH\n")
					_T("IRQ : %d") ,
					Res.dwNumIOPorts,
					Res.dwIOPortBase[0],Res.dwIOPortBase[0]+Res.dwIOPortLength[0]-1,
					Res.dwIOPortBase[1],Res.dwIOPortBase[1]+Res.dwIOPortLength[1]-1,
					Res.dwIRQRegisters[0] );
	ResultMessage(szbuf);
	//---------------------------------------------------------------
	// arml擾
	//---------------------------------------------------------------
	if ( Apci8304wGetSwitchValue( wLogSlot, &dwSwitch ) == FALSE ) {
		ErrorMessage(wLogSlot);
		return 1;
	}
	wsprintf(szbuf,	_T("BSN : %xh"), dwSwitch );
	ResultMessage(szbuf);
	//---------------------------------------------------------------
	// VAʐMJni`lPj
	//---------------------------------------------------------------
	Mode.Baud		= APCI8304_SIO_BPS115200;		// 115200bps
	Mode.WordSize	= APCI8304_SIO_CB8;				// LN^ 8bit
	Mode.Parity		= APCI8304_SIO_PNONE;			// peB
	Mode.StopBits	= APCI8304_SIO_S1;				// Xgbvrbg 1bit

	if ( Apci8304wSioStart(wLogSlot,APCI8304_SIO_CH1,&Mode) == FALSE ) {
		ErrorMessage(wLogSlot);
		return 1;
	}
	wsprintf( szbuf,
		_T("ȉ̏ŒʐMJn܂\n")
		_T("`l : 1\n")
		_T("ʐMx : 115200bps\n")
		_T("LN^ : 8bit\n")
		_T("peB : \n")
		_T("Xgbvrbg : 1bit\n"));
	ResultMessage(szbuf);
	//---------------------------------------------------------------
	// ʐMobt@Zbg
	//---------------------------------------------------------------
	if ( Apci8304wSioReset(wLogSlot,APCI8304_SIO_CH1) == FALSE ) {
		ErrorMessage(wLogSlot);
		return 1;
	}
	ResultMessage("ʐMobt@Zbg܂");
	//---------------------------------------------------------------
	// f[^M
	//---------------------------------------------------------------
	wsprintf( Buff, "ABCDEFG1234567" );
	if ( Apci8304wSioWrite(wLogSlot,APCI8304_SIO_CH1,Buff,strlen(Buff)) == FALSE ) {
		ErrorMessage(wLogSlot);
		return 1;
	}
	wsprintf( szbuf,
		_T("f[^[%s](%dbyte)\n")
		_T("𑗐M܂\n"), Buff, strlen(Buff));
	ResultMessage(szbuf);
	//---------------------------------------------------------------
	// ʐMXe[^X擾
	//---------------------------------------------------------------
	if ( Apci8304wSioGetStatus(wLogSlot,APCI8304_SIO_CH1,&Status) == FALSE ) {
		ErrorMessage(wLogSlot);
		return 1;
	}
	wsprintf( szbuf,
		_T("ʐMXe[^X擾܂\n")
		_T("Mf[^ : %dbyte\n"), Status.RxSize );
	ResultMessage(szbuf);
	//---------------------------------------------------------------
	// Mf[^ꍇMs
	//---------------------------------------------------------------
	if ( Status.RxSize != 0 ) {
		if ( BUFSIZE < Status.RxSize ) Status.RxSize = BUFSIZE; 
		if ( Apci8304wSioRead(wLogSlot,APCI8304_SIO_CH1,Buff,Status.RxSize)==FALSE) {
			ErrorMessage(wLogSlot);
			return 1;
		}
		Buff[Status.RxSize] = 0x00;
		wsprintf( szbuf,
			_T("f[^ %dbyteM܂\n")
			_T("Mf[^ : \n%s"),
			Status.RxSize, Buff );
		ResultMessage(szbuf);
	}
	//---------------------------------------------------------------
	// ʐMI
	//---------------------------------------------------------------
	if ( Apci8304wSioStop(wLogSlot,APCI8304_SIO_CH1) == FALSE ) {
		ErrorMessage(wLogSlot);
		return 1;
	}
	ResultMessage("ʐM~܂");
	//---------------------------------------------------------------
	// foCX̎gpI
	//---------------------------------------------------------------
	if ( Apci8304wClose(wLogSlot) == FALSE ) {
		ErrorMessage(APCI8304_SLOT_AUTO);
		return 1;
	}
	wsprintf(szbuf, _T("foCX̎gpI\n\n")
					_T("LogSlot : %2d") ,
					wLogSlot);
	ResultMessage(szbuf);
	//---------------------------------------------------------------
	// DLL̃A[h
	//---------------------------------------------------------------
  	Apci8304wDllClose();

	return 0;
}
//-------------------------------------------------------------------
// ʂ\
//-------------------------------------------------------------------
static void	ResultMessage(LPCTSTR lpszbuf)
{
	MessageBox(NULL, lpszbuf, "aPCI-8304", MB_OK | MB_ICONINFORMATION);
}
//-------------------------------------------------------------------
// G[bZ[W\ďI
//-------------------------------------------------------------------
static void	ErrorMessage(WORD wLogSlot)
{
	DWORD 	dwRes = Apci8304wGetLastError(wLogSlot);
	TCHAR	szbuf[50];

	switch(dwRes) {
		case APCI8304_ERR_SYSTEM:
			wsprintf(szbuf, _T("System error\n\n")
							_T("Error code : %08lxH") , GetLastError());
			break;

		case APCI8304_ERR_WRAPDLL:
			wsprintf(szbuf, _T("DLL Load error"));
			break;

		default:
			wsprintf(szbuf, _T("aPCI-8304 error\n\n")
							_T("Error code : %08lxH") , dwRes);
			break;
	}
	MessageBox(NULL, szbuf, "aPCI-8304", MB_OK | MB_ICONSTOP);
	// I
	Apci8304wClose(wLogSlot);
  	Apci8304wDllClose();
}

