//===================================================================
// Apci8304.h - user application interface
//-------------------------------------------------------------------
// Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
//===================================================================

#define APCI8304_SLOT_AUTO			((WORD) ~0U)
#define APCI8304_MAX_SLOTS			16
#define APCI8304_MAX_CH				4

//-------------------------------------------------------------------
// \[X\
//-------------------------------------------------------------------
#define APCI8304_MAX_MEM			9
#define APCI8304_MAX_IO				20
#define APCI8304_MAX_IRQ			7
#define APCI8304_MAX_DMA			7

typedef struct _APCI8304_RESOURCE {
    DWORD   dwNumMemWindows;							// Not used
    DWORD   dwMemBase				[APCI8304_MAX_MEM];	// Not used
    DWORD   dwMemLength				[APCI8304_MAX_MEM];	// Not used
    DWORD   dwMemAttrib				[APCI8304_MAX_MEM];	// Not used
    DWORD   dwNumIOPorts;								// Num IO ports
    DWORD   dwIOPortBase			[APCI8304_MAX_IO];	// I/O port base
    DWORD   dwIOPortLength			[APCI8304_MAX_IO];	// I/O port length
    DWORD   dwNumIRQs;									// NumIRQs
    DWORD   dwIRQRegisters			[APCI8304_MAX_IRQ];	// IRQ Registers
    DWORD   dwIRQAttrib				[APCI8304_MAX_IRQ];	// IRQ Attrib
	DWORD	dwNumDMAs;									// Not used
    DWORD   dwDMALst				[APCI8304_MAX_DMA];	// Not used
    DWORD   dwDMAAttrib				[APCI8304_MAX_DMA];	// Not used
    DWORD   dwReserved1				[3];				// Not used
} APCI8304_RESOURCE, *PAPCI8304R;

//-------------------------------------------------------------------
// VAʐMwp\
//-------------------------------------------------------------------
typedef struct _SIOMODE {
	WORD	Baud;					// {[[g    (BPS115200 ` BPS50)
	BYTE	WordSize;				// LN^  (CB8 or CB7 or CB6)
	BYTE	Parity;					// peB      (PNONE or PODD or PEVEN)
	BYTE	StopBits;				// Xgbvrbg(S1 or S2)
} SIOMODE, *PSIOMODE;

//-------------------------------------------------------------------
// VAʐMXe[^Xp\
//-------------------------------------------------------------------
typedef struct _SIOSTATUS {
	WORD	RxSize;					// Mf[^
} SIOSTATUS, *PSIOSTATUS;

//-------------------------------------------------------------------
// VAʐMɊւ`
//-------------------------------------------------------------------
enum BIT { 	BIT0=0x1, BIT1=0x2, BIT2=0x4, BIT3=0x8,
			BIT4=0x10,BIT5=0x20,BIT6=0x40,BIT7=0x80 };

#define APCI8304_SIO_CH1		0				// `lP
#define APCI8304_SIO_CH2		1				// `lQ
#define APCI8304_SIO_CH3		2				// `lR
#define APCI8304_SIO_CH4		3				// `lS

#define APCI8304_SIO_CB8		(BIT0 | BIT1)	// LN^ = 8bit
#define APCI8304_SIO_CB7		BIT1			// LN^ = 7bit
#define APCI8304_SIO_CB6		BIT0			// LN^ = 6bit

#define APCI8304_SIO_PNONE		0				// peB = Ȃ
#define APCI8304_SIO_PODD		BIT3			// peB = 
#define APCI8304_SIO_PEVEN		(BIT3 | BIT4)	// peB = 

#define APCI8304_SIO_S1			0				// Xgbvrbg = 1bit
#define APCI8304_SIO_S2			BIT2			// Xgbvrbg = 2bit

#define APCI8304_SIO_BPS115200	0x0001			// 115200 BPS
#define APCI8304_SIO_BPS57600	0x0002			//  57600 BPS
#define APCI8304_SIO_BPS38400	0x0003			//  38400 BPS
#define APCI8304_SIO_BPS19200	0x0006			//  19200 BPS
#define APCI8304_SIO_BPS9600	0x000c			//   9600 BPS
#define APCI8304_SIO_BPS7200	0x0010			//   7200 BPS
#define APCI8304_SIO_BPS4800	0x0018			//   4800 BPS
#define APCI8304_SIO_BPS3600	0x0020			//   3600 BPS
#define APCI8304_SIO_BPS2400	0x0030			//   2400 BPS
#define APCI8304_SIO_BPS2000	0x003a			//   2000 BPSiݒ덷0.068%j
#define APCI8304_SIO_BPS1800	0x0040			//   1800 BPS
#define APCI8304_SIO_BPS1200	0x0060			//   1200 BPS
#define APCI8304_SIO_BPS600		0x00c0			//    600 BPS
#define APCI8304_SIO_BPS300		0x0180			//    300 BPS
#define APCI8304_SIO_BPS150		0x0300			//    150 BPS
#define APCI8304_SIO_BPS134_5	0x0359			//  134.5 BPSiݒ덷0.058%j 
#define APCI8304_SIO_BPS110		0x0417			//    110 BPSiݒ덷0.026%j 
#define APCI8304_SIO_BPS75		0x0600			//     75 BPS
#define APCI8304_SIO_BPS50		0x0900			//     50 BPS

//-------------------------------------------------------------------
// G[R[h
//-------------------------------------------------------------------
#define APCI8304_SUCCESS				0		// ُȂiIj
#define APCI8304_ERR_SYSTEM				1		// Windows  GetLastError() R[Ă
												// ɃhCo[hĂȂ\܂
#define APCI8304_ERR_NO_DEVICE			2		// gp\ȃfoCX܂
#define APCI8304_ERR_IN_USE				3		// w̃foCX͎gpł
#define APCI8304_ERR_INVALID_SLOT		4		// Ș_\Pbgł
#define APCI8304_ERR_RESOURCE			5		// \[XG[
#define APCI8304_ERR_INVALID_ARGUMENT	6		// p[^s

#define APCI8304_ERR_BUSY				10		// w`l͉ғł
#define APCI8304_ERR_NO_ACTIVE			11		// w`l͓삵Ă܂
#define APCI8304_ERR_NOT_ENOUGH_MEM		12		// ʐMobt@mێs
#define APCI8304_ERR_INVALID_CH			13		// sȃ`llł
#define APCI8304_ERR_TIMEOUT			14		// ^CAEg
#define APCI8304_ERR_NO_DATA			15		// f[^w萔~ςĂ܂
#define APCI8304_ERR_BUFFER_OVER		16		// ʐMobt@I[o[t[
#define APCI8304_ERR_INVALID_PARAM		17		// ʐMw肪s
