Attribute VB_Name = "DLLDef"
'===================================================================
' Apci8304.bas
'-------------------------------------------------------------------
' aPCI-8304 
' Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
'===================================================================
Option Explicit

Global Const APCI8304_SLOT_AUTO = &HFFFF
Global Const APCI8304_MAX_SLOTS = 16
Global Const APCI8304_MAX_CH = 4
'-------------------------------------------------------------------
' \[X\̊evf̍ő吔
'-------------------------------------------------------------------
Global Const APCI8304_MAX_MEM = 9
Global Const APCI8304_MAX_IO = 20
Global Const APCI8304_MAX_IRQ = 7
Global Const APCI8304_MAX_DMA = 7
'-------------------------------------------------------------------
' \[X\
'-------------------------------------------------------------------
Type APCI8304_RESOURCE
    dwNumMemWindows As Long                         ' EBhE
    dwMemBase(1 To APCI8304_MAX_MEM) As Long        ' EBhEJnAhX
    dwMemLength(1 To APCI8304_MAX_MEM) As Long      ' EBhE
    dwMemAttrib(1 To APCI8304_MAX_MEM) As Long      ' EBhE
    dwNumIOPorts As Long                            ' I/O|[g
    dwIOPortBase(1 To APCI8304_MAX_IO) As Long      ' I/O|[gJnAhX
    dwIOPortLength(1 To APCI8304_MAX_IO) As Long    ' I/O|[g
    dwNumIRQs As Long                               ' IRQ
    dwIRQRegisters(1 To APCI8304_MAX_IRQ) As Long   ' IRQԍ
    dwIRQAttrib(1 To APCI8304_MAX_IRQ) As Long      ' IRQ
    dwNumDMAs As Long                               ' DMA`l
    dwDMALst(1 To APCI8304_MAX_DMA) As Long         ' DMA`l
    dwDMAAttrib(1 To APCI8304_MAX_DMA) As Long      ' DMA`l
    dwReserved1(1 To 3) As Long                     ' \
End Type
'-------------------------------------------------------------------
' VAʐMwp\
'-------------------------------------------------------------------
Type SIOMODE
    Baud As Integer                                 ' {[[g    (BPS115200 ` BPS50)
    WordSize As Byte                                ' LN^  (CB8 or CB7 or CB6)
    Parity As Byte                                  ' peB      (PNONE or PODD or PEVEN)
    StopBits As Byte                                ' Xgbvrbg(S1 or S2)
End Type
'-------------------------------------------------------------------
' VAʐMXe[^Xp\
'-------------------------------------------------------------------
Type SIOSTATUS
    RxSize As Integer                               ' Mf[^
End Type
'-------------------------------------------------------------------
' VAʐMɊւ`
'-------------------------------------------------------------------
Global Const BIT0 = &H1
Global Const BIT1 = &H2
Global Const BIT2 = &H4
Global Const BIT3 = &H8
Global Const BIT4 = &H10
Global Const BIT5 = &H20
Global Const BIT6 = &H40
Global Const BIT7 = &H80

Global Const APCI8304_SIO_CH1 = 0                   ' `lP
Global Const APCI8304_SIO_CH2 = 1                   ' `lQ
Global Const APCI8304_SIO_CH3 = 2                   ' `lR
Global Const APCI8304_SIO_CH4 = 3                   ' `lS

Global Const APCI8304_SIO_CB8 = (BIT0 Or BIT1)      ' LN^ = 8bit
Global Const APCI8304_SIO_CB7 = BIT1                ' LN^ = 7bit
Global Const APCI8304_SIO_CB6 = BIT0                ' LN^ = 6bit

Global Const APCI8304_SIO_PNONE = 0                 ' peB = Ȃ
Global Const APCI8304_SIO_PODD = BIT3               ' peB = 
Global Const APCI8304_SIO_PEVEN = (BIT3 Or BIT4)    ' peB = 

Global Const APCI8304_SIO_S1 = 0                    ' Xgbvrbg = 1bit
Global Const APCI8304_SIO_S2 = BIT2                 ' Xgbvrbg = 2bit

Global Const APCI8304_SIO_BPS115200 = &H1           ' 115200 BPS
Global Const APCI8304_SIO_BPS57600 = &H2            '  57600 BPS
Global Const APCI8304_SIO_BPS38400 = &H3            '  38400 BPS
Global Const APCI8304_SIO_BPS19200 = &H6            '  19200 BPS
Global Const APCI8304_SIO_BPS9600 = &HC             '   9600 BPS
Global Const APCI8304_SIO_BPS7200 = &H10            '   7200 BPS
Global Const APCI8304_SIO_BPS4800 = &H18            '   4800 BPS
Global Const APCI8304_SIO_BPS3600 = &H20            '   3600 BPS
Global Const APCI8304_SIO_BPS2400 = &H30            '   2400 BPS
Global Const APCI8304_SIO_BPS2000 = &H3A            '   2000 BPSiݒ덷0.068%j
Global Const APCI8304_SIO_BPS1800 = &H40            '   1800 BPS
Global Const APCI8304_SIO_BPS1200 = &H60            '   1200 BPS
Global Const APCI8304_SIO_BPS600 = &HC0             '    600 BPS
Global Const APCI8304_SIO_BPS300 = &H180            '    300 BPS
Global Const APCI8304_SIO_BPS150 = &H300            '    150 BPS
Global Const APCI8304_SIO_BPS134_5 = &H359          '  134.5 BPSiݒ덷0.058%j
Global Const APCI8304_SIO_BPS110 = &H417            '    110 BPSiݒ덷0.026%j
Global Const APCI8304_SIO_BPS75 = &H600             '     75 BPS
Global Const APCI8304_SIO_BPS50 = &H900             '     50 BPS
'-------------------------------------------------------------------
' G[R[h
'-------------------------------------------------------------------
Global Const APCI8304_SUCCESS = 0                   ' ُȂiIj
Global Const APCI8304_ERR_SYSTEM = 1                ' Windows  GetLastError() R[Ă
                                                    ' ɃhCo[hĂȂ\܂
Global Const APCI8304_ERR_NO_DEVICE = 2             ' gp\ȃfoCX܂
Global Const APCI8304_ERR_IN_USE = 3                ' w̃foCX͎gpł
Global Const APCI8304_ERR_INVALID_SLOT = 4          ' Ș_\Pbgł
Global Const APCI8304_ERR_RESOURCE = 5              ' \[XG[
Global Const APCI8304_ERR_INVALID_ARGUMENT = 6      ' p[^s

Global Const APCI8304_ERR_BUSY = 10                 ' w`l͉ғł
Global Const APCI8304_ERR_NO_ACTIVE = 11            ' w`l͓삵Ă܂
Global Const APCI8304_ERR_NOT_ENOUGH_MEM = 12       ' ʐMobt@mێs
Global Const APCI8304_ERR_INVALID_CH = 13           ' sȃ`llł
Global Const APCI8304_ERR_TIMEOUT = 14              ' ^CAEg
Global Const APCI8304_ERR_NO_DATA = 15              ' f[^w萔~ςĂ܂
Global Const APCI8304_ERR_BUFFER_OVER = 16          ' ʐMobt@I[o[t[
Global Const APCI8304_ERR_INVALID_PARAM = 17        ' ʐMw肪s
'-------------------------------------------------------------------
' API Functions
'-------------------------------------------------------------------
Public Declare Function Apci8304GetVersion Lib "Apci8304" (ByRef pdwDllVer As Long, ByRef pdwDrvVer As Long) As Boolean
Public Declare Function Apci8304Create Lib "Apci8304" (ByRef pwLogSlot As Integer) As Boolean
Public Declare Function Apci8304Close Lib "Apci8304" (ByVal wLogSlot As Integer) As Boolean
Public Declare Function Apci8304GetResource Lib "Apci8304" (ByVal wLogSlot As Integer, ByRef pRes As APCI8304_RESOURCE) As Boolean
Public Declare Function Apci8304GetSwitchValue Lib "Apci8304" (ByVal wLogSlot As Integer, ByRef pdwSwitchValue As Long) As Boolean
Public Declare Function Apci8304GetLastError Lib "Apci8304" (ByVal wLogSlot As Integer) As Long
Public Declare Function Apci8304SioStart Lib "Apci8304" (ByVal wLogSlot As Integer, ByVal wCh As Integer, ByRef pMode As SIOMODE) As Boolean
Public Declare Function Apci8304SioGetStatus Lib "Apci8304" (ByVal wLogSlot As Integer, ByVal wCh As Integer, ByRef pStatus As SIOSTATUS) As Boolean
Public Declare Function Apci8304SioRead Lib "Apci8304" (ByVal wLogSlot As Integer, ByVal wCh As Integer, ByRef pbData As Byte, ByVal dwDataSize As Long) As Boolean
Public Declare Function Apci8304SioWrite Lib "Apci8304" (ByVal wLogSlot As Integer, ByVal wCh As Integer, ByRef pbData As Byte, ByVal dwDataSize As Long) As Boolean
Public Declare Function Apci8304SioReset Lib "Apci8304" (ByVal wLogSlot As Integer, ByVal wCh As Integer) As Boolean
Public Declare Function Apci8304SioStop Lib "Apci8304" (ByVal wLogSlot As Integer, ByVal wCh As Integer) As Boolean


















