//===================================================================
// Apci8304w.pas - wrapper for Delphi 
//-------------------------------------------------------------------
// Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
//===================================================================
unit Apci8304w;

interface

uses
  Windows, SysUtils;

const
	APCI8304_SUCCESS							=0;
	APCI8304_ERR_SYSTEM						=1;
	APCI8304_ERR_NO_DEVICE				=2;
	APCI8304_ERR_IN_USE						=3;
	APCI8304_ERR_INVALID_SLOT			=4;
	APCI8304_ERR_RESOURCE					=5;
	APCI8304_ERR_INVALID_ARGUMENT	=6;
	APCI8304_ERR_BUSY							=10;
	APCI8304_ERR_NO_ACTIVE				=11;
	APCI8304_ERR_NOT_ENOUGH_MEM		=12;
	APCI8304_ERR_INVALID_CH				=13;
	APCI8304_ERR_TIMEOUT					=14;
	APCI8304_ERR_NO_DATA					=15;
	APCI8304_ERR_BUFFER_OVER			=16;
	APCI8304_ERR_INVALID_PARAM		=17;
	APCI8304_ERR_WRAPDLL					=$FFFF;

	APCI8304_SLOT_AUTO						=$FFFF;
	APCI8304_MAX_SLOTS						=16;
	APCI8304_MAX_CH								=4;
	APCI8304_DLL_NAME							='Apci8304.dll';

	BIT0													=$01;
	BIT1													=$02;
	BIT2													=$04;
	BIT3													=$08;
	BIT4													=$10;
	BIT5													=$20;
	BIT6													=$40;
	BIT7													=$80;

	APCI8304_SIO_CH1							=0;
	APCI8304_SIO_CH2							=1;
	APCI8304_SIO_CH3							=2;
	APCI8304_SIO_CH4							=3;

	APCI8304_SIO_CB8							=(BIT0 or BIT1);
	APCI8304_SIO_CB7							=BIT1;
	APCI8304_SIO_CB6							=BIT0;

	APCI8304_SIO_PNONE						=0;
	APCI8304_SIO_PODD							=BIT3;
	APCI8304_SIO_PEVEN						=(BIT3 or BIT4);

	APCI8304_SIO_S1								=0;
	APCI8304_SIO_S2								=BIT2;

	APCI8304_SIO_BPS115200				=$0001;
	APCI8304_SIO_BPS57600					=$0002;
	APCI8304_SIO_BPS38400					=$0003;
	APCI8304_SIO_BPS19200					=$0006;
	APCI8304_SIO_BPS9600					=$000c;
	APCI8304_SIO_BPS7200					=$0010;
	APCI8304_SIO_BPS4800					=$0018;
	APCI8304_SIO_BPS3600					=$0020;
	APCI8304_SIO_BPS2400					=$0030;
	APCI8304_SIO_BPS2000					=$003a;
	APCI8304_SIO_BPS1800					=$0040;
	APCI8304_SIO_BPS1200					=$0060;
	APCI8304_SIO_BPS600						=$00c0;
	APCI8304_SIO_BPS300						=$0180;
	APCI8304_SIO_BPS150						=$0300;
	APCI8304_SIO_BPS134_5					=$0359;
	APCI8304_SIO_BPS110						=$0417;
	APCI8304_SIO_BPS75						=$0600;
	APCI8304_SIO_BPS50						=$0900;

	APCI8304_MAX_MEM							=9;
	APCI8304_MAX_IO								=20;
	APCI8304_MAX_IRQ							=7;
	APCI8304_MAX_DMA							=7;


type

	TAPCI8304_RESOURCE = record
		dwNumMemWindows:																	DWORD;	// س޳(gp)
		dwMemBase:			array [1 .. APCI8304_MAX_MEM] of	DWORD;	// س޳ްڽ(gp)
		dwMemLength:		array [1 .. APCI8304_MAX_MEM] of	DWORD;	// س޳(gp)
		dwMemAttrib:		array [1 .. APCI8304_MAX_MEM] of	DWORD;	// س޳(gp)
		dwNumIOPorts:																			DWORD;	// I/O߰Đ
		dwIOPortBase:		array [1 .. APCI8304_MAX_IO]  of	DWORD;	// I/O߰ްڽ
		dwIOPortLength: array [1 .. APCI8304_MAX_IO]	of	DWORD;	// I/O߰Ē
		dwNumIRQs:																				DWORD;	// IRQ
		dwIRQRegisters: array [1 .. APCI8304_MAX_IRQ] of	DWORD;	// IRQؽ
		dwIRQAttrib:		array [1 .. APCI8304_MAX_IRQ] of	DWORD;	// IRQؽ
		dwNumDMAs:																				DWORD;	// DMAِ(gp)
		dwDMALst:				array [1 .. APCI8304_MAX_DMA] of	DWORD;	// DMAؽ(gp)
		dwDMAAttrib:		array [1 .. APCI8304_MAX_DMA] of	DWORD;	// DMAّؽ(gp)
		dwReserved1:		array [1 .. 3] 						 		of	DWORD;	// \(gp)
	end;
	PAPCI8304R = ^TAPCI8304_RESOURCE;

	TSIOMODE = record
		Baud:			WORD;
		WordSize:	BYTE;
		Parity:		BYTE;
		StopBits:	BYTE;
	end;
	PSIOMODE = ^TSIOMODE;

	TSIOSTATUS = record
		RxSize:		WORD;
	end;
	PSIOSTATUS = ^TSIOSTATUS;

// function
	function Apci8304wDllOpen: Boolean;
	function Apci8304wDllClose: Boolean;
	function Apci8304wGetVersion( var pdwDllVer:DWORD; var pdwDrvVer:DWORD ):Boolean;
	function Apci8304wCreate( var pwLogSlot:WORD ):Boolean;
	function Apci8304wClose( wLogSlot:WORD ):Boolean;
	function Apci8304wGetResource( wLogSlot:WORD; pRes:PAPCI8304R ):Boolean;
	function Apci8304wGetSwitchValue( wLogSlot:WORD; var pdwSwitchValue:DWORD ):Boolean;
	function Apci8304wGetLastError( wLogSlot:WORD ):DWORD;
	function Apci8304wSioStart( wLogSlot:WORD; wCh:WORD; pMode:PSIOMODE ):Boolean;
	function Apci8304wSioGetStatus( wLogSlot:WORD; wCh:WORD; pStatus:PSIOSTATUS ):Boolean;
	function Apci8304wSioRead( wLogSlot:WORD; wCh:WORD; var pbData:array of BYTE; dwDataSize:DWORD ):Boolean;
	function Apci8304wSioWrite( wLogSlot:WORD; wCh:WORD; var pbData:array of BYTE; dwDataSize:DWORD ):Boolean;
	function Apci8304wSioReset( wLogSlot:WORD; wCh:WORD ):Boolean;
	function Apci8304wSioStop( wLogSlot:WORD; wCh:WORD ):Boolean;

implementation

{$J+}	// ^t萔̕ύX\߲׎w

const
	hDLL: THandle = 0;
type
	TApci8304GetVersion 		= function ( var pdwDllVer:DWORD; var pdwDrvVer:DWORD ):Boolean; stdcall;
	TApci8304Create 				= function ( var pwLogSlot:WORD ):Boolean; stdcall;
	TApci8304Close 					= function ( wLogSlot:WORD ):Boolean; stdcall;
	TApci8304GetResource 		= function ( wLogSlot:WORD; pRes:PAPCI8304R ):Boolean; stdcall;
	TApci8304GetSwitchValue = function ( wLogSlot:WORD; var pdwSwitchValue:DWORD ):Boolean; stdcall;
	TApci8304GetLastError 	= function ( wLogSlot:WORD ):DWORD; stdcall;
	TApci8304SioStart 			= function ( wLogSlot:WORD; wCh:WORD; pMode:PSIOMODE ):Boolean; stdcall;
	TApci8304SioGetStatus 	= function ( wLogSlot:WORD; wCh:WORD; pStatus:PSIOSTATUS ):Boolean; stdcall;
	TApci8304SioRead 				= function ( wLogSlot:WORD; wCh:WORD; pbData:PCHAR; dwDataSize:DWORD ):Boolean; stdcall;
	TApci8304SioWrite 			= function ( wLogSlot:WORD; wCh:WORD; pbData:PCHAR; dwDataSize:DWORD ):Boolean; stdcall;
	TApci8304SioReset 			= function ( wLogSlot:WORD; wCh:WORD ):Boolean; stdcall;
	TApci8304SioStop 				= function ( wLogSlot:WORD; wCh:WORD ):Boolean; stdcall;

// DLL ߰Ċ֐ڽ̊i[ϐ
var
	pApci8304GetVersion			:TApci8304GetVersion;
	pApci8304Create					:TApci8304Create;
	pApci8304Close					:TApci8304Close;
	pApci8304GetResource		:TApci8304GetResource;
	pApci8304GetSwitchValue	:TApci8304GetSwitchValue;
	pApci8304GetLastError		:TApci8304GetLastError;
	pApci8304SioStart				:TApci8304SioStart;
	pApci8304SioGetStatus		:TApci8304SioGetStatus;
	pApci8304SioRead				:TApci8304SioRead;
	pApci8304SioWrite				:TApci8304SioWrite;
	pApci8304SioReset				:TApci8304SioReset;
	pApci8304SioStop				:TApci8304SioStop;

	function _Apci8304wGetDllExportFunc: Boolean; forward;

{$J-}

//===================================================================
//   	DLL۰(۰ގʹװƂ)
//   	
// ߂l  True
//				s False
//===================================================================
function Apci8304wDllOpen: Boolean;
begin
	Result:=False;
	if hDLL=0 then begin
		hDLL:=LoadLibrary(APCI8304_DLL_NAME);
		if hDLL<>0 then begin
			if _Apci8304wGetDllExportFunc=True then begin
      	Result:=True
			end else Apci8304wDllClose;	// DLL֐擾ɎŝDLLN[Y
		end;
	end;
end;
//===================================================================
//   	DLL۰(۰ގʹװƂ)
//   	
// ߂l  True
//				s False
//===================================================================
function Apci8304wDllClose: Boolean;
begin
	Result:=False;
	if hDLL<>0 then begin
		if True=FreeLibrary(hDLL) then begin
			hDLL:=0;
			Result:=True;
		end;
	end;
end;
//===================================================================
//   	DLL,Driver ̃o[W擾
//   	pdwDllVer				DLL o[Wԍi[̈
//        pdwDrvVer				DRV o[Wԍi[̈
// ߂l  True
//				s False
//===================================================================
function Apci8304wGetVersion( var pdwDllVer:DWORD; var pdwDrvVer:DWORD ):Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result:=pApci8304GetVersion(pdwDllVer, pdwDrvVer);
end;
//===================================================================
//   	foCXgp錾
//   	pwLogSlot				gpfoCXԍi[̈
// ߂l  True
//				s False
//===================================================================
function Apci8304wCreate( var pwLogSlot:WORD ):Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result:=pApci8304Create(pwLogSlot);
end;
//===================================================================
//   	foCXJ
//   	wLogSlot				foCX̘_Xbgԍ
// ߂l  True
//				s False
//===================================================================
function Apci8304wClose( wLogSlot:WORD ):Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result:=pApci8304Close(wLogSlot);
end;
//===================================================================
//   	\[X擾
//   	wLogSlot				foCX̘_Xbgԍ
//				pRes						\[Xi[̈
// ߂l  True
//				s False
//===================================================================
function Apci8304wGetResource( wLogSlot:WORD; pRes:PAPCI8304R ):Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result:=pApci8304GetResource(wLogSlot,pRes);
end;
//===================================================================
//   	arml擾
//   	wLogSlot				foCX̘_Xbgԍ
//				pdwSwitchValue	armli[̈
// ߂l  True
//				s False
//===================================================================
function Apci8304wGetSwitchValue( wLogSlot:WORD; var pdwSwitchValue:DWORD ):Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result:=pApci8304GetSwitchValue(wLogSlot,pdwSwitchValue);
end;
//===================================================================
//   	G[擾
//   	wLogSlot				foCX̘_Xbgԍ
// ߂l G[
//===================================================================
function Apci8304wGetLastError( wLogSlot:WORD ):DWORD;
begin
	if hDLL=0 then Result:=APCI8304_ERR_WRAPDLL
	else Result:=pApci8304GetLastError(wLogSlot)
end;
//===================================================================
//   	VAʐMJn
//   	wLogSlot				foCX̘_Xbgԍ
//				wCh							gp`l
//				pMode						샂[hi[Ă̈
// ߂l  True
//				s False
//===================================================================
function Apci8304wSioStart( wLogSlot:WORD; wCh:WORD; pMode:PSIOMODE ):Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result:=pApci8304SioStart(wLogSlot,wCh,pMode);
end;
//===================================================================
//   	ʐMXe[^X擾
//   	wLogSlot				foCX̘_Xbgԍ
//				wCh							gp`l
//				pStatus					Xe[^Xi[̈
// ߂l  True
//				s False
//===================================================================
function Apci8304wSioGetStatus( wLogSlot:WORD; wCh:WORD; pStatus:PSIOSTATUS ):Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result:=pApci8304SioGetStatus(wLogSlot,wCh,pStatus);
end;
//===================================================================
//   	f[^M
//   	wLogSlot				foCX̘_Xbgԍ
//				wCh							gp`l
//				pbData					Mf[^ۑ̈
//				dwDataSize			Mf[^
// ߂l  True
//				s False
//===================================================================
function Apci8304wSioRead( wLogSlot:WORD; wCh:WORD; var pbData:array of BYTE; dwDataSize:DWORD ):Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result:=pApci8304SioRead(wLogSlot,wCh,PChar(@pbData),dwDataSize);
end;
//===================================================================
//   	f[^M
//   	wLogSlot				foCX̘_Xbgԍ
//				wCh							gp`l
//				pbData					Mf[^̈
//				dwDataSize			Mf[^
// ߂l  True
//				s False
//===================================================================
function Apci8304wSioWrite( wLogSlot:WORD; wCh:WORD; var pbData:array of BYTE; dwDataSize:DWORD ):Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result:=pApci8304SioWrite(wLogSlot,wCh,PChar(@pbData),dwDataSize);
end;
//===================================================================
//   	obt@̃Zbg
//   	wLogSlot				foCX̘_Xbgԍ
//				wCh							gp`l
// ߂l  True
//				s False
//===================================================================
function Apci8304wSioReset( wLogSlot:WORD; wCh:WORD ):Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result:=pApci8304SioReset(wLogSlot,wCh);
end;
//===================================================================
//   	VAʐM~
//   	wLogSlot				foCX̘_Xbgԍ
//				wCh							gp`l
// ߂l  True
//				s False
//===================================================================
function Apci8304wSioStop( wLogSlot:WORD; wCh:WORD ):Boolean;
begin
	Result := False;
	if hDLL = 0 then Exit;
	Result:=pApci8304SioStop(wLogSlot,wCh);
end;
//-------------------------------------------------------------------
// 	  DLL߰Ċ֐ڽ̎擾
// 	  
// ߂l  True
//		  	s False
//-------------------------------------------------------------------
function _Apci8304wGetDllExportFunc: Boolean;
begin
	Result:=False;

	pApci8304GetVersion			:=GetProcAddress(hDLL, 'Apci8304GetVersion');
	pApci8304Create					:=GetProcAddress(hDLL, 'Apci8304Create');
	pApci8304Close					:=GetProcAddress(hDLL, 'Apci8304Close');
	pApci8304GetResource		:=GetProcAddress(hDLL, 'Apci8304GetResource');
	pApci8304GetSwitchValue	:=GetProcAddress(hDLL, 'Apci8304GetSwitchValue');
	pApci8304GetLastError		:=GetProcAddress(hDLL, 'Apci8304GetLastError');
	pApci8304SioStart				:=GetProcAddress(hDLL, 'Apci8304SioStart');
	pApci8304SioGetStatus		:=GetProcAddress(hDLL, 'Apci8304SioGetStatus');
	pApci8304SioRead				:=GetProcAddress(hDLL, 'Apci8304SioRead');
	pApci8304SioWrite				:=GetProcAddress(hDLL, 'Apci8304SioWrite');
	pApci8304SioReset				:=GetProcAddress(hDLL, 'Apci8304SioReset');
	pApci8304SioStop				:=GetProcAddress(hDLL, 'Apci8304SioStop');

	if @pApci8304GetVersion			=nil then Exit;
	if @pApci8304Create					=nil then Exit;
	if @pApci8304Close					=nil then Exit;
	if @pApci8304GetResource		=nil then Exit;
	if @pApci8304GetSwitchValue	=nil then Exit;
	if @pApci8304GetLastError		=nil then Exit;
	if @pApci8304SioStart				=nil then Exit;
	if @pApci8304SioGetStatus		=nil then Exit;
	if @pApci8304SioRead				=nil then Exit;
	if @pApci8304SioWrite				=nil then Exit;
	if @pApci8304SioReset				=nil then Exit;
	if @pApci8304SioStop				=nil then Exit;

	// SĂ DLL ߰Ċ֐ڽ擾nj
	Result:=True;
end;

end.





