//===================================================================
// Apci8304s.pas
//-------------------------------------------------------------------
// aPCI-8304
// Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
//
// Date Feb.2000
//
// ̃\[Xɂ̓bp[֐̎gpႪLqĂ܂
//===================================================================
unit Apci8304s;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
	Apci8304w;

const
	szTitle			= 'Sample';
	szApci8304 	= 'aPCI-8304';
	BUFSIZE			= 512;

type
	TMainForm = class(TForm)
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private 錾 }
  public
		procedure ResultMessage(strbuf:String);
		procedure ErrorMessage(wLogSlot:Word);
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}
//===================================================================
// ۂ̏
//===================================================================
procedure TMainForm.FormCreate(Sender: TObject);
var
	strbuf:					String;
	TxStr:					String;
	dwDllVer:				DWORD;
	dwDrvVer:				DWORD;
	dwSwitch:				DWORD;
	Len:						DWORD;
	wLogSlot:				WORD;
	ri:							TAPCI8304_RESOURCE;
	Mode:						TSIOMODE;
	Status:					TSIOSTATUS;
	Buff: Array[0..BUFSIZE] of BYTE;		// ʐMobt@


begin
	//-----------------------------------------------------------------
	// Apci8304.dll J
	//-----------------------------------------------------------------
	if Apci8304wDllOpen() = False then begin
		ErrorMessage( APCI8304_SLOT_AUTO );
		Halt;
	end;
  strbuf := 'DLL[h܂B';
  ResultMessage(strbuf);
	//-----------------------------------------------------------------
	// o[W\
	//-----------------------------------------------------------------
	if Apci8304wGetVersion(dwDllVer,dwDrvVer) = False then begin
		ErrorMessage( APCI8304_SLOT_AUTO );
		Halt;
	end;
	strbuf:= Format(
						'GetVersion'#10+
						'Dll Version : %08xH'#10+
						'Drv Version : %08xH', [dwDllVer,dwDrvVer]);
	ResultMessage(strbuf);
	//-----------------------------------------------------------------
	// foCX̎gp錾
	//-----------------------------------------------------------------
	wLogSlot:=APCI8304_SLOT_AUTO; // 󂫃foCXw
	if Apci8304wCreate(wLogSlot) = False then begin
		ErrorMessage( APCI8304_SLOT_AUTO );
		Halt;
	end;
	strbuf:=Format(
			'aPCI-8304 Created'#10+
  		'LogSlot : %2d',[wLogSlot]);
	ResultMessage(strbuf);
	//-----------------------------------------------------------------
	// \[X\
	//-----------------------------------------------------------------
	if Apci8304wGetResource(wLogSlot,@ri) = False then begin
		ErrorMessage(wLogSlot);
		Halt;
	end;
	strbuf:=Format(
		'aPCI-8304 Resource'#10+
		'NumPorts : %d'#10+
		'IO Address[0] : %xH - %xH'#10+
		'IO Address[1] : %xH - %xH'#10+
		'IRQ : %d',
		[ri.dwNumIOPorts,
		 ri.dwIOPortBase[1],ri.dwIOPortBase[1]+ri.dwIOPortLength[1]-1,
		 ri.dwIOPortBase[2],ri.dwIOPortBase[2]+ri.dwIOPortLength[2]-1,
		 ri.dwIRQRegisters[1]]);
  ResultMessage(strbuf);
	//-----------------------------------------------------------------
	// arml擾
	//-----------------------------------------------------------------
	if Apci8304wGetSwitchValue(wLogSlot,dwSwitch) = False then begin
		ErrorMessage(wLogSlot);
		Halt;
	end;
	strbuf:=Format(
			'aPCI-8304'#10 +
			'BSN : %xH', [dwSwitch]);
	ResultMessage(strbuf);
	//---------------------------------------------------------------
	// VAʐMJni`lPj
	//---------------------------------------------------------------
	Mode.Baud			:= APCI8304_SIO_BPS115200; 	// 115200bps
	Mode.WordSize	:= APCI8304_SIO_CB8;				// LN^ 8bit
	Mode.Parity		:= APCI8304_SIO_PNONE;			// peB
	Mode.StopBits	:= APCI8304_SIO_S1;					// Xgbvrbg 1bit

	if Apci8304wSioStart(wLogSlot,APCI8304_SIO_CH1,@Mode) = False then begin
		ErrorMessage(wLogSlot);
		Halt;
	end;
	strbuf:=
		'ȉ̏ŒʐMJn܂'#10+
		'`l : 1'#10+
		'ʐMx : 115200bps'#10+
		'LN^ : 8bit'#10+
		'peB : '#10+
		'Xgbvrbg : 1bit';
	ResultMessage(strbuf);
	//---------------------------------------------------------------
	// ʐMobt@Zbg
	//---------------------------------------------------------------
	if Apci8304wSioReset(wLogSlot,APCI8304_SIO_CH1) = False then begin
		ErrorMessage(wLogSlot);
		Halt;
	end;
	ResultMessage('ʐMobt@Zbg܂');
	//---------------------------------------------------------------
	// f[^M
	//---------------------------------------------------------------
	TxStr :='ABCDEFG1234567';			// M쐬
	Len		:=Length(TxStr);				// M擾
	Move(TxStr[1],Buff,Len);			// ʐMobt@ɃRs[

	if Apci8304wSioWrite(wLogSlot,APCI8304_SIO_CH1,Buff,Len) = False then begin
		ErrorMessage(wLogSlot);
		Halt;
	end;
	strbuf:=Format(
		'f[^[%s](%dbyte)'#10+
		'𑗐M܂',[TxStr,Len]);
	ResultMessage(strbuf);
	//---------------------------------------------------------------
	// ʐMXe[^X擾
	//---------------------------------------------------------------
	if Apci8304wSioGetStatus(wLogSlot,APCI8304_SIO_CH1,@Status) = False then begin
		ErrorMessage(wLogSlot);
		Halt;
	end;
	strbuf:=Format(
		'ʐMXe[^X擾܂'#10+
		'Mf[^ : %dbyte',[Status.RxSize]);
	ResultMessage(strbuf);
	//---------------------------------------------------------------
	// Mf[^ꍇMs
	//---------------------------------------------------------------
	if Status.RxSize > 0 then begin
		if BUFSIZE < Status.RxSize then Status.RxSize := BUFSIZE;
		if Apci8304wSioRead(wLogSlot,APCI8304_SIO_CH1,Buff,Status.RxSize) = False then begin
			ErrorMessage(wLogSlot);
			Halt;
		end;
		Buff[Status.RxSize]:=$00;
		strbuf:=Format(
			'f[^ %dbyteM܂'#10+
			'Mf[^ : '#10+'%s',[Status.RxSize,PChar(@Buff)]);
		ResultMessage(strbuf);
	end;
	//---------------------------------------------------------------
	// ʐMI
	//---------------------------------------------------------------
	if Apci8304wSioStop(wLogSlot,APCI8304_SIO_CH1) = False then begin
		ErrorMessage(wLogSlot);
		Halt;
	end;
	ResultMessage('ʐM~܂');
	//-----------------------------------------------------------------
	// foCX
	//-----------------------------------------------------------------
	if Apci8304wClose(wLogSlot) = False then begin
		ErrorMessage(wLogSlot);
		Halt;
	end;
	strbuf:=Format(
			'aPCI-8304 Close'#10+
  		'LogSlot : %2d',[wLogSlot]);
	ResultMessage(strbuf);
	Halt;
end;
//===================================================================
// I
//===================================================================
procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
	//-----------------------------------------------------------------
	// Apci8304.dll 
	//-----------------------------------------------------------------
	Apci8304wDllClose();
end;
//===================================================================
// ʂ\
//===================================================================
procedure TMainForm.ResultMessage(strbuf:String);
begin
	Application.MessageBox(PChar(strbuf), szTitle, MB_OK + MB_ICONINFORMATION);
end;
//===================================================================
// G[bZ[W\
//===================================================================
procedure TMainForm.ErrorMessage(wLogSlot:Word);
var
	dwRes:	DWord;
	strbuf:	String;
begin
	dwRes:=Apci8304wGetLastError(wLogSlot);
	if dwRes = APCI8304_ERR_WRAPDLL then begin
		strbuf:='DLL Load error';
	end else begin
		strbuf:=Format(
							'aPCI-8304 error'#10#10'Error code : %08xH',[dwRes]);
	end;
	Application.MessageBox(PChar(strbuf), szTitle, MB_OK + MB_ICONSTOP);
end;
end.
