/*============================================================================
//	apci8102w.c
//
//	Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
//
//	V1.11 Date 1999/09/10
//
//==========================================================================*/
#include <windows.h>
#include <tchar.h>
#include "apci8102w.h"	/* aPCI-8102 */

/*-------------------------------------
// (STATIC)ϐȂ
//-----------------------------------*/
static BOOL Apci8102wGetDllExportFunc();
static HMODULE hDLL = NULL;

/* DLL ߰Ċ֐ڽ̊i[ϐ */
static FARPROC pApci8102GetVersion = NULL;
static FARPROC pApci8102Create = NULL;
static FARPROC pApci8102Close = NULL;
static FARPROC pApci8102GetResource = NULL;
static FARPROC pApci8102InPort = NULL;
static FARPROC pApci8102OutPort = NULL;
static FARPROC pApci8102GetLastError = NULL;
static FARPROC pApci8102GetDirections = NULL;
static FARPROC pApci8102SetDirections = NULL;

/*============================================================================
// 	  apci8102.dll۰(۰ގʹװƂ)	
// 	  
// ߂l  TRUE
//		  s FALSE
//==========================================================================*/
BOOL Apci8102wDllOpen()
{
	BOOL	Result = FALSE;
	if (hDLL == NULL){
		hDLL = (HMODULE)LoadLibrary(APCI8102_DLL_NAME);
		if (hDLL != NULL){
			Result = Apci8102wGetDllExportFunc();
			if (TRUE != Result)
				Apci8102wDllClose();	/* DLL֐擾ɎŝDLL۰ */
		}
	}
	return Result;
}
/*============================================================================
// 	  apci8102.dll۰(۰ގʹװƂ)
// 	  
// ߂l  TRUE
//		  s FALSE
//==========================================================================*/
BOOL Apci8102wDllClose()
{
	BOOL	Result = FALSE;
	if (hDLL != NULL){
		Result = FreeLibrary(hDLL);
		if (TRUE == Result)
			hDLL = NULL;
	}
	return Result;
}
/*============================================================================
// 	  aPCI-8102 DLL,޲ײްްޮݔԍ擾
// 	  pdwDllVersion		DLLްޮݔԍi[̈ւ߲
//		  pdwDriverVersion	޲ײްްޮݔԍi[̈ւ߲
// ߂l  TRUE
//		  s FALSE
//==========================================================================*/
BOOL Apci8102wGetVersion(PDWORD pdwDllVersion, PDWORD pdwDriverVersion)
{
	BOOL	Result = FALSE;
	if (hDLL != NULL)
		Result = (*pApci8102GetVersion)(pdwDllVersion, pdwDriverVersion);
	return Result;
}
/*============================================================================
// 	  aPCI-8102̔Cӂ޲̎gp錾
// 	  pwLogSlot	 gp޲̘_ۯĔԍi[߲
// ߂l  TRUE
//		  s FALSE
//==========================================================================*/
BOOL Apci8102wCreate(PWORD pwLogSlot)
{
	BOOL	Result = FALSE;
	if (hDLL != NULL)
		Result = (*pApci8102Create)(pwLogSlot);
	return Result;
}
/*============================================================================
// 	  aPCI-8102̔Cӂ޲̎gpJ
// 	  wLogSlot ޲̘_ۯĔԍ
// ߂l  TRUE
//		  s FALSE
//==========================================================================*/
BOOL Apci8102wClose(WORD wLogSlot)
{
	BOOL	Result = FALSE;
	if (hDLL != NULL)
		Result = (*pApci8102Close)(wLogSlot);
	return Result;
}
/*============================================================================
// 	  w޲ؿ擾
// 	  wLogSlot	ؿ擾޲̘_ۯĔԍ
//		  pResInfo	ؿi[\߲̂
// ߂l  TRUE
//		  s FALSE
//==========================================================================*/
BOOL Apci8102wGetResource(WORD wLogSlot, PAPCI8102R pResInfo)
{
	BOOL	Result = FALSE;
	if (hDLL != NULL)
		Result = (*pApci8102GetResource)(wLogSlot, pResInfo);
	return Result;
}
/*============================================================================
// 	  Cӂ߰Ăް
// 	  wLogSlot	͂޲̘_ۯĔԍ
//		  dwLogPort	͂_߰
//		  pbInValue ްi[̈ւ߲
// ߂l  TRUE
//		  s FALSE
//==========================================================================*/
BOOL Apci8102wInPort(WORD wLogSlot, DWORD dwLogPort, PBYTE pbInValue)
{
	BOOL	Result = FALSE;
	if (hDLL != NULL)
		Result = (*pApci8102InPort)(wLogSlot, dwLogPort, pbInValue);
	return Result;
}
/*============================================================================
// 	  Cӂ߰Ăްo
// 	  wLogSlot	o͂޲̘_ۯĔԍ
//		  dwLogPort	o͂_߰
//		  bOutValue o͂ް
// ߂l  TRUE
//		  s FALSE
//==========================================================================*/
BOOL Apci8102wOutPort(WORD wLogSlot, DWORD dwLogPort, BYTE bOutValue)
{
	BOOL	Result = FALSE;
	if (hDLL != NULL)
		Result = (*pApci8102OutPort)(wLogSlot, dwLogPort, bOutValue);
	return Result;
}
/*============================================================================
// 	  aPCI-8102̴װ
// 	  wLogSlot	װ޲̘_ۯĔԍ
// ߂l װ
//==========================================================================*/
DWORD Apci8102wGetLastError(WORD wLogSlot)
{
	if (NULL == hDLL)
		return APCI8102_ERR_WRAPDLL;
	else
		return (*pApci8102GetLastError)(wLogSlot);
}
/*============================================================================
// 	  ިڸ݂̏Ԃ擾
// 	  wLogSlot		ިڸ݂̏Ԃ擾޲̘_ۯĔԍ
//		  pdwDirections ިڸݏԂi[̈ւ߲
// ߂l  TRUE
//		  s FALSE
//==========================================================================*/
BOOL Apci8102wGetDirections(WORD wLogSlot, PDWORD pdwDirections)
{
	BOOL	Result = FALSE;
	if (hDLL != NULL)
		Result = (*pApci8102GetDirections)(wLogSlot, pdwDirections);
	return Result;
}
/*============================================================================
// 	  ިڸ݂Ă
// 	  wLogSlot		ިڸ݂Ă޲̘_ۯĔԍ
//		  dwDirections	Ăިڸ݂̓e
// ߂l  TRUE
//		  s FALSE
//==========================================================================*/
BOOL Apci8102wSetDirections(WORD wLogSlot, DWORD dwDirections)
{
	BOOL	Result = FALSE;
	if (hDLL != NULL)
		Result = (*pApci8102SetDirections)(wLogSlot, dwDirections);
	return Result;
}
/*----------------------------------------------------------------------------
// 	  DLL߰Ċ֐ڽ̎擾
// 	  
// ߂l  TRUE
//		  s FALSE
//--------------------------------------------------------------------------*/
static BOOL Apci8102wGetDllExportFunc()
{
	/* Apci8102GetVersion ̱ڽ擾 */
	pApci8102GetVersion = GetProcAddress(hDLL, _T("Apci8102GetVersion"));
	if (pApci8102GetVersion == NULL)
		return FALSE;

	/* Apci8102Create ̱ڽ擾 */
	pApci8102Create = GetProcAddress(hDLL, _T("Apci8102Create"));
	if (pApci8102Create == NULL)
		return FALSE;

	/* Apci8102Close ̱ڽ擾 */
	pApci8102Close = GetProcAddress(hDLL, _T("Apci8102Close"));
	if (pApci8102Close == NULL)
		return FALSE;

	/* Apci8102GetResource ̱ڽ擾 */
	pApci8102GetResource = GetProcAddress(hDLL, _T("Apci8102GetResource"));
	if (pApci8102GetResource == NULL)
		return FALSE;

	/* Apci8102InPort ̱ڽ擾 */
	pApci8102InPort = GetProcAddress(hDLL, _T("Apci8102InPort"));
	if (pApci8102InPort == NULL)
		return FALSE;

	/* Apci8102OutPort ̱ڽ擾 */
	pApci8102OutPort = GetProcAddress(hDLL, _T("Apci8102OutPort"));
	if (pApci8102OutPort == NULL)
		return FALSE;

	/* Apci8102GetLastError ̱ڽ擾 */
	pApci8102GetLastError = GetProcAddress(hDLL, _T("Apci8102GetLastError"));
	if (pApci8102GetLastError == NULL)
		return FALSE;

	/* Apci8102GetDirections ̱ڽ擾 */
	pApci8102GetDirections = GetProcAddress(hDLL, _T("Apci8102GetDirections"));
	if (pApci8102GetDirections == NULL)
		return FALSE;

	/* Apci8102SetDirections ̱ڽ擾 */
	pApci8102SetDirections = GetProcAddress(hDLL, _T("Apci8102SetDirections"));
	if (pApci8102SetDirections == NULL)
		return FALSE;

	return TRUE;	/* SĂ DLL ߰Ċ֐ڽ擾 */
}
