/*============================================================================
//	apci8102s.c
//
//	aPCI-8102
//
//	Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
//
//	V1.11 Date 1999/09/10
//
//	̿ɂׯ߰֐̎gpႪLqĂ܂B
//
//==========================================================================*/
#define	STRICT
#include <windows.h>
#include <tchar.h>
#include "apci8102w.h"

const TCHAR szTitle[] = _T("Sample");
const TCHAR sz8102[]  = _T("aPCI-8102");

static void ResultMessage(LPCTSTR lpszbuf);
static void ErrorMessage(WORD wLogSlot);

/*============================================================================
//	۸т̊Jn
//===========================================================================*/
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
	WORD  wLogSlot;				/* ޲̘_ۯĔԍi[ */
	APCI8102RESOURCE Ri;		/* ؿ */
	DWORD dwDLLVer, dwDriverVer;
	DWORD dwDirections;			/* ިڸ */
	BYTE  cbDat;
	BOOL  bResult;				/*  */
	TCHAR szBuf[256];

	/*-------------------------------------------------
	// apci8102.dll ̎gp錾
	//-----------------------------------------------*/
	if (Apci8102wDllOpen() == FALSE){
		ErrorMessage(APCI8102_SLOT_AUTO);
		return 1;				/* apci8102.dll ۰ނɎs܂ */
	}
	/*-------------------------------------------------
	// ްޮݔԍ\
	// aPCI-8102 DLL,ײްްޮݔԍ擾
	//-----------------------------------------------*/
	if (Apci8102wGetVersion(&dwDLLVer, &dwDriverVer) == FALSE){
		ErrorMessage(APCI8102_SLOT_AUTO);
		return 1;
	}
	wsprintf(szBuf, _T("GetVersion\n")
					_T("DLL    Version\t: %08lxh\n")
					_T("Driver Version\t: %08lxh"),
					dwDLLVer,
					dwDriverVer);
	ResultMessage(szBuf);
	/*-------------------------------------------------
	// aPCI-8102̎gp錾
	//-----------------------------------------------*/
	wLogSlot = APCI8102_SLOT_AUTO;			/* gp޲T܂B*/
	bResult = Apci8102wCreate(&wLogSlot);	/* ꍇA̎޲̘_ۯĔԍi[܂B */
	if (bResult == FALSE){					/* ޲܂B*/
		ErrorMessage(APCI8102_SLOT_AUTO);
		return 1;
	}
	wsprintf(szBuf, _T("aPCI-8102 Created\n\n")
					_T("LogSlot: %2d"),
					 wLogSlot);
	ResultMessage(szBuf);
	/*-------------------------------------------------
	// ؿ擾
	//-----------------------------------------------*/
	if (Apci8102wGetResource(wLogSlot, &Ri) == FALSE){
		ErrorMessage(wLogSlot);
		return 1;
	}
	wsprintf(szBuf, _T("Board Name: %s\n")
					_T("IO Address: %04xh-%04xh\n"),
					sz8102,
					Ri.dwIOPortBase[0],
					Ri.dwIOPortBase[0] + Ri.dwIOPortLength[0] - 1);
	ResultMessage(szBuf);
	/*-------------------------------------------------
	// Port A ިڸ݂o͂ɐݒ肷
	//-----------------------------------------------*/
	if (Apci8102wGetDirections(wLogSlot, &dwDirections) == FALSE){
		ErrorMessage(wLogSlot);
		return 1;
	}
	dwDirections = ~APCI8102_DIR_A_INPUT & dwDirections;	/* A Port ޯĂo͂ɕύX */
	if (Apci8102wSetDirections(wLogSlot, dwDirections) == FALSE){
		ErrorMessage(wLogSlot);
		return 1;
	}
	ResultMessage(_T("Port A ̃fBNVo͂ɕύX"));
	/*-------------------------------------------------
	// Port A ɔCӂްo
	//-----------------------------------------------*/
	cbDat = (BYTE)0xAA;
	if (Apci8102wOutPort(wLogSlot, APCI8102_PORT_A, cbDat) == FALSE){
		ErrorMessage(wLogSlot);
		return 1;
	}
	wsprintf(szBuf, _T("Port A փf[^o\n")
					_T("Port A Out Data: %02xh"),
					 cbDat);
	ResultMessage(szBuf);
	/*-------------------------------------------------
	// Port A ިڸ݂͂ɐݒ
	//-----------------------------------------------*/
	if (Apci8102wGetDirections(wLogSlot, &dwDirections) == FALSE){
		ErrorMessage(wLogSlot);
		return 1;
	}
	dwDirections = APCI8102_DIR_A_INPUT | dwDirections;	/* A Port ޯĂ͂ɕύX */
	if (Apci8102wSetDirections(wLogSlot, dwDirections) == FALSE){
		ErrorMessage(wLogSlot);
		return 1;
	}
	ResultMessage(_T("Port A ̃fBNV͂ɕύX"));
	/*-------------------------------------------------
	// Port A ްǂݍ
	//-----------------------------------------------*/
	cbDat = (BYTE)0x00;
	if (Apci8102wInPort(wLogSlot, APCI8102_PORT_A, &cbDat) == FALSE){
		ErrorMessage(wLogSlot);
		return 1;
	}
	wsprintf(szBuf, _T("Port A f[^\n")
					_T("Port A In Data: %02xh"),
					 cbDat);
	ResultMessage(szBuf);
	/*-------------------------------------------------
	// aPCI-8102̎gpJ
	//-----------------------------------------------*/
	if (Apci8102wClose(wLogSlot) == FALSE){
		ErrorMessage(wLogSlot);
		return 1;
	}
	ResultMessage(_T("aPCI-8102 Closed"));
	/*-------------------------------------------------
	// apci8102.dll ̎gpJ
	//-----------------------------------------------*/
	if (Apci8102wDllClose() == FALSE){
		MessageBox(NULL, _T("DLL ̃A[hɎs܂B"), szTitle, MB_OK | MB_ICONSTOP);
		return 1;
	}
	return 0;
}
/*============================================================================
// ʂ\
//===========================================================================*/
static void ResultMessage(LPCTSTR lpszbuf)
{
	MessageBox(NULL, lpszbuf, szTitle, MB_OK | MB_ICONINFORMATION);
}
/*============================================================================
// װүނ\
//===========================================================================*/
static void ErrorMessage(WORD wLogSlot)
{
	DWORD dwRes = Apci8102wGetLastError(wLogSlot);
	TCHAR szBuf[50];

	switch (dwRes){
		case APCI8102_ERR_SYSTEM:
			wsprintf(szBuf, _T("System error\n\n")
							_T("Error code: %08lxh"),
							GetLastError());
			break;
		case APCI8102_ERR_WRAPDLL:
			wsprintf(szBuf, _T("DLL Load error"));
			break;
		default:
			wsprintf(szBuf, _T("aPCI-8102 error\n\n")
							_T("Error code: %08lxh"),
							dwRes);
			break;
	}
	MessageBox(NULL, szBuf, szTitle, MB_OK | MB_ICONSTOP);
}
