/************************************************************************/
/*		aPCI-8102 Device Driver for Windows 95/NT						*/
/*																		*/
/*			apci8102.h	-	Win32 interface definition					*/
/*			date		-	1999/05/24									*/
/************************************************************************/

#if !defined( APCI8102_H )
#define	APCI8102_H

#ifdef	__cplusplus
extern	"C" {
#endif

/*==================*/
/*	Error Code		*/
/*==================*/
#define	APCI8102_SUCCESS				0	/* Successfully proccessed */
#define	APCI8102_ERR_SYSTEM				1	/* Call GetLastError() */
#define	APCI8102_ERR_NO_DEVICE			2	/* No card */
#define	APCI8102_ERR_IN_USE				3	/* Device is in use */
#define	APCI8102_ERR_INVALID_SLOT		4	/* Invalid slot number */
#define	APCI8102_ERR_RESOURCE			5	/* Resource exhaustion */
#define	APCI8102_ERR_INVALID_PORT		6	/* Invalid port */
#define	APCI8102_ERR_INVALID_ARGUMENT	7	/* Invalid argument */
#define	APCI8102_ERR_NO_CREATE			8	/* No created device */
#define APCI8102_ERR_BAD_COMMAND		9	/* Bad command */
#define	APCI8102_ERR_INVALID_MODE		10	/* Invalid mode */

/*==========================================*/
/*	aPCI-8102 card's relative port address	*/
/*==========================================*/
#define	APCI8102_PORT_A		0
#define	APCI8102_PORT_B		1
#define	APCI8102_PORT_C		2
#define	APCI8102_PORT_D		3

/*======================================*/
/*	aPCI-P8102 card's I/O directions	*/
/*======================================*/
#define APCI8102_DIR_A_OUTPUT	(0 << 0)
#define APCI8102_DIR_A_INPUT	(1 << 0)
#define APCI8102_DIR_B_OUTPUT	(0 << 1)
#define APCI8102_DIR_B_INPUT	(1 << 1)
#define APCI8102_DIR_C_OUTPUT	(0 << 2)
#define APCI8102_DIR_C_INPUT	(1 << 2)
#define APCI8102_DIR_D_OUTPUT	(0 << 3)
#define APCI8102_DIR_D_INPUT	(1 << 3)

/*==================*/
/*	Miscellaneous	*/
/*==================*/
#define	APCI8102_MAX_SLOTS	16			/* Maximum number of slots */
#define APCI8102_MAX_PORTS	4			/* Maximum number of user ports */

										/* default search */
#define	APCI8102_SLOT_AUTO		( ( WORD ) ~0U )

/*==============*/
/*	Device ID	*/
/*==============*/
#define	APCI8102_BOARD_ID		0x8102	/* pci bus device id */
#define	APCI8102_VENDOR_ID		0x136c	/* pci bus vendor id */
										/* our device id */
#define	APCI8102_DEVICE_ID	( ( DWORD )APCI8102_BOARD_ID\
							| ( ( DWORD )APCI8102_VENDOR_ID << 16 ) )

/*==================================*/
/*	Resource infomation structure	*/
/*==================================*/
#define	APCI8102_MAX_MEM	9			/* number of memory windows */
#define	APCI8102_MAX_IO		20			/* number of i/o windows */
#define	APCI8102_MAX_IRQ	7			/* number of irqs */
#define	APCI8102_MAX_DMA	7			/* number of dmas */

typedef	struct	_APCI8102RESOURCE {
	DWORD	dwNumMemWindows;					/* Not used */
	DWORD	dwMemBase		[APCI8102_MAX_MEM];	/* Not used */
	DWORD	dwMemLength		[APCI8102_MAX_MEM];	/* Not used */
	DWORD	dwMemAttrib		[APCI8102_MAX_MEM];	/* Not used */
	DWORD	dwNumIOPorts;						/* Num IO ports */
	DWORD	dwIOPortBase	[APCI8102_MAX_IO];	/* I/O port base */
	DWORD	dwIOPortLength	[APCI8102_MAX_IO];	/* I/O port length */
	DWORD	dwNumIRQs;							/* Not used */
	DWORD	dwIRQRegisters	[APCI8102_MAX_IRQ];	/* Not used */
	DWORD	dwIRQAttrib		[APCI8102_MAX_IRQ];	/* Not used */
	DWORD	dwNumDMAs;							/* Not used */
	DWORD	dwDMALst		[APCI8102_MAX_DMA];	/* Not used */
	DWORD	dwDMAAttrib		[APCI8102_MAX_DMA];	/* Not used */
	DWORD	dwReserved1		[3];				/* Not used */
} APCI8102RESOURCE, *PAPCI8102R;

#if !defined( APCI8102_DRIVER )
#define	APCI8102_API

#if !defined( APCI8102_DLL )
	#define APCI8102LIB_API	extern __declspec( dllimport )
#else
	#define APCI8102LIB_API	extern __declspec( dllexport )
#endif

#ifdef _BORLANDC_
	#define EXPVAR			__pascal
#else
	#define	EXPVAR
#endif

/*==================*/
/*	API Functions	*/
/*==================*/

APCI8102LIB_API BOOL	WINAPI	Apci8102GetVersion( PDWORD pdwDllVersion, PDWORD pdwDriverVersion );
APCI8102LIB_API BOOL	WINAPI	Apci8102Create( PWORD pwLogSlot );
APCI8102LIB_API BOOL	WINAPI	Apci8102Close( WORD wLogSlot );
APCI8102LIB_API BOOL	WINAPI	Apci8102GetResource( WORD wLogSlot, PAPCI8102R pres );
APCI8102LIB_API BOOL	WINAPI	Apci8102GetDirections(WORD wLogSlot, PDWORD pdwDirections);
APCI8102LIB_API BOOL	WINAPI	Apci8102SetDirections(WORD wLogSlot, DWORD dwDirections);
APCI8102LIB_API BOOL	WINAPI	Apci8102InPort( WORD wLogSlot, DWORD dwLogPort, PBYTE pbInValue );
APCI8102LIB_API BOOL	WINAPI	Apci8102OutPort( WORD wLogSlot, DWORD dwLogPort, BYTE bOutValue );
APCI8102LIB_API DWORD	WINAPI	Apci8102GetLastError( WORD wLogSlot );

#endif	/* #if !defined( APCI8102_DRIVER ) */

#ifdef	__cplusplus
}
#endif

#endif	/* #if !defined( APCI8102_H ) */

/**/