//============================================================================
//	apci8102w.pas
//
//	Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
//
//	V1.11 Date 1999/09/10
//
//============================================================================

unit apci8102w;

interface

uses
	Windows;

//-------------------------------------
// װޒ萔
//-------------------------------------
const
	APCI8102_SUCCESS				      = 0;	// I
	APCI8102_ERR_SYSTEM			      = 1;	// GetLastError sĂ
	APCI8102_ERR_NO_DEVICE		    = 2;	// gp\޲Ȃ
	APCI8102_ERR_IN_USE			      = 3;	// w肳ꂽ޲͎gp
	APCI8102_ERR_INVALID_SLOT		  = 4;  // Ș_ۯĔԍw肵
	APCI8102_ERR_RESOURCE			    = 5;	// ؿװ
	APCI8102_ERR_INVALID_PORT     = 6;	// ȃ|[gv
	APCI8102_ERR_INVALID_ARGUMENT = 7;	// Ȉv
	APCI8102_ERR_NO_CREATE				= 8;	// ޲شĂĂ܂
	APCI8102_ERR_WRAPDLL 					=Dword(-1); 	// ׯ߰֐װ
//-------------------------------------
// ߰Ĕԍ萔
//-------------------------------------
	APCI8102_PORT_A	= 0;
	APCI8102_PORT_B	= 1;
	APCI8102_PORT_C	= 2;
	APCI8102_PORT_D	= 3;
//-------------------------------------
// ߰Ăިڸݒ萔
//-------------------------------------
	APCI8102_DIR_A_OUTPUT	=	$00;
	APCI8102_DIR_A_INPUT	=	$01;
	APCI8102_DIR_B_OUTPUT	=	$00;
	APCI8102_DIR_B_INPUT	=	$02;
	APCI8102_DIR_C_OUTPUT	=	$00;
	APCI8102_DIR_C_INPUT	=	$04;
	APCI8102_DIR_D_OUTPUT	=	$00;
	APCI8102_DIR_D_INPUT	=	$08;
//-------------------------------------
// ̑萔
//-------------------------------------
	APCI8102_DLL_NAME 	= 'apci8102.dll';	// DLĻٖ
	APCI8102_MAX_PORTS	= 4;							// ߰Đ
	APCI8102_MAX_SLOTS	= 16;							// őۯĐ
	APCI8102_DEVICE_ID	= $136c8102;			// ޲ID
	APCI8102_SLOT_AUTO	= $ffff;					// AutoSlotl
//-------------------------------------
// ؿ\
//-------------------------------------
	APCI8102_MAX_MEM	=	 9;
	APCI8102_MAX_IO		= 20;
	APCI8102_MAX_IRQ	=	 7;
	APCI8102_MAX_DMA	=	 7;

type
	TAPCI8102RESOURCE = record
		dwNumMemWindows:																	DWORD;	// س޳(gp)
		dwMemBase:			array [1 .. APCI8102_MAX_MEM] of	DWORD;	// س޳ްڽ(gp)
		dwMemLength:		array [1 .. APCI8102_MAX_MEM] of	DWORD;	// س޳(gp)
		dwMemAttrib:		array [1 .. APCI8102_MAX_MEM] of	DWORD;	// س޳(gp)
		dwNumIOPorts:																			DWORD;	// I/O߰Đ
		dwIOPortBase:		array [1 .. APCI8102_MAX_IO] of		DWORD;	// I/O߰ްڽ
		dwIOPortLength: array [1 .. APCI8102_MAX_IO] of		DWORD;	// I/O߰Ē
		dwNumIRQs:																				DWORD;	// IRQ(gp)
		dwIRQRegisters: array [1 .. APCI8102_MAX_IRQ] of	DWORD;	// IRQؽ(gp)
		dwIRQAttrib:		array [1 .. APCI8102_MAX_IRQ] of	DWORD;	// IRQؽ(gp)
		dwNumDMAs:																				DWORD;	// DMAِ(gp)
		dwDMALst:				array [1 .. APCI8102_MAX_DMA] of	DWORD;	// DMAؽ(gp)
		dwDMAAttrib:		array [1 .. APCI8102_MAX_DMA] of	DWORD;	// DMAّؽ(gp)
		dwReserved1:		array [1 .. 3] of									DWORD;	// \(gp)
	end;
//-------------------------------------
// J֐
//-------------------------------------
// DLL ۰
function Apci8102wDllOpen: Boolean;
// DLL ۰
function Apci8102wDllClose: Boolean;
// aPCI-8102 DLL,޲ײްްޮݔԍ擾
function Apci8102wGetVersion(var pdwDllVersion:DWord; var pdwDriverVersion:DWord): Boolean;
// CӂaPCI-8102̎gp錾
function Apci8102wCreate(var pwLogSlot:Word): Boolean;
// CӂaPCI-8102̎gpJ
function Apci8102wClose(wLogSlot:Word): Boolean;
// ؿ擾
function Apci8102wGetResource(wLogSlot:Word; var pResInfo:TAPCI8102RESOURCE): Boolean;
// Cӂ߰Ăް
function Apci8102wInPort(wLogSlot:Word; dwLogPort:DWord; var pbInValue:Byte): Boolean;
// Cӂ߰Ăްo
function Apci8102wOutPort(wLogSlot:Word; dwLogPort:DWord; bOutValue:Byte): Boolean;
// aPCI-8102̴װ
function Apci8102wGetLastError(wLogSlot:Word): DWord;
// ިڸ݂̏Ԃ擾
function Apci8102wGetDirections(wLogSlot:Word; var pdwDirections:DWord): Boolean;
// ިڸ݂
function Apci8102wSetDirections(wLogSlot:Word; dwDirections:DWord): Boolean;

//-------------------------------------
// (STATIC)ϐȂ
//-------------------------------------
implementation

{$J+}	// ^t萔̕ύX\߲׎w
const
	hDLL: THandle = 0;

type
	TApci8102GetVersion = function(var pdwDllVersion:DWORD; var pdwDriverVersion:DWORD): BOOL; stdcall;
	TApci8102Create = function(var pwLogSlot:Word): BOOL; stdcall;
	TApci8102Close = function(wLogSlot:WORD): BOOL; stdcall;
	TApci8102GetResource = function(wLogSlot:WORD; var pres:TAPCI8102RESOURCE): BOOL; stdcall;
	TApci8102InPort = function(wLogSlot:WORD; dwLogPort:DWORD; var pbInValue:BYTE): BOOL; stdcall;
	TApci8102OutPort = function(wLogSlot:WORD; dwLogPort:DWORD; bOutValue:BYTE): BOOL; stdcall;
	TApci8102GetLastError = function(wLogSlot:WORD): DWORD; stdcall;
	TApci8102GetDirections = function(wLogSlot:WORD; var pdwDirections:DWORD): BOOL; stdcall;
	TApci8102SetDirections = function(wLogSlot:WORD; dwDirections:DWORD): BOOL; stdcall;

// DLL ߰Ċ֐ڽ̊i[ϐ
var
	pApci8102GetVersion: TApci8102GetVersion;
	pApci8102Create: TApci8102Create;
	pApci8102Close: TApci8102Close;
	pApci8102GetResource: TApci8102GetResource;
	pApci8102InPort: TApci8102InPort;
	pApci8102OutPort: TApci8102OutPort;
	pApci8102GetLastError: TApci8102GetLastError;
	pApci8102GetDirections: TApci8102GetDirections;
	pApci8102SetDirections: TApci8102SetDirections;

function Apci8102wGetDllExportFunc: Boolean; forward;

{$J-}

//============================================================================
// 		apci8102.dll۰(۰ގʹװƂ)
// 		
// ߂l  True
//				s False
//============================================================================
function Apci8102wDllOpen: Boolean;
begin
	Result := False;
	if hDLL = 0 then begin
		hDLL := LoadLibrary(APCI8102_DLL_NAME);
		if hDLL <> 0 then begin
			Result := Apci8102wGetDllExportFunc;
			if Result <> True then
				Apci8102wDllClose;		// DLL֐擾ɎŝDLL۰
		end;
	end;
end;
//============================================================================
// 		apci8102.dll۰(۰ގʹװƂ)
// 		
// ߂l  True
//				s False
//============================================================================
function Apci8102wDllClose: Boolean;
begin
	Result := False;
	if hDLL <> 0 then begin
		Result := FreeLibrary(hDLL);
		if Result = True then begin
			hDLL := 0;
		end;
	end;
end;
//============================================================================
// 		aPCI-8102 DLL,޲ײްްޮݔԍ擾
// 		pdwDllVersion			DLLްޮݔԍi[̈ւ߲
//				pdwDriverVersion	޲ײްްޮݔԍi[̈ւ߲
// ߂l  True
//				s False
//============================================================================
function Apci8102wGetVersion(var pdwDllVersion:DWord; var pdwDriverVersion:DWord): Boolean;
begin
	Result := False;
	if hDLL <> 0 then
		Result := pApci8102GetVersion(pdwDllVersion, pdwDriverVersion)
end;
//============================================================================
// 		aPCI-8102̔Cӂ޲̎gp錾
// 		pwLogSlot	 gp޲̘_ۯĔԍi[߲
// ߂l  True
//				s False
//============================================================================
function Apci8102wCreate(var pwLogSlot:Word): Boolean;
begin
	Result := False;
	if hDLL <> 0 then
		Result := pApci8102Create(pwLogSlot)
end;
//============================================================================
// 		aPCI-8102̔Cӂ޲̎gpJ
// 		wLogSlot ޲̘_ۯĔԍ
// ߂l  True
//				s False
//============================================================================
function Apci8102wClose(wLogSlot:Word): Boolean;
begin
	Result := False;
	if hDLL <> 0 then
		Result := pApci8102Close(wLogSlot)
end;
//============================================================================
// 		w޲ؿ擾
// 		wLogSlot	ؿ擾޲̘_ۯĔԍ
//				pResInfo	ؿi[\߲̂
// ߂l  True
//				s False
//============================================================================
function Apci8102wGetResource(wLogSlot:Word; var pResInfo:TAPCI8102RESOURCE): Boolean;
begin
	Result := False;
	if hDLL <> 0 then
		Result := pApci8102GetResource(wLogSlot, pResInfo)
end;
//============================================================================
// 		Cӂ߰Ăް
// 		wLogSlot	͂޲̘_ۯĔԍ
//				dwLogPort	͂_߰
//				pbInValue ްi[̈ւ߲
// ߂l  True
//				s False
//============================================================================
function Apci8102wInPort(wLogSlot:Word; dwLogPort:DWord; var pbInValue:Byte): Boolean;
begin
	Result := False;
	if hDLL <> 0 then
		Result := pApci8102InPort(wLogSlot, dwLogPort, pbInValue)
end;
//============================================================================
// 		Cӂ߰Ăްo
// 		wLogSlot	o͂޲̘_ۯĔԍ
//				dwLogPort	o͂_߰
//				bOutValue o͂ް
// ߂l  True
//				s False
//============================================================================
function Apci8102wOutPort(wLogSlot:Word; dwLogPort:DWord; bOutValue:Byte): Boolean;
begin
	Result := False;
	if hDLL <> 0 then
		Result := pApci8102OutPort(wLogSlot, dwLogPort, bOutValue)
end;
//============================================================================
// 		aPCI-8102̴װ
// 		wLogSlot	װ޲̘_ۯĔԍ
// ߂l װ
//============================================================================
function Apci8102wGetLastError(wLogSlot:Word): DWord;
begin
	if hDLL = 0 then Result := APCI8102_ERR_WRAPDLL
	else Result := pApci8102GetLastError(wLogSlot)
end;
//============================================================================
// 	  ިڸ݂̏Ԃ擾
// 	  wLogSlot			ިڸ݂̏Ԃ擾޲̘_ۯĔԍ
//			  pdwDirections ިڸݏԂi[̈ւ߲
// ߂l  TRUE
//			  s FALSE
//============================================================================
function Apci8102wGetDirections(wLogSlot:Word; var pdwDirections:DWord): Boolean;
begin
	Result := False;
	if hDLL <> 0 then
		Result := pApci8102GetDirections(wLogSlot, pdwDirections)
end;
//============================================================================
// 	  ިڸ݂Ă
// 	  wLogSlot			ިڸ݂Ă޲̘_ۯĔԍ
//			  dwDirections	Ăިڸ݂̓e
// ߂l  TRUE
//			  s FALSE
//============================================================================
function Apci8102wSetDirections(wLogSlot:Word; dwDirections:DWord): Boolean;
begin
	Result := False;
	if hDLL <> 0 then
		Result := pApci8102SetDirections(wLogSlot, dwDirections)
end;
//---------------------------------------------------------------------------
// 	  DLL߰Ċ֐ڽ̎擾
// 	  
// ߂l  True
//		  	s False
//---------------------------------------------------------------------------
function Apci8102wGetDllExportFunc: Boolean;
begin
	Result := False;
	// Apci8102GetVersion ̱ڽ擾
	pApci8102GetVersion := GetProcAddress(hDLL, 'Apci8102GetVersion');
	if @pApci8102GetVersion = nil then Exit;
	// Apci8102Create ̱ڽ擾
	pApci8102Create := GetProcAddress(hDLL, 'Apci8102Create');
	if @pApci8102Create = nil then Exit;
	// Apci8102Close ̱ڽ擾
	pApci8102Close := GetProcAddress(hDLL, 'Apci8102Close');
	if @pApci8102Close = nil then Exit;
	// Apci8102GetResource ̱ڽ擾
	pApci8102GetResource := GetProcAddress(hDLL, 'Apci8102GetResource');
	if @pApci8102GetResource = nil then Exit;
	// Apci8102InPort ̱ڽ擾
	pApci8102InPort := GetProcAddress(hDLL, 'Apci8102InPort');
	if @pApci8102InPort = nil then Exit;
	// Apci8102OutPort ̱ڽ擾
	pApci8102OutPort := GetProcAddress(hDLL, 'Apci8102OutPort');
	if @pApci8102OutPort = nil then Exit;
	// Apci8102GetLastError ̱ڽ擾
	pApci8102GetLastError := GetProcAddress(hDLL, 'Apci8102GetLastError');
	if @pApci8102GetLastError = nil then Exit;
	// Apci8102GetDirections ̱ڽ擾
	pApci8102GetDirections := GetProcAddress(hDLL, 'Apci8102GetDirections');
	if @pApci8102GetDirections = nil then Exit;
	// Apci8102SetDirections ̱ڽ擾
	pApci8102SetDirections := GetProcAddress(hDLL, 'Apci8102SetDirections');
	if @pApci8102SetDirections = nil then Exit;
	// SĂ DLL ߰Ċ֐ڽ擾nj
	Result := True;
end;

end.

