//============================================================================
//	apci8102.pas
//
//	aPCI-8102
//
//	Copyright ADTEK SYSTEM SCIENCE Co.,Ltd.
//
//	V1.11 Date 1999/09/10
//
//	̿ɂׯ߰֐̎gpႪLqĂ܂B
//
//============================================================================
unit apci8102s;

interface

uses
	Windows, Messages, SysUtils, Forms, apci8102w;

const
	szTitle = 'Sample';
	sz8102  = 'aPCI-8102';

type
	TForm1 = class(TForm)
		procedure FormCreate(Sender: TObject);
	private
		procedure ResultMessage(szBuf: String);
		procedure ErrorMessage(wLogSlot: Word);
	public
		{ Public 錾 }
	end;

var
	Form1: TForm1;

implementation

{$R *.DFM}

//============================================================================
//	۸т̊Jn
//============================================================================
procedure TForm1.FormCreate(Sender: TObject);
var
	wLogSlot:	Word;							  // ޲̘_ۯĔԍi[
	Ri:				TAPCI8102RESOURCE;	// ؿ
	dwDLLVer, dwDriverVer: DWord;
	dwDirections: Dword;          // ިڸ
	cbDat:		Byte;
	bResult:	Boolean;				   	// 
	szBuf:		String;
begin
	//-------------------------------------------------
	// apci8102.dll ̎gp錾
	//-------------------------------------------------
	if Apci8102wDllOpen() = False then begin
		ErrorMessage(APCI8102_SLOT_AUTO);
		Exit;											// apci8102.dll ۰ނɎs܂
	end;
	//-------------------------------------------------
	// ްޮݔԍ\
	// aPCI-8102 DLL,ײްްޮݔԍ擾
	//-------------------------------------------------
	if Apci8102wGetVersion(dwDLLVer, dwDriverVer) = False then begin
		ErrorMessage(APCI8102_SLOT_AUTO);
		Exit;
	end;

	szBuf := Format('GetVersion'#10 +
									'DLL Version'#09+ ': %08xH'#10 +
									'Driver Version'#09+ ': %08xH',
									[dwDLLVer, dwDriverVer]);
	ResultMessage(szBuf);
	//-------------------------------------------------
	// aPCI-8102̎gp錾
	//-------------------------------------------------
	wLogSlot := APCI8102_SLOT_AUTO;				// gp޲T܂B
	bResult := Apci8102wCreate(wLogSlot);	// ꍇA̎޲̘_ۯĔԍi[܂B
	if bResult = False then begin					// ޲܂B
		ErrorMessage(APCI8102_SLOT_AUTO);
		Exit;
	end;
	szBuf := Format('aPCI-8102 Created'#10#10 +
									'LogSlot: %2d'
									,[wLogSlot]);
	ResultMessage(szBuf);
	//-------------------------------------------------
	// ؿ擾
	//-------------------------------------------------
	if Apci8102wGetResource(wLogSlot, Ri) = False then begin
		ErrorMessage(wLogSlot);
		Exit;
	end;

	szBuf := Format( 'Board Name: %s'#10 +
									 'IO Address: %04xH-%04xH',
									 [sz8102,
										Ri.dwIOPortBase[1],
										Ri.dwIOPortBase[1] + Ri.dwIOPortLength[1] - 1]);
	ResultMessage(szBuf);
	//-------------------------------------------------
	// Port A ިڸ݂o͂ɐݒ肷
	//-------------------------------------------------
	if Apci8102wGetDirections(wLogSlot, dwDirections) = False then begin
		ErrorMessage(wLogSlot);
		Exit;
	end;
	dwDirections := (not APCI8102_DIR_A_INPUT) and dwDirections;	// A Port ޯĂo͂ɕύX
	if Apci8102wSetDirections(wLogSlot, dwDirections) = False then begin
		ErrorMessage(wLogSlot);
		Exit;
	end;
	ResultMessage('Port A ̃fBNVo͂ɕύX');
	//-------------------------------------------------
	// Port A ɔCӂްo
	//-------------------------------------------------
	cbDat := Byte($AA);
	if Apci8102wOutPort(wLogSlot, APCI8102_PORT_A, cbDat) = False then begin
		ErrorMessage(wLogSlot);
		Exit;
	end;
	szBuf := Format( 'Port A փf[^o'#10 +
					 				 'Port A Out Data: %02xH',
									 [cbDat]);
	ResultMessage(szBuf);
	//-------------------------------------------------
	// Port A ިڸ݂͂ɐݒ
	//-------------------------------------------------
	if Apci8102wGetDirections(wLogSlot, dwDirections) = False then begin
  	ErrorMessage(wLogSlot);
		Exit;
	end;
	dwDirections := APCI8102_DIR_A_INPUT or dwDirections;	// A Port ޯĂ͂ɕύX
	if Apci8102wSetDirections(wLogSlot, dwDirections) = False then begin
		ErrorMessage(wLogSlot);
		Exit;
	end;
	ResultMessage('Port A ̃fBNV͂ɕύX');
	//-------------------------------------------------
	// Port A ްǂݍ
	//-------------------------------------------------
	cbDat := Byte($00);
	if Apci8102wInPort(wLogSlot, APCI8102_PORT_A, cbDat) = False then begin
		ErrorMessage(wLogSlot);
		Exit;
	end;
	szBuf := Format( 'Port A f[^'#10 +
									 'Port A In Data: %02xH',
									 [cbDat]);
	ResultMessage(szBuf);
	//-------------------------------------------------
	// aPCI-8102̎gpJ
	//-------------------------------------------------
	if Apci8102wClose(wLogSlot) = False then begin
		ErrorMessage(wLogSlot);
		Exit;
	end;
	ResultMessage('aPCI-8102 Closed');
	//-------------------------------------------------
	// apci8102.dll ̎gpJ
	//-------------------------------------------------
	if Apci8102wDllClose() = False then begin
		Application.MessageBox(PChar('DLL ̃A[hɎs܂B'), szTitle, MB_OK + MB_ICONSTOP);
		Exit;
	end;
end;

//============================================================================
// ʂ\
//============================================================================
procedure TForm1.ResultMessage(szBuf: String);
begin
	Application.MessageBox(PChar(szBuf), szTitle, MB_OK + MB_ICONINFORMATION);
end;
//============================================================================
// װүނ\
//============================================================================
procedure TForm1.ErrorMessage(wLogSlot: Word);
var
	dwRes: DWord;
	szBuf: String;
begin
	dwRes := Apci8102wGetLastError(wLogSlot);
	case dwRes of
		APCI8102_ERR_SYSTEM:
			szBuf := Format('System error'#10#10'Error code: %08xH', [GetLastError()]);
		APCI8102_ERR_WRAPDLL:
    	szBuf := 'DLL Load error';
		else
			szBuf := Format('aPCI-8102 error'#10#10'Error code: %08xH',[dwRes]);
  end;
	Application.MessageBox(PChar(szBuf), szTitle, MB_OK + MB_ICONSTOP);
end;

end.

